/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.Position;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.command.brigadier.BrigadierCommand;
import net.thenextlvl.portals.command.brigadier.SimpleCommand;
import net.thenextlvl.portals.selection.SelectionProvider;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class PortalCreateCommand
extends SimpleCommand {
    public PortalCreateCommand(PortalsPlugin plugin) {
        super(plugin, "create", "portals.command.create");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        PortalCreateCommand command = new PortalCreateCommand(plugin);
        RequiredArgumentBuilder name = Commands.argument((String)"name", (ArgumentType)StringArgumentType.string());
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)name.then(PortalCreateCommand.boundsArgument(command))).executes((Command)command));
    }

    static RequiredArgumentBuilder<CommandSourceStack, BlockPositionResolver> boundsArgument(Command<CommandSourceStack> command) {
        RequiredArgumentBuilder world = Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world());
        RequiredArgumentBuilder from = Commands.argument((String)"from", (ArgumentType)ArgumentTypes.blockPosition());
        RequiredArgumentBuilder to = Commands.argument((String)"to", (ArgumentType)ArgumentTypes.blockPosition());
        return (RequiredArgumentBuilder)from.then(((RequiredArgumentBuilder)to.executes(command)).then(world.executes(command)));
    }

    @Nullable
    static BoundingBox getBounds(BrigadierCommand command, CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPositionResolver fromResolver = command.tryGetArgument(context, "from", BlockPositionResolver.class).orElse(null);
        BlockPositionResolver toResolver = command.tryGetArgument(context, "to", BlockPositionResolver.class).orElse(null);
        BlockPosition from = fromResolver != null ? (BlockPosition)fromResolver.resolve((CommandSourceStack)context.getSource()) : null;
        BlockPosition to = toResolver != null ? (BlockPosition)toResolver.resolve((CommandSourceStack)context.getSource()) : null;
        World world = command.tryGetArgument(context, "world", World.class).orElse(((CommandSourceStack)context.getSource()).getLocation().getWorld());
        if (from != null && to != null) {
            return BoundingBox.of(world, PortalCreateCommand.min((Position)from, (Position)to), PortalCreateCommand.max((Position)from, (Position)to).offset(1, 1, 1));
        }
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        SelectionProvider provider = (SelectionProvider)command.plugin.getServer().getServicesManager().load(SelectionProvider.class);
        return provider != null ? (BoundingBox)provider.getSelection(player).orElse(null) : null;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = (String)context.getArgument("name", String.class);
        if (this.plugin.portalProvider().hasPortal(name)) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "portal.create.already_exists", new TagResolver[]{Placeholder.parsed((String)"portal", (String)name)});
            return 0;
        }
        BoundingBox boundingBox = PortalCreateCommand.getBounds(this, context);
        if (boundingBox == null) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "portal.selection");
            return 0;
        }
        Portal portal = this.plugin.portalProvider().createPortal(name, boundingBox);
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "portal.create.success", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName())});
        return 1;
    }

    private static Position min(Position pos1, Position pos2) {
        return Position.fine((double)Math.min(pos1.x(), pos2.x()), (double)Math.min(pos1.y(), pos2.y()), (double)Math.min(pos1.z(), pos2.z()));
    }

    private static Position max(Position pos1, Position pos2) {
        return Position.fine((double)Math.max(pos1.x(), pos2.x()), (double)Math.max(pos1.y(), pos2.y()), (double)Math.max(pos1.z(), pos2.z()));
    }
}

