/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.bounds;

import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.Position;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.key.Key;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.bounds.Bounds;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
record SimpleBounds(Key worldKey, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) implements Bounds
{
    private static final PortalsPlugin plugin = (PortalsPlugin)JavaPlugin.getPlugin(PortalsPlugin.class);

    public SimpleBounds(Key worldKey, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
        this.worldKey = worldKey;
    }

    @Override
    public Optional<World> world() {
        return Optional.ofNullable(plugin.getServer().getWorld(this.worldKey));
    }

    @Override
    public BlockPosition minPosition() {
        return Position.block((int)this.minX, (int)this.minY, (int)this.minZ);
    }

    @Override
    public BlockPosition maxPosition() {
        return Position.block((int)this.maxX, (int)this.maxY, (int)this.maxZ);
    }

    @Override
    public CompletableFuture<@Nullable Location> searchSafeLocation(Random random) {
        World world = this.world().orElse(null);
        if (world == null) {
            return CompletableFuture.completedFuture(null);
        }
        WorldBorder border = world.getWorldBorder();
        int borderSize = Math.min((int)border.getSize() / 2, plugin.getServer().getMaxWorldSize());
        int centerX = border.getCenter().getBlockX();
        int centerZ = border.getCenter().getBlockZ();
        int borderMinX = centerX - borderSize;
        int borderMaxX = centerX + borderSize;
        int borderMinZ = centerZ - borderSize;
        int borderMaxZ = centerZ + borderSize;
        int clampedMinX = Math.clamp((long)this.minX, borderMinX, borderMaxX);
        int clampedMaxX = Math.clamp((long)this.maxX, borderMinX, borderMaxX);
        int clampedMinZ = Math.clamp((long)this.minZ, borderMinZ, borderMaxZ);
        int clampedMaxZ = Math.clamp((long)this.maxZ, borderMinZ, borderMaxZ);
        int initialX = clampedMinX == clampedMaxX ? clampedMaxX : random.nextInt(clampedMinX, clampedMaxX);
        int initialZ = clampedMinZ == clampedMaxZ ? clampedMaxZ : random.nextInt(clampedMinZ, clampedMaxZ);
        return ((CompletableFuture)((CompletableFuture)this.searchSafeLocationAtXZ(random, world, initialX, initialZ).thenCompose(location -> {
            if (location != null) {
                return CompletableFuture.completedFuture(location);
            }
            int newX = this.getAlternativeCoordinate(random, initialX, clampedMinX, clampedMaxX);
            return this.searchSafeLocationAtXZ(random, world, newX, initialZ);
        })).thenCompose(location -> {
            if (location != null) {
                return CompletableFuture.completedFuture(location);
            }
            int newZ = this.getAlternativeCoordinate(random, initialZ, clampedMinZ, clampedMaxZ);
            return this.searchSafeLocationAtXZ(random, world, initialX, newZ);
        })).thenCompose(location -> {
            if (location != null) {
                return CompletableFuture.completedFuture(location);
            }
            int newX = this.getAlternativeCoordinate(random, initialX, clampedMinX, clampedMaxX);
            int newZ = this.getAlternativeCoordinate(random, initialZ, clampedMinZ, clampedMaxZ);
            return this.searchSafeLocationAtXZ(random, world, newX, newZ);
        });
    }

    private CompletableFuture<@Nullable Location> searchSafeLocationAtXZ(Random random, World world, int x, int z) {
        int maxY;
        int minY = Math.max(this.minY, world.getMinHeight());
        int startY = minY == (maxY = Math.min(this.maxY, world.getLogicalHeight())) ? maxY : random.nextInt(minY, maxY + 1);
        return world.getChunkAtAsync(x >> 4, z >> 4).thenApply(chunk -> {
            int y;
            for (y = startY; y <= maxY; ++y) {
                if (!this.isSafeLocation(world, x, y, z)) continue;
                return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            }
            for (y = startY - 1; y >= minY; --y) {
                if (!this.isSafeLocation(world, x, y, z)) continue;
                return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            }
            return null;
        });
    }

    private int getAlternativeCoordinate(Random random, int current, int min, int max) {
        if (min == max) {
            return max;
        }
        return random.nextInt(min, max);
    }

    private boolean isSafeLocation(World world, int x, int y, int z) {
        if (!this.isValidSpawn(world.getBlockAt(x, y - 1, z))) {
            return false;
        }
        if (this.isInvalidSpawnInside(world.getBlockAt(x, y, z))) {
            return false;
        }
        return !this.isInvalidSpawnInside(world.getBlockAt(x, y + 1, z));
    }

    private boolean isValidSpawn(Block block) {
        return block.isCollidable() && block.getType().isOccluding() && !block.getType().equals((Object)Material.BEDROCK);
    }

    private boolean isInvalidSpawnInside(Block block) {
        if (block.getLightFromSky() == 0 && !plugin.config().allowCaveSpawns()) {
            return true;
        }
        return !block.isPassable() || block.isLiquid() || block.getType().equals((Object)Material.KELP);
    }

    private boolean isTagged(Block block, TagKey<BlockType> tag) {
        return RegistryAccess.registryAccess().getRegistry(RegistryKey.BLOCK).getTagValues(tag).contains(block.getType().asBlockType());
    }
}

