/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals;

import core.file.FileIO;
import core.file.format.GsonFile;
import core.i18n.file.ComponentBundle;
import core.io.IO;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.math.Position;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.lang.reflect.Type;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalProvider;
import net.thenextlvl.portals.action.ActionTypeRegistry;
import net.thenextlvl.portals.action.ActionTypes;
import net.thenextlvl.portals.action.EntryAction;
import net.thenextlvl.portals.action.SimpleActionTypeRegistry;
import net.thenextlvl.portals.action.SimpleActionTypes;
import net.thenextlvl.portals.adapter.BoundingBoxAdapter;
import net.thenextlvl.portals.adapter.EntryActionAdapter;
import net.thenextlvl.portals.adapter.FinePositionAdapter;
import net.thenextlvl.portals.adapter.KeyAdapter;
import net.thenextlvl.portals.adapter.PortalAdapter;
import net.thenextlvl.portals.bounds.BoundsFactory;
import net.thenextlvl.portals.bounds.SimpleBoundsFactory;
import net.thenextlvl.portals.bstats.bukkit.Metrics;
import net.thenextlvl.portals.command.PortalCommand;
import net.thenextlvl.portals.economy.EconomyProvider;
import net.thenextlvl.portals.economy.EmptyEconomyProvider;
import net.thenextlvl.portals.economy.ServiceEconomyProvider;
import net.thenextlvl.portals.economy.VaultEconomyProvider;
import net.thenextlvl.portals.listener.PortalListener;
import net.thenextlvl.portals.listener.WorldListener;
import net.thenextlvl.portals.model.SimplePortalConfig;
import net.thenextlvl.portals.portal.PaperPortalProvider;
import net.thenextlvl.portals.selection.SelectionProvider;
import net.thenextlvl.portals.selection.WorldEditSelectionProvider;
import net.thenextlvl.portals.shape.BoundingBox;
import net.thenextlvl.portals.view.PortalConfig;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PortalsPlugin
extends JavaPlugin {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/portals/issues/new";
    private final PaperPortalProvider portalProvider = new PaperPortalProvider(this);
    private EconomyProvider economyProvider = new EmptyEconomyProvider();
    private final Metrics metrics = new Metrics((Plugin)this, 27514);
    private final FileIO<SimplePortalConfig> portalConfig = new GsonFile<SimplePortalConfig>((IO)IO.of(this.getDataPath().resolve("config.json")), new SimplePortalConfig(false, true, false, 0.3), (Type)((Object)SimplePortalConfig.class)).validate().save(new FileAttribute[0]);
    private final ComponentBundle bundle = ComponentBundle.builder(Key.key((String)"portals", (String)"translations"), this.getDataPath().resolve("translations")).resource("messages.properties", Locale.US).resource("messages_german.properties", Locale.GERMANY).placeholder("prefix", "prefix").build();

    public PortalsPlugin() {
        StaticBinder.getInstance(ActionTypes.class.getClassLoader()).bind(ActionTypes.class, SimpleActionTypes.INSTANCE);
        StaticBinder.getInstance(BoundsFactory.class.getClassLoader()).bind(BoundsFactory.class, SimpleBoundsFactory.INSTANCE);
        StaticBinder.getInstance(ActionTypeRegistry.class.getClassLoader()).bind(ActionTypeRegistry.class, SimpleActionTypeRegistry.INSTANCE);
        StaticBinder.getInstance(PortalConfig.class.getClassLoader()).bind(PortalConfig.class, (PortalConfig)this.portalConfig.getRoot());
        StaticBinder.getInstance(PortalProvider.class.getClassLoader()).bind(PortalProvider.class, this.portalProvider);
        this.registerCommands();
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)new PortalListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
            this.getServer().getServicesManager().register(SelectionProvider.class, (Object)new WorldEditSelectionProvider(), (Plugin)this, ServicePriority.Normal);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ServiceIO")) {
            this.economyProvider = new ServiceEconomyProvider(this);
        } else if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.economyProvider = new VaultEconomyProvider(this);
        }
    }

    public void onDisable() {
        this.portalProvider.forEachPortal(Portal::persist);
        this.metrics.shutdown();
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(PortalCommand.create(this), "The main command to interact with portals")));
    }

    @Contract(pure=true)
    public PaperPortalProvider portalProvider() {
        return this.portalProvider;
    }

    @Contract(pure=true)
    public EconomyProvider economyProvider() {
        return this.economyProvider;
    }

    @Contract(pure=true)
    public ComponentBundle bundle() {
        return this.bundle;
    }

    @Contract(pure=true)
    public PortalConfig config() {
        return this.portalConfig.getRoot();
    }

    @Contract(value="_ -> new", pure=true)
    public NBT nbt(World world) {
        return NBT.builder().registerTypeHierarchyAdapter((Class<?>)BoundingBox.class, new BoundingBoxAdapter(world)).registerTypeHierarchyAdapter((Class<?>)EntryAction.class, new EntryActionAdapter(this)).registerTypeHierarchyAdapter((Class<?>)Position.class, new FinePositionAdapter()).registerTypeHierarchyAdapter((Class<?>)Key.class, new KeyAdapter()).registerTypeHierarchyAdapter((Class<?>)Portal.class, new PortalAdapter(this)).build();
    }
}

