/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;

@ApiStatus.NonExtendable
public interface PortalProvider {
    @CheckReturnValue
    public static PortalProvider provider() {
        return StaticBinder.getInstance(PortalProvider.class.getClassLoader()).find(PortalProvider.class);
    }

    @Contract(pure=true)
    public Path getDataFolder(World var1);

    @Contract(pure=true)
    public Optional<Portal> getPortal(String var1);

    @Contract(pure=true)
    public Stream<Portal> getPortals();

    @Contract(pure=true)
    public Stream<Portal> getPortals(World var1);

    @Contract(value="_, _ -> new", mutates="this")
    public Portal createPortal(String var1, BoundingBox var2) throws IllegalArgumentException;

    @Contract(pure=true)
    public boolean hasPortal(Portal var1);

    @Contract(pure=true)
    public boolean hasPortal(String var1);

    @Contract(mutates="this,io")
    public boolean deletePortal(Portal var1);

    @Contract(mutates="this,io")
    public boolean deletePortal(String var1);

    public void forEachPortal(Consumer<Portal> var1);
}

