/*
 * Decompiled with CFR 0.152.
 */
package core.paper.gui;

import core.paper.item.ActionItem;
import core.paper.item.ItemBuilder;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AbstractGUI
implements InventoryHolder {
    private final Map<Integer, ActionItem.Action> actions = new HashMap<Integer, ActionItem.Action>();
    private Component title;
    protected final Player owner;

    protected AbstractGUI(Player owner, Component title) {
        this.title = title;
        this.owner = owner;
    }

    public void title(Component title) {
        this.title = title;
    }

    public void clear() {
        this.getInventory().clear();
        this.actions.clear();
    }

    public boolean isEmpty(int slot) {
        return this.getInventory().getItem(slot) == null;
    }

    public void setSlot(int slot, ActionItem item) {
        this.getActions().put(slot, item.action());
        this.getInventory().setItem(slot, item.stack());
    }

    public void setSlot(int slot, ItemBuilder builder) {
        this.getInventory().setItem(slot, builder.item());
    }

    public void setSlot(int slot, ItemStack item) {
        this.getInventory().setItem(slot, item);
        this.getActions().remove(slot);
    }

    public void setSlotIfAbsent(int slot, ItemBuilder builder) {
        if (this.isEmpty(slot)) {
            this.setSlot(slot, builder);
        }
    }

    public void setSlotIfAbsent(int slot, ActionItem item) {
        if (this.isEmpty(slot)) {
            this.setSlot(slot, item);
        }
    }

    public void setSlotIfAbsent(int slot, ItemStack item) {
        if (this.isEmpty(slot)) {
            this.setSlot(slot, item);
        }
    }

    public void remove(int slot) {
        this.getActions().remove(slot);
        this.getInventory().setItem(slot, null);
    }

    public void open() {
        this.owner.openInventory(this.getInventory());
    }

    public void close() {
        this.getInventory().close();
    }

    public Map<Integer, ActionItem.Action> getActions() {
        return this.actions;
    }

    public Component title() {
        return this.title;
    }

    public Player getOwner() {
        return this.owner;
    }
}

