/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.model;

import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;

public record Bounds(World world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
    public Bounds(World world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.world = world;
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public Bounds(World world, Position min, Position max) {
        this(world, min.x(), min.y(), min.z(), max.x(), max.y(), max.z());
    }

    @Contract(value=" -> new", pure=true)
    public FinePosition minPosition() {
        return Position.fine((double)this.minX, (double)this.minY, (double)this.minZ);
    }

    @Contract(value=" -> new", pure=true)
    public FinePosition maxPosition() {
        return Position.fine((double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static Bounds radius(World world, Position center, double radius, double height) {
        return new Bounds(world, center.x() - radius, center.y() - height / 2.0, center.z() - radius, center.x() + radius, center.y() + height / 2.0, center.z() + radius);
    }

    public Location getRandomLocation(Random random) {
        return new Location(this.world, this.minX == this.maxX ? this.maxX : random.nextDouble(this.minX, this.maxX), this.minY == this.maxY ? this.maxY : random.nextDouble(this.minY, this.maxY), this.minZ == this.maxZ ? this.maxZ : random.nextDouble(this.minZ, this.maxZ));
    }
}

