/*
 * Decompiled with CFR 0.152.
 */
package core.paper.scoreboard;

import io.papermc.paper.scoreboard.numbers.NumberFormat;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Sidebar {
    private final Scoreboard scoreboard;
    private final Objective objective;

    public Sidebar(Player player) {
        Objective objective;
        Scoreboard scoreboard = player.getScoreboard();
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (scoreboard.equals((Object)manager.getMainScoreboard())) {
            scoreboard = manager.getNewScoreboard();
            player.setScoreboard(scoreboard);
        }
        if ((objective = scoreboard.getObjective(DisplaySlot.SIDEBAR)) != null) {
            objective.unregister();
        }
        objective = scoreboard.registerNewObjective("sidebar", Criteria.DUMMY, (Component)null);
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.scoreboard = scoreboard;
        this.objective = objective;
    }

    public void unregister() {
        this.scoreboard.clearSlot(DisplaySlot.SIDEBAR);
        this.objective.unregister();
    }

    public Sidebar title(@Nullable Component title) {
        this.objective.displayName(title);
        return this;
    }

    public Sidebar numberFormat(@Nullable NumberFormat format) {
        this.objective.numberFormat(format);
        return this;
    }

    public Sidebar numberFormat(int line, @Nullable NumberFormat format) {
        this.getScore(line).numberFormat(format);
        return this;
    }

    public Sidebar line(int line, @Nullable Component content) {
        this.getTeam(line).prefix(content);
        return this.showLine(line);
    }

    public Sidebar showLine(int line) {
        Score score = this.getScore(line);
        if (!score.isScoreSet()) {
            score.setScore(line);
        }
        return this;
    }

    public Sidebar hideLine(int line) {
        Team team;
        Line value = Line.valueOf(line);
        Score objective = this.objective.getScore(value.color());
        if (objective.isScoreSet()) {
            this.scoreboard.resetScores(value.color());
        }
        if ((team = this.scoreboard.getTeam(value.name())) != null) {
            team.unregister();
        }
        return this;
    }

    private Score getScore(int line) {
        Line value = Line.valueOf(line);
        return this.objective.getScore(value.color());
    }

    private Team getTeam(int line) {
        Line value = Line.valueOf(line);
        Team team = this.scoreboard.getTeam(value.name());
        if (team != null) {
            return team;
        }
        team = this.scoreboard.registerNewTeam(value.name());
        team.addEntry(value.color());
        return team;
    }

    private static enum Line {
        SCORE_1("\u00a71", 1),
        SCORE_2("\u00a72", 2),
        SCORE_3("\u00a73", 3),
        SCORE_4("\u00a74", 4),
        SCORE_5("\u00a75", 5),
        SCORE_6("\u00a76", 6),
        SCORE_7("\u00a77", 7),
        SCORE_8("\u00a78", 8),
        SCORE_9("\u00a79", 9),
        SCORE_10("\u00a70", 10),
        SCORE_11("\u00a7a", 11),
        SCORE_12("\u00a7b", 12),
        SCORE_13("\u00a7c", 13),
        SCORE_14("\u00a7d", 14),
        SCORE_15("\u00a7e", 15);

        private final String color;
        private final int score;

        private static Line valueOf(int line) {
            return Arrays.stream(Line.values()).filter(value -> value.score() == line).findAny().orElseThrow();
        }

        private Line(String color, int score) {
            this.color = color;
            this.score = score;
        }

        public int score() {
            return this.score;
        }

        public String color() {
            return this.color;
        }
    }
}

