/*
 * Decompiled with CFR 0.152.
 */
package core.paper.scoreboard;

import io.papermc.paper.scoreboard.numbers.NumberFormat;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BelowNameScoreboard {
    private final Scoreboard scoreboard;
    private final Objective objective;

    public BelowNameScoreboard(Player player) {
        Objective objective;
        Scoreboard scoreboard = player.getScoreboard();
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (scoreboard.equals((Object)manager.getMainScoreboard())) {
            scoreboard = manager.getNewScoreboard();
            player.setScoreboard(scoreboard);
        }
        if ((objective = scoreboard.getObjective(DisplaySlot.BELOW_NAME)) != null) {
            objective.unregister();
        }
        objective = scoreboard.registerNewObjective("below_name", Criteria.DUMMY, (Component)null);
        objective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        this.scoreboard = scoreboard;
        this.objective = objective;
    }

    public void unregister() {
        this.scoreboard.clearSlot(DisplaySlot.BELOW_NAME);
        this.objective.unregister();
    }

    public BelowNameScoreboard text(@Nullable Component title) {
        this.objective.displayName(title);
        return this;
    }

    public BelowNameScoreboard numberFormat(@Nullable NumberFormat format) {
        this.objective.numberFormat(format);
        return this;
    }
}

