/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.command.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.net.InetSocketAddress;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.action.ActionTypes;
import net.thenextlvl.portals.command.action.ActionCommand;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TransferCommand
extends ActionCommand<InetSocketAddress> {
    private TransferCommand(PortalsPlugin plugin) {
        super(plugin, ActionTypes.types().transfer(), "transfer");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        TransferCommand command = new TransferCommand(plugin);
        RequiredArgumentBuilder hostname = (RequiredArgumentBuilder)Commands.argument((String)"hostname", (ArgumentType)StringArgumentType.string()).executes((Command)command);
        RequiredArgumentBuilder port = (RequiredArgumentBuilder)Commands.argument((String)"port", (ArgumentType)IntegerArgumentType.integer((int)1, (int)65535)).executes((Command)command);
        return (LiteralArgumentBuilder)command.create().then(hostname.then((ArgumentBuilder)port));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        String hostname = (String)context.getArgument("hostname", String.class);
        Integer port = this.tryGetArgument(context, "port", Integer.TYPE).orElse(25565);
        return this.addAction(context, new InetSocketAddress(hostname, (int)port));
    }

    @Override
    protected void onSuccess(CommandContext<CommandSourceStack> context, Portal portal, InetSocketAddress input) {
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "portal.action.transfer", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Placeholder.parsed((String)"hostname", (String)input.getHostString()), Placeholder.parsed((String)"port", (String)String.valueOf(input.getPort()))});
    }
}

