/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.command.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.action.ActionTypes;
import net.thenextlvl.portals.command.action.ActionCommand;
import net.thenextlvl.portals.model.Bounds;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class TeleportRandomCommand
extends ActionCommand<Bounds> {
    private TeleportRandomCommand(PortalsPlugin plugin) {
        super(plugin, ActionTypes.types().teleportRandom(), "teleport-random");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PortalsPlugin plugin) {
        TeleportRandomCommand command = new TeleportRandomCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).then(command.boundsArgument())).then(command.radiusArgument()));
    }

    private ArgumentBuilder<CommandSourceStack, ?> radiusArgument() {
        RequiredArgumentBuilder center = Commands.argument((String)"center", (ArgumentType)ArgumentTypes.finePosition());
        RequiredArgumentBuilder radius = Commands.argument((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg());
        RequiredArgumentBuilder height = Commands.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg());
        return center.then(radius.then(height.executes((Command)this)));
    }

    private ArgumentBuilder<CommandSourceStack, ?> boundsArgument() {
        RequiredArgumentBuilder from = Commands.argument((String)"from", (ArgumentType)ArgumentTypes.finePosition());
        RequiredArgumentBuilder to = Commands.argument((String)"to", (ArgumentType)ArgumentTypes.finePosition());
        return from.then(to.executes((Command)this));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        World world = (World)context.getArgument("world", World.class);
        Bounds bounds = this.resolveArgument(context, "center", FinePositionResolver.class).map(center -> {
            Double radius = (Double)context.getArgument("radius", Double.class);
            Double height = (Double)context.getArgument("height", Double.class);
            return Bounds.radius(world, (Position)center, radius, height);
        }).orElse(null);
        if (bounds == null) {
            FinePosition from = (FinePosition)this.resolveArgument(context, "from", FinePositionResolver.class).orElseThrow();
            FinePosition to = (FinePosition)this.resolveArgument(context, "to", FinePositionResolver.class).orElseThrow();
            bounds = new Bounds(world, (Position)from, (Position)to);
        }
        return this.addAction(context, bounds);
    }

    @Override
    protected void onSuccess(CommandContext<CommandSourceStack> context, Portal portal, Bounds input) {
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "portal.action.teleport-random", new TagResolver[]{Placeholder.parsed((String)"portal", (String)portal.getName()), Placeholder.parsed((String)"world", (String)input.world().getName()), Formatter.number((String)"min_x", (Number)input.minX()), Formatter.number((String)"min_y", (Number)input.minY()), Formatter.number((String)"min_z", (Number)input.minZ()), Formatter.number((String)"max_x", (Number)input.maxX()), Formatter.number((String)"max_y", (Number)input.maxY()), Formatter.number((String)"max_z", (Number)input.maxZ())});
    }
}

