/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.group;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.i18n.ComponentBundle;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.adapters.DurationAdapter;
import net.thenextlvl.nbt.serialization.adapters.EnumAdapter;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.GroupProvider;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.adapter.AdvancementDataAdapter;
import net.thenextlvl.perworlds.adapter.AttributeAdapter;
import net.thenextlvl.perworlds.adapter.AttributeDataAdapter;
import net.thenextlvl.perworlds.adapter.GroupConfigAdapter;
import net.thenextlvl.perworlds.adapter.GroupDataAdapter;
import net.thenextlvl.perworlds.adapter.GroupSettingsAdapter;
import net.thenextlvl.perworlds.adapter.InstantAdapter;
import net.thenextlvl.perworlds.adapter.ItemStackArrayAdapter;
import net.thenextlvl.perworlds.adapter.KeyAdapter;
import net.thenextlvl.perworlds.adapter.LocationAdapter;
import net.thenextlvl.perworlds.adapter.NamespacedKeyAdapter;
import net.thenextlvl.perworlds.adapter.PlayerDataAdapter;
import net.thenextlvl.perworlds.adapter.PotionEffectAdapter;
import net.thenextlvl.perworlds.adapter.PotionEffectTypeAdapter;
import net.thenextlvl.perworlds.adapter.VectorAdapter;
import net.thenextlvl.perworlds.adapter.WardenSpawnTrackerAdapter;
import net.thenextlvl.perworlds.adapter.WorldAdapter;
import net.thenextlvl.perworlds.adapter.WorldBorderAdapter;
import net.thenextlvl.perworlds.adapter.statistic.BlockTypeStatAdapter;
import net.thenextlvl.perworlds.adapter.statistic.CustomStatAdapter;
import net.thenextlvl.perworlds.adapter.statistic.EntityTypeStatAdapter;
import net.thenextlvl.perworlds.adapter.statistic.ItemTypeStatAdapter;
import net.thenextlvl.perworlds.adapter.statistic.StatisticsAdapter;
import net.thenextlvl.perworlds.data.AdvancementData;
import net.thenextlvl.perworlds.data.AttributeData;
import net.thenextlvl.perworlds.data.WardenSpawnTracker;
import net.thenextlvl.perworlds.data.WorldBorderData;
import net.thenextlvl.perworlds.group.PaperGroupData;
import net.thenextlvl.perworlds.group.PaperGroupSettings;
import net.thenextlvl.perworlds.group.PaperUnownedWorldGroup;
import net.thenextlvl.perworlds.group.PaperWorldGroup;
import net.thenextlvl.perworlds.model.PaperPlayerData;
import net.thenextlvl.perworlds.model.config.GroupConfig;
import net.thenextlvl.perworlds.statistics.BlockTypeStat;
import net.thenextlvl.perworlds.statistics.CustomStat;
import net.thenextlvl.perworlds.statistics.EntityTypeStat;
import net.thenextlvl.perworlds.statistics.ItemTypeStat;
import net.thenextlvl.perworlds.statistics.Statistics;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperGroupProvider
implements GroupProvider {
    public final Set<UUID> loadingPlayers = new HashSet<UUID>();
    private final Set<WorldGroup> groups = new HashSet<WorldGroup>();
    private final Path dataFolder;
    private final NBT nbt;
    private final PerWorldsPlugin plugin;
    private final PaperWorldGroup unownedWorldGroup;

    public PaperGroupProvider(PerWorldsPlugin plugin) {
        this.plugin = plugin;
        this.dataFolder = plugin.getDataPath().resolve("groups");
        this.nbt = NBT.builder().registerTypeHierarchyAdapter((Class<?>)AdvancementData.class, new AdvancementDataAdapter(this.getServer())).registerTypeHierarchyAdapter((Class<?>)Attribute.class, new AttributeAdapter()).registerTypeHierarchyAdapter((Class<?>)AttributeData.class, new AttributeDataAdapter()).registerTypeHierarchyAdapter((Class<?>)BlockTypeStat.class, new BlockTypeStatAdapter(plugin)).registerTypeHierarchyAdapter((Class<?>)CustomStat.class, new CustomStatAdapter()).registerTypeHierarchyAdapter((Class<?>)Difficulty.class, new EnumAdapter<Difficulty>(Difficulty.class)).registerTypeHierarchyAdapter((Class<?>)Duration.class, DurationAdapter.INSTANCE).registerTypeHierarchyAdapter((Class<?>)EntityTypeStat.class, new EntityTypeStatAdapter(plugin)).registerTypeHierarchyAdapter((Class<?>)GameMode.class, new EnumAdapter<GameMode>(GameMode.class)).registerTypeHierarchyAdapter((Class<?>)GroupConfig.class, new GroupConfigAdapter()).registerTypeHierarchyAdapter((Class<?>)GroupData.class, new GroupDataAdapter(this.getServer())).registerTypeHierarchyAdapter((Class<?>)GroupSettings.class, new GroupSettingsAdapter()).registerTypeHierarchyAdapter((Class<?>)Instant.class, new InstantAdapter()).registerTypeHierarchyAdapter((Class<?>)ItemStack[].class, new ItemStackArrayAdapter()).registerTypeHierarchyAdapter((Class<?>)ItemTypeStat.class, new ItemTypeStatAdapter(plugin)).registerTypeHierarchyAdapter((Class<?>)Key.class, new KeyAdapter()).registerTypeHierarchyAdapter((Class<?>)Location.class, new LocationAdapter()).registerTypeHierarchyAdapter((Class<?>)NamespacedKey.class, new NamespacedKeyAdapter()).registerTypeHierarchyAdapter((Class<?>)PaperPlayerData.class, new PlayerDataAdapter(plugin)).registerTypeHierarchyAdapter((Class<?>)PotionEffect.class, new PotionEffectAdapter()).registerTypeHierarchyAdapter((Class<?>)PotionEffectType.class, new PotionEffectTypeAdapter()).registerTypeHierarchyAdapter((Class<?>)Statistics.class, new StatisticsAdapter(plugin)).registerTypeHierarchyAdapter((Class<?>)TriState.class, new EnumAdapter<TriState>(TriState.class)).registerTypeHierarchyAdapter((Class<?>)Vector.class, new VectorAdapter()).registerTypeHierarchyAdapter((Class<?>)WardenSpawnTracker.class, new WardenSpawnTrackerAdapter()).registerTypeHierarchyAdapter((Class<?>)World.class, new WorldAdapter(this.getServer())).registerTypeHierarchyAdapter((Class<?>)WorldBorderData.class, new WorldBorderAdapter()).build();
        this.unownedWorldGroup = new PaperUnownedWorldGroup(this);
    }

    public ComponentLogger getLogger() {
        return this.plugin.getComponentLogger();
    }

    public Server getServer() {
        return this.plugin.getServer();
    }

    public PerWorldsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Path getDataFolder() {
        return this.dataFolder;
    }

    public NBT nbt() {
        return this.nbt;
    }

    public ComponentBundle bundle() {
        return this.plugin.bundle();
    }

    @Override
    public @Unmodifiable Set<WorldGroup> getAllGroups() {
        HashSet<WorldGroup> groups = new HashSet<WorldGroup>(this.getGroups());
        groups.add(this.unownedWorldGroup);
        return Set.copyOf(groups);
    }

    @Override
    public @Unmodifiable Set<WorldGroup> getGroups() {
        return Set.copyOf(this.groups);
    }

    @Override
    public Optional<WorldGroup> getGroup(String name) {
        return this.unownedWorldGroup.getName().equals(name) ? Optional.of(this.unownedWorldGroup) : this.groups.stream().filter(group -> group.getName().equals(name)).findAny();
    }

    @Override
    public Optional<WorldGroup> getGroup(World world) {
        return this.groups.stream().filter(group -> group.containsWorld(world)).findAny();
    }

    @Override
    public PaperWorldGroup getUnownedWorldGroup() {
        return this.unownedWorldGroup;
    }

    @Override
    public PaperWorldGroup createGroup(String name, Consumer<GroupData> data, Consumer<GroupSettings> settings, Collection<World> worlds) {
        Preconditions.checkState((!this.hasGroup(name) ? 1 : 0) != 0, (String)"A WorldGroup named '%s' already exists", (Object)name);
        List<String> invalid = worlds.stream().filter(this::hasGroup).map(Keyed::key).map(Key::asString).toList();
        Preconditions.checkState((boolean)invalid.isEmpty(), (String)"Worlds cannot be in multiple groups: {}", (Object)String.join((CharSequence)", ", invalid));
        PaperGroupSettings groupSettings = new PaperGroupSettings();
        PaperGroupData groupData = new PaperGroupData();
        settings.accept(groupSettings);
        data.accept(groupData);
        PaperWorldGroup group = new PaperWorldGroup(this, name, groupData, groupSettings, Set.copyOf(worlds));
        this.groups.add(group);
        return group;
    }

    @Override
    public PaperWorldGroup createGroup(String name, Collection<World> worlds) throws IllegalStateException {
        return this.createGroup(name, data -> {}, (Collection)worlds);
    }

    @Override
    public PaperWorldGroup createGroup(String name, Consumer<GroupData> data, World ... worlds) throws IllegalStateException {
        return this.createGroup(name, (Consumer)data, settings -> {}, worlds);
    }

    @Override
    public PaperWorldGroup createGroup(String name, Consumer<GroupData> data, Collection<World> worlds) throws IllegalStateException {
        return this.createGroup(name, (Consumer)data, settings -> {}, (Collection)worlds);
    }

    @Override
    public PaperWorldGroup createGroup(String name, Consumer<GroupData> data, Consumer<GroupSettings> settings, World ... worlds) {
        return this.createGroup(name, (Consumer)data, (Consumer)settings, List.of(worlds));
    }

    @Override
    public PaperWorldGroup createGroup(String name, World ... worlds) throws IllegalStateException {
        return this.createGroup(name, data -> {}, worlds);
    }

    @Override
    public boolean hasGroup(String name) {
        return this.unownedWorldGroup.getName().equals(name) || this.groups.stream().anyMatch(group -> group.getName().equals(name));
    }

    public String findFreeName(String name) {
        List<String> usedNames = this.getAllGroups().stream().map(WorldGroup::getName).toList();
        if (!usedNames.contains(name)) {
            return name;
        }
        String baseName = name;
        int suffix = 1;
        String candidate = baseName + " (1)";
        Pattern pattern = Pattern.compile("^(.+) \\((\\d+)\\)$");
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            baseName = matcher.group(1);
            suffix = Integer.parseInt(matcher.group(2)) + 1;
            candidate = baseName + " (" + suffix + ")";
            ++suffix;
        }
        while (usedNames.contains(candidate)) {
            candidate = baseName + " (" + suffix++ + ")";
        }
        return candidate;
    }

    @Override
    public boolean hasGroup(World world) {
        return this.groups.stream().anyMatch(group -> group.containsWorld(world));
    }

    @Override
    public boolean hasGroup(WorldGroup group) {
        return this.groups.contains(group);
    }

    @Override
    public boolean removeGroup(String name) {
        return this.getGroup(name).map(this::removeGroup).orElse(false);
    }

    @Override
    public boolean removeGroup(WorldGroup group) {
        if (!this.groups.remove(group)) {
            return false;
        }
        group.getPlayers().forEach(this.getUnownedWorldGroup()::loadPlayerData);
        return true;
    }

    @Override
    public boolean isLoadingData(Player player) {
        return this.loadingPlayers.contains(player.getUniqueId());
    }
}

