/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.model.config;

import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.thenextlvl.perworlds.GroupProvider;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PluginConfig {
    public @Nullable String migrateToGroup = null;
    public boolean handleAdvancementMessages = true;
    public boolean handleDeathMessages = true;
    public boolean handleJoinMessages = true;
    public boolean handleQuitMessages = true;

    public boolean migrateToGroup(PerWorldsPlugin plugin, WorldGroup group) {
        if (group.getName().equals(this.migrateToGroup)) {
            return false;
        }
        this.migrateToGroup = group.getName();
        PaperGroupProvider provider = plugin.groupProvider();
        plugin.getServer().getOnlinePlayers().forEach(player -> {
            if (group.hasPlayerData((OfflinePlayer)player)) {
                return;
            }
            WorldGroup current = provider.getGroup(player.getWorld()).orElse(provider.getUnownedWorldGroup());
            if (current.equals(group) || current.hasPlayerData((OfflinePlayer)player)) {
                return;
            }
            current.loadPlayerData((Player)player, false);
        });
        plugin.configFile().save(new FileAttribute[0]);
        return true;
    }

    public Optional<WorldGroup> getMigrateToGroup(GroupProvider provider) {
        return Optional.ofNullable(this.migrateToGroup).flatMap(provider::getGroup);
    }
}

