/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.listener;

import io.papermc.paper.event.world.WorldDifficultyChangeEvent;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import io.papermc.paper.math.Position;
import java.lang.constant.Constable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.Ticks;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldListener
implements Listener {
    private final PaperGroupProvider provider;
    private final Map<GroupData.Type, Set<WorldGroup>> lock = new ConcurrentHashMap<GroupData.Type, Set<WorldGroup>>();
    private final Set<Key> allowed = new CopyOnWriteArraySet<Key>();

    public WorldListener(PaperGroupProvider provider) {
        this.provider = provider;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldInit(WorldLoadEvent event) {
        this.provider.getGroup(event.getWorld()).orElse(this.provider.getUnownedWorldGroup()).updateWorldData(event.getWorld());
        this.allowed.add(event.getWorld().key());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.allowed.remove(event.getWorld().key());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldDifficultyChange(WorldDifficultyChangeEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.DIFFICULTY, data -> data.setDifficulty(event.getDifficulty()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldGameRuleChange(WorldGameRuleChangeEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.GAME_RULE, data -> {
            GameRule gameRule = event.getGameRule();
            Object value = this.parseValue(gameRule, event.getValue());
            data.setGameRule(gameRule, value);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTimeSkip(TimeSkipEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.TIME, data -> data.setTime(event.getWorld().getFullTime() + event.getSkipAmount()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWeatherChange(WeatherChangeEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.WEATHER, data -> {
            data.setRaining(event.toWeatherState());
            data.setRainDuration(event.getWorld().getWeatherDuration());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onThunderChange(ThunderChangeEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.WEATHER, data -> {
            data.setThundering(event.toThunderState());
            data.setThunderDuration(event.getWorld().getThunderDuration());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldBorderChange(WorldBorderBoundsChangeEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.WORLD_BORDER, data -> data.setWorldBorder(data.getWorldBorder().setTransitionDuration(Ticks.duration((long)event.getDuration())).size(event.getNewSize())));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldBorderChange(WorldBorderCenterChangeEvent event) {
        this.processWorldDataUpdate(event.getWorld(), GroupData.Type.WORLD_BORDER, data -> data.setWorldBorder(data.getWorldBorder().center((Position)event.getNewCenter())));
    }

    private void processWorldDataUpdate(World world, GroupData.Type type, Consumer<GroupData> process) {
        if (!this.allowed.contains(world.key())) {
            return;
        }
        WorldGroup group = this.provider.getGroup(world).orElse(this.provider.getUnownedWorldGroup());
        if (!this.lock.computeIfAbsent(type, ignored -> ConcurrentHashMap.newKeySet()).add(group)) {
            return;
        }
        process.accept(group.getGroupData());
        group.getWorlds().filter(target -> !target.equals((Object)world)).forEach(target -> group.updateWorldData((World)target, type));
        this.lock.computeIfPresent(type, (ignored, groups) -> {
            groups.remove(group);
            return groups.isEmpty() ? null : groups;
        });
    }

    private Object parseValue(GameRule<?> rule, String value) {
        return rule.getType().equals(Integer.class) ? (Constable)Integer.valueOf(Integer.parseInt(value)) : (Constable)Boolean.valueOf(Boolean.parseBoolean(value));
    }
}

