/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.importer.multiverse;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.data.PlayerData;
import net.thenextlvl.perworlds.importer.Importer;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class MVInventoriesImporter
extends Importer {
    public MVInventoriesImporter(PerWorldsPlugin plugin) {
        super(plugin, "Multiverse-Inventories");
    }

    @Override
    public Map<String, Set<String>> readGroups() throws IOException {
        Path path = this.getDataPath().resolve("groups.yml");
        if (!Files.exists(path, new LinkOption[0])) {
            return new HashMap<String, Set<String>>();
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            ConfigurationSection groups = config.getConfigurationSection("groups");
            if (groups == null) {
                HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
                return hashMap;
            }
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            groups.getKeys(false).forEach(group -> {
                ConfigurationSection groupSection = groups.getConfigurationSection(group);
                if (groupSection == null) {
                    return;
                }
                List worlds = groupSection.getStringList("worlds");
                result.put((String)group, new HashSet(worlds));
            });
            HashMap<String, Set<String>> hashMap = result;
            return hashMap;
        }
    }

    @Override
    public Map<UUID, String> readPlayers() throws IOException {
        HashMap<UUID, String> hashMap;
        Path path = this.getDataPath().resolve("playernames.json");
        if (!Files.exists(path, new LinkOption[0])) {
            return new HashMap<UUID, String>();
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, StandardOpenOption.READ), StandardCharsets.UTF_8));
        try {
            JsonObject object = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
            HashMap<UUID, String> result = new HashMap<UUID, String>(object.size());
            for (Map.Entry entry : object.entrySet()) {
                try {
                    UUID uuid = UUID.fromString((String)entry.getKey());
                    result.put(uuid, ((JsonElement)entry.getValue()).getAsString());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException e) {
                this.plugin.getComponentLogger().warn("Failed to parse {}", (Object)path, (Object)e);
                return new HashMap<UUID, String>();
            }
        }
        reader.close();
        return hashMap;
    }

    @Override
    public boolean readPlayer(UUID uuid, String name, WorldGroup group, PlayerData data) throws IOException {
        boolean bl;
        Path path = group.getWorlds().map(WorldInfo::getName).map(this.getDataPath().resolve("worlds")::resolve).map(worlds -> worlds.resolve(name + ".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findAny().orElse(null);
        if (path == null) {
            return false;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, StandardOpenOption.READ), StandardCharsets.UTF_8));
        try {
            bl = Optional.ofNullable(JsonParser.parseReader((JsonReader)reader)).map(this::asObject).flatMap(this::selectBestSnapshot).map(snapshot -> {
                this.applySnapshot((Map.Entry<String, JsonObject>)snapshot, group, data);
                return true;
            }).orElse(false);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                this.plugin.getComponentLogger().warn("Failed to import player data for {} in group {} from {}", new Object[]{name, group, path, e});
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private void applySnapshot(Map.Entry<String, JsonObject> node, WorldGroup group, PlayerData data) {
        JsonObject enderChest;
        JsonObject offHandItem;
        JsonObject armor;
        JsonObject inventory;
        List<PotionEffect> effects;
        JsonObject stats = this.asObject(node.getValue().get("stats"));
        if (stats != null) {
            this.applyStats(data, stats);
        }
        data.gameMode(this.matchGameMode(node.getKey()));
        data.respawnLocation(this.readLocation(node.getValue().get("bedSpawnLocation"), group));
        JsonArray potions = this.asArray(node.getValue().get("potions"));
        List<PotionEffect> list = effects = potions != null ? this.readPotions(potions) : null;
        if (effects != null) {
            data.potionEffects(effects);
        }
        if ((inventory = this.asObject(node.getValue().get("inventoryContents"))) != null) {
            data.inventory(this.readStorageContents(data.inventory(), inventory));
        }
        if ((armor = this.asObject(node.getValue().get("armorContents"))) != null) {
            this.readArmorContents(data, armor);
        }
        if ((offHandItem = this.asObject(node.getValue().get("offHandItem"))) != null) {
            this.readItem((JsonElement)offHandItem).ifPresent(itemStack -> {
                ItemStack[] clone = (ItemStack[])data.inventory().clone();
                clone[40] = itemStack;
                data.inventory(clone);
            });
        }
        if ((enderChest = this.asObject(node.getValue().get("enderChestContents"))) != null) {
            data.enderChest(this.readStorageContents(data.enderChest(), enderChest));
        }
    }

    private @Nullable GameMode matchGameMode(String name) {
        for (GameMode value : GameMode.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    private void readArmorContents(PlayerData data, JsonObject contents) {
        ItemStack[] inventory = data.inventory();
        this.readItem(contents.get("0")).ifPresent(itemStack -> {
            inventory[36] = itemStack;
        });
        this.readItem(contents.get("1")).ifPresent(itemStack -> {
            inventory[37] = itemStack;
        });
        this.readItem(contents.get("2")).ifPresent(itemStack -> {
            inventory[38] = itemStack;
        });
        this.readItem(contents.get("3")).ifPresent(itemStack -> {
            inventory[39] = itemStack;
        });
        data.inventory(inventory);
    }

    private void applyStats(PlayerData data, JsonObject stats) {
        data.health(this.asDouble(stats.get("hp"), data.health()));
        data.level(this.asInt(stats.get("el"), data.level()));
        data.experience(this.asFloat(stats.get("xp"), data.experience()));
        data.foodLevel(this.asInt(stats.get("fl"), data.foodLevel()));
        data.exhaustion(this.asFloat(stats.get("ex"), data.exhaustion()));
        data.saturation(this.asFloat(stats.get("sa"), data.saturation()));
        data.fallDistance(this.asFloat(stats.get("fd"), data.fallDistance()));
        data.fireTicks(this.asInt(stats.get("ft"), data.fireTicks()));
        data.remainingAir(this.asInt(stats.get("ra"), data.remainingAir()));
    }

    private Optional<Map.Entry<String, JsonObject>> selectBestSnapshot(JsonObject root) {
        List<String> gameModes = Arrays.stream(GameMode.values()).map(Enum::name).toList();
        return root.entrySet().stream().map(entry -> {
            JsonObject object = this.asObject((JsonElement)entry.getValue());
            return object != null ? Map.entry((String)entry.getKey(), object) : null;
        }).filter(Objects::nonNull).sorted((entry1, entry2) -> {
            boolean mode1 = gameModes.contains(((String)entry1.getKey()).toUpperCase(Locale.ROOT));
            boolean mode2 = gameModes.contains(((String)entry2.getKey()).toUpperCase(Locale.ROOT));
            return Boolean.compare(mode1, mode2);
        }).max(Comparator.comparingInt(entry -> ((JsonObject)entry.getValue()).size()));
    }

    private @Nullable ItemStack[] readStorageContents(@Nullable ItemStack[] items, JsonObject contents) {
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.readItem(contents.get(String.valueOf(i))).orElse(null);
        }
        return items;
    }

    private Optional<ItemStack> readItem(@Nullable JsonElement node) {
        if (node == null) {
            return Optional.empty();
        }
        String string = this.asString(node);
        if (string != null) {
            try {
                return Optional.ofNullable(this.decodeBytes(string)).map(ItemStack::deserializeBytes);
            }
            catch (Exception e) {
                this.plugin.getComponentLogger().warn("Failed to deserialize item from bytes '{}': {}", (Object)node, (Object)e.getMessage());
                return Optional.empty();
            }
        }
        JsonObject object = this.sanitize(this.asObject(node));
        if (object != null) {
            try {
                JsonElement id = object.get("id");
                if (id != null && id.isJsonPrimitive() && id.getAsString().equals("minecraft:air")) {
                    return Optional.empty();
                }
                UnsafeValues unsafe = this.plugin.getServer().getUnsafe();
                return Optional.of(unsafe.deserializeItemFromJson(object));
            }
            catch (Exception e) {
                this.plugin.getComponentLogger().warn("Failed to deserialize item from json '{}': {}", (Object)node, (Object)e.getMessage());
                return Optional.empty();
            }
        }
        this.plugin.getComponentLogger().warn("Don't know how to turn '{}' into an item", (Object)node);
        return Optional.empty();
    }

    private @Nullable JsonObject sanitize(@Nullable JsonObject object) {
        JsonObject components;
        String type;
        if (object == null) {
            return null;
        }
        if (object.has("v") && !object.has("DataVersion")) {
            object.add("DataVersion", object.get("v"));
        }
        if ((type = this.asString(object.get("type"))) != null && !object.has("id")) {
            this.findItem(type).map(Key::asString).ifPresent(id -> object.addProperty("id", id));
        }
        if ((components = this.asObject(object.get("components"))) != null) {
            this.sanitizeComponents(components);
        }
        return object;
    }

    private void sanitizeComponents(JsonObject object) {
        object.entrySet().forEach(entry -> {
            JsonPrimitive primitive;
            Object patt0$temp = entry.getValue();
            if (!(patt0$temp instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)patt0$temp).isString()) {
                return;
            }
            try {
                entry.setValue(JsonParser.parseString((String)primitive.getAsString()));
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        });
    }

    private Optional<Key> findItem(String name) {
        return Registry.ITEM.stream().filter(itemType -> {
            Material material = itemType.asMaterial();
            return material != null && material.name().equalsIgnoreCase(name);
        }).map(Keyed::key).findAny();
    }

    private byte @Nullable [] decodeBytes(String string) {
        try {
            return Base64.getDecoder().decode(string);
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().warn("Failed to deserialize item from base64 '{}': {}", (Object)string, (Object)e.getMessage());
            return null;
        }
    }

    private @Nullable Location readLocation(@Nullable JsonElement element, WorldGroup group) {
        World world;
        JsonObject location = this.asObject(element);
        if (location == null) {
            return null;
        }
        String worldName = this.asString(location.get("world"), this.asString(location.get("wo")));
        World world2 = world = worldName != null ? this.plugin.getServer().getWorld(worldName) : null;
        if (world == null || !group.containsWorld(world)) {
            return null;
        }
        double x = this.asDouble(location.get("x"), 0.0);
        double y = this.asDouble(location.get("y"), 0.0);
        double z = this.asDouble(location.get("z"), 0.0);
        float pitch = this.asFloat(location.get("pitch"), this.asFloat(location.get("pi"), 0.0f));
        float yaw = this.asFloat(location.get("yaw"), this.asFloat(location.get("ya"), 0.0f));
        return new Location(world, x, y, z, yaw, pitch);
    }

    private List<PotionEffect> readPotions(JsonArray array) {
        ArrayList<PotionEffect> list = new ArrayList<PotionEffect>(array.size());
        array.forEach(element -> {
            PotionEffectType type;
            JsonObject object = this.asObject((JsonElement)element);
            if (object == null) {
                return;
            }
            String effect = this.asString(object.get("effect"), this.asString(object.get("pt")));
            NamespacedKey key = effect != null ? NamespacedKey.fromString((String)effect.toLowerCase(Locale.ROOT)) : null;
            PotionEffectType potionEffectType = type = key != null ? (PotionEffectType)Registry.EFFECT.get(key) : null;
            if (type == null) {
                return;
            }
            int duration = this.asInt(object.get("duration"), this.asInt(object.get("pd"), 0));
            int amplifier = this.asInt(object.get("amplifier"), this.asInt(object.get("pa"), 0));
            boolean ambient = this.asBoolean(object.get("ambient"), false);
            boolean particles = this.asBoolean(object.get("particles"), true);
            boolean icon = this.asBoolean(object.get("icon"), true);
            list.add(new PotionEffect(type, duration, amplifier, ambient, particles, icon));
        });
        return list;
    }

    private @Nullable JsonObject asObject(@Nullable JsonElement element) {
        JsonObject jsonObject;
        if (element instanceof JsonObject) {
            JsonObject primitive = (JsonObject)element;
            jsonObject = primitive.getAsJsonObject();
        } else {
            jsonObject = null;
        }
        return jsonObject;
    }

    private @Nullable JsonArray asArray(@Nullable JsonElement element) {
        JsonArray jsonArray;
        if (element instanceof JsonArray) {
            JsonArray primitive = (JsonArray)element;
            jsonArray = primitive.getAsJsonArray();
        } else {
            jsonArray = null;
        }
        return jsonArray;
    }

    private @Nullable String asString(@Nullable JsonElement element) {
        String string;
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            string = primitive.getAsString();
        } else {
            string = null;
        }
        return string;
    }

    private @Nullable String asString(@Nullable JsonElement element, @Nullable String defaultValue) {
        String string;
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            string = primitive.getAsString();
        } else {
            string = defaultValue;
        }
        return string;
    }

    private double asDouble(@Nullable JsonElement element, double defaultValue) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            try {
                if (primitive.isNumber()) {
                    return primitive.getAsDouble();
                }
                if (primitive.isString()) {
                    return Double.parseDouble(primitive.getAsString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private float asFloat(@Nullable JsonElement element, float defaultValue) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            try {
                if (primitive.isNumber()) {
                    return primitive.getAsFloat();
                }
                if (primitive.isString()) {
                    return Float.parseFloat(primitive.getAsString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private int asInt(@Nullable JsonElement element, int defaultValue) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            try {
                if (primitive.isNumber()) {
                    return primitive.getAsInt();
                }
                if (primitive.isString()) {
                    return Integer.parseInt(primitive.getAsString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private boolean asBoolean(@Nullable JsonElement element, boolean defaultValue) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            try {
                if (primitive.isBoolean()) {
                    return primitive.getAsBoolean();
                }
                if (primitive.isString()) {
                    return Boolean.parseBoolean(primitive.getAsString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

