/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.importer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.data.PlayerData;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class Importer {
    protected final PerWorldsPlugin plugin;
    private final Path dataPath;
    private final String name;

    protected Importer(PerWorldsPlugin plugin, String name) {
        this.dataPath = plugin.getServer().getPluginsFolder().toPath().resolve(name);
        this.name = name;
        this.plugin = plugin;
    }

    public boolean isAvailable() {
        return Files.isDirectory(this.dataPath, new LinkOption[0]);
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public String getName() {
        return this.name;
    }

    public CompletableFuture<Boolean> load(CommandSender sender) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.isAvailable()) {
                return false;
            }
            try {
                this.plugin.bundle().sendMessage((Audience)sender, "group.data.import.start", new TagResolver[]{Placeholder.parsed((String)"provider", (String)this.name)});
                Set<WorldGroup> groups = this.loadGroups(sender);
                this.loadPlayers(groups, sender);
                groups.forEach(WorldGroup::persist);
                return true;
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().error("Failed to import {}", (Object)this.name, (Object)e);
                return false;
            }
        });
    }

    public Set<WorldGroup> loadGroups(CommandSender sender) throws IOException {
        Map<String, Set<String>> read = this.readGroups();
        HashSet<WorldGroup> groups = new HashSet<WorldGroup>(read.size());
        read.forEach((group, worlds) -> {
            WorldGroup worldGroup = this.plugin.groupProvider().getGroup((String)group).orElseGet(() -> this.plugin.groupProvider().createGroup((String)group, new World[0]));
            List<TextComponent> importedWorlds = worlds.stream().map(arg_0 -> ((Server)this.plugin.getServer()).getWorld(arg_0)).filter(Objects::nonNull).peek(worldGroup::addWorld).map(WorldInfo::getName).map(Component::text).toList();
            groups.add(worldGroup);
            String message = importedWorlds.isEmpty() ? "group.data.import.group.success.empty" : "group.data.import.group.success";
            this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"group", (String)group), Formatter.joining((String)"worlds", importedWorlds)});
        });
        return groups;
    }

    public void loadPlayers(Set<WorldGroup> groups, CommandSender sender) throws IOException {
        this.readPlayers().forEach((uuid, name) -> groups.forEach(group -> {
            OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(uuid);
            if (group.hasPlayerData(offlinePlayer)) {
                this.plugin.bundle().sendMessage((Audience)sender, "group.data.import.player.nothing", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"player", (String)name)});
            } else {
                group.persistPlayerData(offlinePlayer, playerData -> {
                    try {
                        boolean success = this.readPlayer((UUID)uuid, (String)name, (WorldGroup)group, (PlayerData)playerData);
                        String message = success ? "group.data.import.player.success" : "group.data.import.player.nothing";
                        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"player", (String)name)});
                    }
                    catch (IOException e) {
                        this.plugin.bundle().sendMessage((Audience)sender, "group.data.import.player.failed", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"player", (String)name)});
                        this.plugin.getComponentLogger().error("Failed to import player data for {} ({}) in group {}", new Object[]{name, uuid, group.getName(), e});
                    }
                });
            }
        }));
    }

    public abstract Map<String, Set<String>> readGroups() throws IOException;

    public abstract Map<UUID, String> readPlayers() throws IOException;

    public abstract boolean readPlayer(UUID var1, String var2, WorldGroup var3, PlayerData var4) throws IOException;
}

