/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.data.AdvancementData;
import net.thenextlvl.perworlds.data.AttributeData;
import net.thenextlvl.perworlds.data.WardenSpawnTracker;
import net.thenextlvl.perworlds.statistics.Statistics;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.NonExtendable
public interface PlayerData {
    @Contract(pure=true)
    public WorldGroup group();

    @Contract(pure=true)
    public UUID uuid();

    @Contract(value=" -> new", pure=true)
    public @Nullable ItemStack[] enderChest();

    @Contract(mutates="this")
    public PlayerData enderChest(@Nullable ItemStack[] var1);

    @Contract(value=" -> new", pure=true)
    public @Nullable ItemStack[] inventory();

    @Contract(mutates="this")
    public PlayerData inventory(@Nullable ItemStack[] var1);

    @Contract(pure=true)
    public @Unmodifiable List<PotionEffect> potionEffects();

    @Contract(mutates="this")
    public PlayerData potionEffects(Collection<PotionEffect> var1);

    @Contract(pure=true)
    public @Nullable GameMode gameMode();

    @Contract(mutates="this")
    public PlayerData gameMode(@Nullable GameMode var1);

    @Contract(pure=true)
    public @Nullable GameMode previousGameMode();

    @Contract(mutates="this")
    public PlayerData previousGameMode(@Nullable GameMode var1);

    @Contract(pure=true)
    public @Nullable Location lastDeathLocation();

    @Contract(mutates="this")
    public PlayerData lastDeathLocation(@Nullable Location var1);

    @Contract(pure=true)
    public @Nullable Location lastLocation();

    @Contract(mutates="this")
    public PlayerData lastLocation(@Nullable Location var1);

    @Contract(pure=true)
    public @Nullable Location respawnLocation();

    @Contract(mutates="this")
    public PlayerData respawnLocation(@Nullable Location var1);

    @Contract(pure=true)
    public @Nullable Key lastAdvancementTab();

    @Contract(mutates="this")
    public PlayerData lastAdvancementTab(@Nullable Key var1);

    @Contract(pure=true)
    public double absorption();

    @Contract(mutates="this")
    public PlayerData absorption(double var1);

    @Contract(pure=true)
    public @Unmodifiable Set<AdvancementData> advancements();

    @Contract(mutates="this")
    public PlayerData advancements(Collection<AdvancementData> var1);

    @Contract(pure=true)
    public int arrowsInBody();

    @Contract(mutates="this")
    public PlayerData arrowsInBody(int var1);

    @Contract(pure=true)
    public @Unmodifiable Set<AttributeData> attributes();

    @Contract(mutates="this")
    public PlayerData attributes(Collection<AttributeData> var1);

    @Contract(pure=true)
    public int beeStingersInBody();

    @Contract(mutates="this")
    public PlayerData beeStingersInBody(int var1);

    @Contract(pure=true)
    public @Unmodifiable Set<NamespacedKey> discoveredRecipes();

    @Contract(mutates="this")
    public PlayerData discoveredRecipes(Collection<NamespacedKey> var1);

    @Contract(pure=true)
    public float exhaustion();

    @Contract(mutates="this")
    public PlayerData exhaustion(float var1);

    @Contract(pure=true)
    public float experience();

    @Contract(mutates="this")
    public PlayerData experience(float var1);

    @Contract(pure=true)
    public float fallDistance();

    @Contract(mutates="this")
    public PlayerData fallDistance(float var1);

    @Contract(pure=true)
    public int fireTicks();

    @Contract(mutates="this")
    public PlayerData fireTicks(int var1);

    @Contract(pure=true)
    public @Range(from=-1L, to=1L) float flySpeed();

    @Contract(mutates="this")
    public PlayerData flySpeed(@Range(from=-1L, to=1L) float var1);

    @Contract(pure=true)
    public TriState flying();

    @Contract(mutates="this")
    public PlayerData flying(TriState var1);

    @Contract(pure=true)
    public int foodLevel();

    @Contract(mutates="this")
    public PlayerData foodLevel(int var1);

    @Contract(pure=true)
    public int freezeTicks();

    @Contract(mutates="this")
    public PlayerData freezeTicks(int var1);

    @Contract(pure=true)
    public boolean gliding();

    @Contract(mutates="this")
    public PlayerData gliding(boolean var1);

    @Contract(pure=true)
    public double health();

    @Contract(mutates="this")
    public PlayerData health(double var1);

    @Contract(pure=true)
    public int heldItemSlot();

    @Contract(mutates="this")
    public PlayerData heldItemSlot(int var1);

    @Contract(pure=true)
    public boolean invulnerable();

    @Contract(mutates="this")
    public PlayerData invulnerable(boolean var1);

    @Contract(pure=true)
    public int level();

    @Contract(mutates="this")
    public PlayerData level(int var1);

    @Contract(pure=true)
    public boolean lockFreezeTicks();

    @Contract(mutates="this")
    public PlayerData lockFreezeTicks(boolean var1);

    @Contract(pure=true)
    public TriState mayFly();

    @Contract(mutates="this")
    public PlayerData mayFly(TriState var1);

    @Contract(pure=true)
    public int portalCooldown();

    @Contract(mutates="this")
    public PlayerData portalCooldown(int var1);

    @Contract(pure=true)
    public int remainingAir();

    @Contract(mutates="this")
    public PlayerData remainingAir(int var1);

    @Contract(pure=true)
    public float saturation();

    @Contract(mutates="this")
    public PlayerData saturation(float var1);

    @Contract(pure=true)
    public int score();

    @Contract(mutates="this")
    public PlayerData score(int var1);

    @Contract(pure=true)
    public boolean seenCredits();

    @Contract(mutates="this")
    public PlayerData seenCredits(boolean var1);

    @ApiStatus.Experimental
    public Statistics stats();

    @ApiStatus.Experimental
    @Contract(mutates="this")
    public PlayerData stats(Statistics var1);

    @Contract(value=" -> new", pure=true)
    public Vector velocity();

    @Contract(mutates="this")
    public PlayerData velocity(Vector var1);

    @Contract(pure=true)
    public TriState visualFire();

    @Contract(mutates="this")
    public PlayerData visualFire(TriState var1);

    @Contract(pure=true)
    public @Range(from=-1L, to=1L) float walkSpeed();

    @Contract(mutates="this")
    public PlayerData walkSpeed(@Range(from=-1L, to=1L) float var1);

    @Contract(pure=true)
    public WardenSpawnTracker wardenSpawnTracker();

    @Contract(mutates="this")
    public PlayerData wardenSpawnTracker(WardenSpawnTracker var1);

    @Contract(mutates="param1")
    public CompletableFuture<Boolean> load(Player var1, boolean var2);
}

