/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.command.brigadier.SimpleCommand;
import net.thenextlvl.perworlds.command.suggestion.DataImportSuggestionProvider;
import net.thenextlvl.perworlds.importer.Importer;
import org.bukkit.command.CommandSender;

final class GroupImportCommand
extends SimpleCommand {
    private final AtomicBoolean importing = new AtomicBoolean();

    private GroupImportCommand(PerWorldsPlugin plugin) {
        super(plugin, "import", "perworlds.command.group.import");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PerWorldsPlugin plugin) {
        GroupImportCommand command = new GroupImportCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(Commands.argument((String)"provider", (ArgumentType)StringArgumentType.string()).suggests(new DataImportSuggestionProvider(plugin)).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!this.importing.compareAndSet(false, true)) {
            this.plugin.bundle().sendMessage((Audience)sender, "group.data.import.active");
            return 0;
        }
        String provider = (String)context.getArgument("provider", String.class);
        Optional<Importer> optional = this.plugin.importers().stream().filter(i -> i.getName().equalsIgnoreCase(provider)).findAny();
        optional.ifPresentOrElse(importer -> ((CompletableFuture)importer.load(sender).handle((success, error) -> error == null && success != false)).thenAccept(success -> {
            String message = success != false ? "group.data.import.success" : "group.data.import.failed";
            this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"provider", (String)importer.getName())});
            this.importing.set(false);
        }), () -> {
            this.plugin.bundle().sendMessage((Audience)sender, "group.data.import.failed", new TagResolver[]{Placeholder.parsed((String)"provider", (String)provider)});
            this.importing.set(false);
        });
        return 1;
    }
}

