/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.GroupProvider;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.data.PlayerData;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface WorldGroup {
    @Contract(pure=true)
    public Path getDataFolder();

    @Contract(pure=true)
    public Path getConfigFile();

    @Contract(pure=true)
    public Path getConfigFileBackup();

    @Contract(pure=true)
    public GroupData getGroupData();

    @Contract(pure=true)
    public GroupProvider getGroupProvider();

    @Contract(pure=true)
    public GroupSettings getSettings();

    @Contract(pure=true)
    public @Unmodifiable List<Player> getPlayers();

    @Contract(pure=true)
    public Optional<Location> getSpawnLocation(OfflinePlayer var1);

    @Contract(pure=true)
    public Optional<Location> getSpawnLocation(PlayerData var1);

    @Contract(pure=true)
    public Optional<Location> getSpawnLocation();

    @Contract(pure=true)
    public Optional<World> getSpawnWorld();

    @Contract(pure=true)
    public Optional<PlayerData> readPlayerData(OfflinePlayer var1);

    @Contract(mutates="io")
    public boolean editPlayerData(OfflinePlayer var1, Consumer<PlayerData> var2);

    @Contract(pure=true)
    public @Unmodifiable Set<Key> getPersistedWorlds();

    @Contract(pure=true)
    public Stream<World> getWorlds();

    @Contract(pure=true)
    public String getName();

    @Contract(mutates="this,param1")
    public boolean addWorld(World var1);

    @Contract(pure=true)
    public boolean containsWorld(World var1);

    @Contract(mutates="io")
    public boolean delete();

    @Contract(pure=true)
    public boolean hasPlayerData(OfflinePlayer var1);

    @Contract(mutates="this,param1")
    public boolean removeWorld(World var1);

    @Contract(mutates="this")
    public boolean removeWorld(Key var1);

    @Contract(mutates="io")
    public boolean writePlayerData(OfflinePlayer var1, PlayerData var2);

    @Contract(mutates="param1")
    public CompletableFuture<Boolean> loadPlayerData(Player var1);

    @Contract(mutates="param1")
    public CompletableFuture<Boolean> loadPlayerData(Player var1, boolean var2);

    @Contract(mutates="param1")
    public void updateWorldData(World var1) throws IllegalArgumentException;

    @Contract(mutates="param1")
    public void updateWorldData(World var1, GroupData.Type var2) throws IllegalArgumentException;

    @Contract(mutates="this")
    public void loadWorldData(World var1);

    @Deprecated(forRemoval=true, since="1.2.0")
    @Contract(pure=true)
    default public boolean isLoadingData(Player player) {
        return this.getGroupProvider().isLoadingData(player);
    }

    @Contract(mutates="io")
    public boolean persist();

    @Contract(mutates="io")
    public void persistPlayerData();

    @Contract(mutates="io")
    public void persistPlayerData(Player var1);

    @Contract(mutates="io")
    public void persistPlayerData(Player var1, Consumer<PlayerData> var2);

    @Contract(mutates="io")
    public void persistPlayerData(OfflinePlayer var1, Consumer<PlayerData> var2);
}

