/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.group;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.data.WorldBorderData;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperGroupData
implements GroupData {
    private final Map<GameRule<?>, Object> gameRules = new HashMap();
    private @Nullable GameMode defaultGameMode = null;
    private @Nullable Location spawnLocation = null;
    private WorldBorderData worldBorder = WorldBorderData.DEFAULT;
    private Difficulty difficulty = Difficulty.NORMAL;
    private TriState hardcore = TriState.NOT_SET;
    private boolean raining = false;
    private boolean thundering = false;
    private int clearWeatherDuration;
    private int rainDuration;
    private int thunderDuration;
    private long time = 0L;

    @Override
    public void forEachGameRule(BiConsumer<GameRule<Object>, Object> action) {
        this.gameRules.forEach((rule, value) -> action.accept((GameRule<Object>)rule, value));
    }

    @Override
    public <T> Optional<T> getGameRule(GameRule<T> rule) {
        Object object = this.gameRules.get(rule);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(rule.getType().cast(object));
    }

    @Override
    public <T> boolean setGameRule(GameRule<T> rule, @Nullable T value) {
        if (value == null) {
            return this.gameRules.remove(rule) != null;
        }
        return !value.equals(this.gameRules.put(rule, value));
    }

    @Override
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public Optional<GameMode> getDefaultGameMode() {
        return Optional.ofNullable(this.defaultGameMode);
    }

    @Override
    public void setDefaultGameMode(@Nullable GameMode defaultGameMode) {
        this.defaultGameMode = defaultGameMode;
    }

    @Override
    public WorldBorderData getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public void setWorldBorder(WorldBorderData worldBorder) {
        this.worldBorder = worldBorder;
    }

    @Override
    public Optional<Location> getSpawnLocation() {
        return Optional.ofNullable(this.spawnLocation).map(Location::clone);
    }

    @Override
    public void setSpawnLocation(@Nullable Location location) {
        this.spawnLocation = location != null ? location.clone() : null;
    }

    @Override
    public TriState getHardcore() {
        return this.hardcore;
    }

    @Override
    public void setHardcore(TriState hardcore) {
        this.hardcore = hardcore;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean raining) {
        this.raining = raining;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean thundering) {
        this.thundering = thundering;
    }

    @Override
    public int clearWeatherDuration() {
        return this.clearWeatherDuration;
    }

    @Override
    public void clearWeatherDuration(int duration) {
        this.clearWeatherDuration = duration;
    }

    @Override
    public int getThunderDuration() {
        return this.thunderDuration;
    }

    @Override
    public void setThunderDuration(int duration) {
        this.thunderDuration = duration;
    }

    @Override
    public int getRainDuration() {
        return this.rainDuration;
    }

    @Override
    public void setRainDuration(int duration) {
        this.rainDuration = duration;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public GroupData copyFrom(GroupData other) {
        this.gameRules.clear();
        other.forEachGameRule(this.gameRules::put);
        this.defaultGameMode = other.getDefaultGameMode().orElse(null);
        this.worldBorder = other.getWorldBorder();
        this.difficulty = other.getDifficulty();
        this.hardcore = other.getHardcore();
        this.raining = other.isRaining();
        this.thundering = other.isThundering();
        this.clearWeatherDuration = other.clearWeatherDuration();
        this.rainDuration = other.getRainDuration();
        this.thunderDuration = other.getThunderDuration();
        this.time = other.getTime();
        return this;
    }
}

