/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Position;
import java.time.Duration;
import net.kyori.adventure.util.Ticks;
import net.thenextlvl.perworlds.data.WorldBorderData;
import org.bukkit.WorldBorder;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldBorderDataImpl
implements WorldBorderData {
    private final double centerX;
    private final double centerZ;
    private final double size;
    private final double damageAmount;
    private final double damageBuffer;
    private final Duration transitionDuration;
    private final int warningDistance;
    private final Duration warningTime;
    static final double MAX_SIZE = 5.9999968E7;
    static final double MIN_SIZE = 1.0;
    static final double MAX_CENTER_COORDINATE = 5.9999968E7;

    public WorldBorderDataImpl() {
        this(0.0, 0.0, 5.9999968E7, 0.2, 5.0, Duration.ZERO, 5, Duration.ofSeconds(15L));
    }

    public WorldBorderDataImpl(WorldBorder border) {
        this(border.getCenter().getX(), border.getCenter().getZ(), border.getSize(), border.getDamageAmount(), border.getDamageBuffer(), Duration.ZERO, border.getWarningDistance(), Ticks.duration((long)border.getWarningTimeTicks()));
    }

    public WorldBorderDataImpl(double centerX, double centerZ, double size, double damageAmount, double damageBuffer, Duration transitionDuration, int warningDistance, Duration warningTime) throws IllegalArgumentException {
        Preconditions.checkArgument((!transitionDuration.isNegative() ? 1 : 0) != 0, (String)"time cannot be lower than 0ms but got %sms", (long)transitionDuration.toMillis());
        Preconditions.checkArgument((!warningTime.isNegative() ? 1 : 0) != 0, (String)"time cannot be lower than 0ms but got %sms", (long)warningTime.toMillis());
        Preconditions.checkArgument((size >= 1.0 && size <= 5.9999968E7 ? 1 : 0) != 0, (String)"size must be between %s and %s but got %s", (Object)1.0, (Object)5.9999968E7, (Object)size);
        Preconditions.checkArgument((Math.abs(centerX) <= 5.9999968E7 ? 1 : 0) != 0, (String)"x coordinate cannot be outside +- %s but got %s", (Object)5.9999968E7, (Object)centerX);
        Preconditions.checkArgument((Math.abs(centerZ) <= 5.9999968E7 ? 1 : 0) != 0, (String)"z coordinate cannot be outside +- %s but got %s", (Object)5.9999968E7, (Object)centerZ);
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.size = size;
        this.damageAmount = damageAmount;
        this.damageBuffer = damageBuffer;
        this.transitionDuration = transitionDuration;
        this.warningDistance = warningDistance;
        this.warningTime = warningTime;
    }

    @Override
    public double centerX() {
        return this.centerX;
    }

    @Override
    public WorldBorderData centerX(double x) throws IllegalArgumentException {
        return this.center(x, this.centerZ);
    }

    @Override
    public double centerZ() {
        return this.centerZ;
    }

    @Override
    public WorldBorderData centerZ(double z) throws IllegalArgumentException {
        return this.center(this.centerX, z);
    }

    @Override
    public Position center() {
        return Position.fine((double)this.centerX, (double)0.0, (double)this.centerZ);
    }

    @Override
    public WorldBorderData center(Position position) throws IllegalArgumentException {
        return this.center(position.x(), position.z());
    }

    @Override
    public WorldBorderData center(double x, double z) throws IllegalArgumentException {
        return new WorldBorderDataImpl(x, z, this.size, this.damageAmount, this.damageBuffer, this.transitionDuration, this.warningDistance, this.warningTime);
    }

    @Override
    public double size() {
        return this.size;
    }

    @Override
    public WorldBorderData size(double size) throws IllegalArgumentException {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, size, this.damageAmount, this.damageBuffer, this.transitionDuration, this.warningDistance, this.warningTime);
    }

    @Override
    public Duration getTransitionDuration() {
        return this.transitionDuration;
    }

    @Override
    public WorldBorderData setTransitionDuration(Duration duration) throws IllegalArgumentException {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, this.damageBuffer, duration, this.warningDistance, this.warningTime);
    }

    @Override
    public double damageAmount() {
        return this.damageAmount;
    }

    @Override
    public WorldBorderData damageAmount(double damage) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, damage, this.damageBuffer, this.transitionDuration, this.warningDistance, this.warningTime);
    }

    @Override
    public double damageBuffer() {
        return this.damageBuffer;
    }

    @Override
    public WorldBorderData damageBuffer(double blocks) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, blocks, this.transitionDuration, this.warningDistance, this.warningTime);
    }

    @Override
    public int warningDistance() {
        return this.warningDistance;
    }

    @Override
    public WorldBorderData warningDistance(int blocks) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, this.damageBuffer, this.transitionDuration, blocks, this.warningTime);
    }

    @Override
    public Duration getWarningTime() {
        return this.warningTime;
    }

    @Override
    public WorldBorderData setWarningTime(Duration duration) throws IllegalArgumentException {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, this.damageBuffer, this.transitionDuration, this.warningDistance, duration);
    }
}

