/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.adapter;

import java.time.Duration;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.perworlds.data.WorldBorderData;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldBorderAdapter
implements TagAdapter<WorldBorderData> {
    @Override
    public WorldBorderData deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        WorldBorderData border = WorldBorderData.DEFAULT;
        CompoundTag root = tag.getAsCompound();
        Double x = root.optional("x").map(Tag::getAsDouble).map(value -> Math.clamp(value, -WorldBorderData.getMaxCenterCoordinate(), WorldBorderData.getMaxCenterCoordinate())).orElse(border.centerX());
        Double z = root.optional("z").map(Tag::getAsDouble).map(value -> Math.clamp(value, -WorldBorderData.getMaxCenterCoordinate(), WorldBorderData.getMaxCenterCoordinate())).orElse(border.centerZ());
        Double size = root.optional("size").map(Tag::getAsDouble).map(value -> Math.clamp(value, WorldBorderData.getMinSize(), WorldBorderData.getMaxSize())).orElse(border.size());
        Duration duration = root.optional("duration").map(tag1 -> context.deserialize((Tag)tag1, Duration.class)).orElse(border.getTransitionDuration());
        Double damageAmount = root.optional("damageAmount").map(Tag::getAsDouble).orElse(border.damageAmount());
        Double damageBuffer = root.optional("damageBuffer").map(Tag::getAsDouble).orElse(border.damageBuffer());
        Integer warningDistance = root.optional("warningDistance").map(Tag::getAsInt).orElse(border.warningDistance());
        Duration warningTime = root.optional("warningTime").map(tag1 -> context.deserialize((Tag)tag1, Duration.class)).orElse(border.getWarningTime());
        return WorldBorderData.create((double)x, (double)z, (double)size, (double)damageAmount, (double)damageBuffer, duration, (int)warningDistance, warningTime);
    }

    @Override
    public Tag serialize(WorldBorderData data, TagSerializationContext context) throws ParserException {
        return CompoundTag.builder().put("x", data.centerX()).put("z", data.centerZ()).put("size", data.size()).put("duration", context.serialize(data.getTransitionDuration())).put("damageAmount", data.damageAmount()).put("damageBuffer", data.damageBuffer()).put("warningDistance", (Number)data.warningDistance()).put("warningTime", context.serialize(data.getWarningTime())).build();
    }
}

