/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.command.WorldCommand;
import net.thenextlvl.perworlds.command.brigadier.SimpleCommand;
import net.thenextlvl.perworlds.command.suggestion.GroupMemberSuggestionProvider;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class GroupRemoveCommand
extends SimpleCommand {
    private GroupRemoveCommand(PerWorldsPlugin plugin) {
        super(plugin, "remove", "perworlds.command.group.remove");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(PerWorldsPlugin plugin) {
        GroupRemoveCommand command = new GroupRemoveCommand(plugin);
        return command.create().then(command.remove());
    }

    private ArgumentBuilder<CommandSourceStack, ?> remove() {
        return WorldCommand.groupArgument(this.plugin, false).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.key()).suggests(new GroupMemberSuggestionProvider()).executes((Command)this));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        WorldGroup group = (WorldGroup)context.getArgument("group", WorldGroup.class);
        Key key = (Key)context.getArgument("world", Key.class);
        World world = this.plugin.getServer().getWorld(key);
        boolean success = world != null ? group.removeWorld(world) : group.removeWorld(key);
        String message = success ? "group.world.removed" : "group.world.remove.failed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"group", (String)group.getName()), Placeholder.unparsed((String)"world", (String)(world != null ? world.getName() : key.asString()))});
        return success ? 1 : 0;
    }
}

