/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import core.file.FileIO;
import core.file.formats.GsonFile;
import dev.faststats.bukkit.BukkitMetrics;
import dev.faststats.core.ErrorTracker;
import dev.faststats.core.chart.Chart;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.i18n.ComponentBundle;
import net.thenextlvl.perworlds.GroupProvider;
import net.thenextlvl.perworlds.bstats.bukkit.Metrics;
import net.thenextlvl.perworlds.bstats.charts.SimplePie;
import net.thenextlvl.perworlds.command.WorldCommand;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import net.thenextlvl.perworlds.listener.ChatListener;
import net.thenextlvl.perworlds.listener.ConnectionListener;
import net.thenextlvl.perworlds.listener.MessageListener;
import net.thenextlvl.perworlds.listener.PluginListener;
import net.thenextlvl.perworlds.listener.RespawnListener;
import net.thenextlvl.perworlds.listener.TeleportListener;
import net.thenextlvl.perworlds.listener.WorldListener;
import net.thenextlvl.perworlds.model.config.PluginConfig;
import net.thenextlvl.perworlds.version.PluginVersionChecker;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PerWorldsPlugin
extends JavaPlugin {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml";
    public static final String DOCS_URL = "https://thenextlvl.net/docs/perworlds";
    public static final ErrorTracker ERROR_TRACKER = ErrorTracker.contextAware();
    private final Set<String> knownWorldManagers = Set.of("Worlds", "Multiverse-Core", "My_Worlds", "MultiWorld", "PhantomWorlds", "Hyperverse", "LightWorlds", "SolarSystem", "MoreFoWorld", "WorldManager", "LilWorlds", "WorldMaster", "TheGalaxyLimits", "WorldMagic", "BulMultiverse", "worldmgr");
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final Metrics metrics = new Metrics((Plugin)this, 25295);
    private final dev.faststats.core.Metrics fastStats = ((BukkitMetrics.Factory)((BukkitMetrics.Factory)((BukkitMetrics.Factory)BukkitMetrics.factory().token("aadc507be90ffc99bfab023066c651ae")).addChart(this.worldManagementPlugins())).errorTracker(ERROR_TRACKER)).create((Plugin)this);
    private final Key key = Key.key((String)"perworlds", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("per-worlds.properties", Locale.US).resource("per-worlds_german.properties", Locale.GERMANY).build();
    private final PaperGroupProvider provider = new PaperGroupProvider(this);
    private final boolean groupsExist = Files.exists(this.provider.getDataFolder(), new LinkOption[0]);
    private final FileIO<PluginConfig> config = new GsonFile<PluginConfig>(this.getDataPath().resolve("config.json"), new PluginConfig()).validate().save(new FileAttribute[0]);
    private String @Nullable [] worldManagementPlugins = null;
    private @Nullable String worldManagementPlugin = null;

    public void onLoad() {
        this.versionChecker.checkVersion();
        this.addCustomCharts();
        this.registerServices();
        this.registerCommands();
    }

    public void onEnable() {
        this.scheduleDelayedInitTask();
        this.registerListeners();
        this.warnWorldManager();
        this.loadGroups();
    }

    public void onDisable() {
        this.metrics.shutdown();
        this.persistGroups();
    }

    private void registerServices() {
        this.getServer().getServicesManager().register(GroupProvider.class, (Object)this.provider, (Plugin)this, ServicePriority.Highest);
    }

    private void scheduleDelayedInitTask() {
        if (this.groupsExist && this.config().migrateToGroup != null) {
            return;
        }
        this.getServer().getGlobalRegionScheduler().execute((Plugin)this, this::setupNotice);
    }

    private void setupNotice() {
        String separator = "-".repeat(86);
        this.getComponentLogger().warn(separator);
        if (this.groupsExist) {
            this.getComponentLogger().warn("PerWorlds is not properly configured yet!");
        } else {
            this.getComponentLogger().warn("This is your first startup using PerWorlds");
        }
        this.getComponentLogger().warn("The main command to interact with PerWorlds is '/world group'");
        this.getComponentLogger().warn("To automatically group all existing worlds, run '/world group auto'");
        this.getComponentLogger().warn("");
        this.getComponentLogger().warn("Before your settings come into effect, you have to define a group");
        this.getComponentLogger().warn("to migrate all pre-existing player data to");
        this.getComponentLogger().warn("You can do this by running '/world group migrate <group>'");
        this.getComponentLogger().warn("");
        this.getComponentLogger().warn("Refer to the wiki to learn how to manage groups: {}", (Object)DOCS_URL);
        this.getComponentLogger().warn(separator);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this.provider), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this.provider), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MessageListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PluginListener(this.provider), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RespawnListener(this.provider), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TeleportListener(this.provider), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this.provider), (Plugin)this);
    }

    private void warnWorldManager() {
        String plugin = this.knownWorldManagers.stream().filter(name -> !name.equals("Worlds")).map(arg_0 -> ((PluginManager)this.getServer().getPluginManager()).getPlugin(arg_0)).filter(Objects::nonNull).findAny().map(Plugin::getName).orElse(null);
        if (plugin == null) {
            return;
        }
        this.getComponentLogger().warn("It appears you are using a third party world management plugin");
        this.getComponentLogger().warn("Consider switching from '{}' to 'Worlds' for first hand support", (Object)plugin);
        this.getComponentLogger().warn("Download at: https://modrinth.com/project/gBIw3Gvy");
    }

    private void loadGroups() {
        if (!this.groupsExist) {
            return;
        }
        String suffix = ".dat";
        try (Stream<Path> files = Files.list(this.provider.getDataFolder());){
            files.map(path -> path.getFileName().toString()).filter(name -> name.endsWith(".dat")).forEach(name -> {
                String trimmed = name.substring(0, name.length() - ".dat".length());
                if (!this.provider.hasGroup(trimmed)) {
                    this.provider.createGroup(trimmed, new World[0]);
                }
            });
        }
        catch (IOException e) {
            this.getComponentLogger().error("Failed to load groups", (Throwable)e);
            this.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)ISSUES);
            ERROR_TRACKER.trackError(e);
        }
    }

    private void persistGroups() {
        this.provider.getAllGroups().forEach(group -> {
            group.persistPlayerData();
            group.persist();
        });
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            LiteralCommandNode<CommandSourceStack> command = WorldCommand.create(this);
            CommandNode world = ((Commands)event.registrar()).getDispatcher().getRoot().getChild("world");
            if (world != null) {
                world.getChildren().forEach(arg_0 -> command.addChild(arg_0));
                Predicate requirement = command.getRequirement();
                command.requirement = source -> requirement.test(source) || world.canUse(source);
            }
            ((Commands)event.registrar()).register(command, "The main command to interact with this plugin");
        });
    }

    public FileIO<PluginConfig> configFile() {
        return this.config;
    }

    public PluginConfig config() {
        return this.config.getRoot();
    }

    public PaperGroupProvider groupProvider() {
        return this.provider;
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    private void addCustomCharts() {
        this.metrics.addCustomChart(new SimplePie("world_management_plugin", () -> {
            String worldManager;
            if (this.worldManagementPlugin != null) {
                return this.worldManagementPlugin;
            }
            this.worldManagementPlugin = worldManager = this.knownWorldManagers.stream().filter(name -> this.getServer().getPluginManager().getPlugin(name) != null).findAny().orElse("None");
            return this.worldManagementPlugin;
        }));
    }

    private Chart<String[]> worldManagementPlugins() {
        return Chart.stringArray("world_management_plugins", () -> {
            if (this.worldManagementPlugins != null) {
                return this.worldManagementPlugins;
            }
            String[] worldManagers = (String[])this.knownWorldManagers.stream().filter(name -> this.getServer().getPluginManager().getPlugin(name) != null).toArray(String[]::new);
            this.worldManagementPlugins = worldManagers;
            return worldManagers;
        });
    }
}

