/*
 * Decompiled with CFR 0.152.
 */
package dev.faststats.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.faststats.core.ErrorTracker;
import dev.faststats.core.MurmurHash3;
import dev.faststats.core.SimpleTrackingBase;
import dev.faststats.core.SimpleTrackingExecutors;
import dev.faststats.core.SimpleTrackingThreadFactory;
import dev.faststats.core.SimpleTrackingThreadPoolExecutor;
import dev.faststats.core.concurrent.TrackingBase;
import dev.faststats.core.concurrent.TrackingExecutors;
import dev.faststats.core.concurrent.TrackingThreadFactory;
import dev.faststats.core.concurrent.TrackingThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;

final class SimpleErrorTracker
implements ErrorTracker {
    private final int stackTraceLimit = Math.min(50, Integer.getInteger("faststats.stack-trace-limit", 15));
    private final Map<String, Integer> collected = new ConcurrentHashMap<String, Integer>();
    private final Map<String, JsonObject> reports = new ConcurrentHashMap<String, JsonObject>();
    private final TrackingBase base = new SimpleTrackingBase(this);
    private final TrackingExecutors executors = new SimpleTrackingExecutors(this);
    private final TrackingThreadFactory threadFactory = new SimpleTrackingThreadFactory(this);
    private final TrackingThreadPoolExecutor threadPoolExecutor = new SimpleTrackingThreadPoolExecutor(this);
    private @Nullable BiConsumer<@Nullable ClassLoader, Throwable> errorEvent = null;
    private static final String IPV4_PATTERN = "\\b(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\b";
    private static final String IPV6_PATTERN = "(?i)\\b([0-9a-f]{1,4}:){7}[0-9a-f]{1,4}\\b|(?i)\\b([0-9a-f]{1,4}:){1,7}:\\b|(?i)\\b([0-9a-f]{1,4}:){1,6}:[0-9a-f]{1,4}\\b|(?i)\\b([0-9a-f]{1,4}:){1,5}(:[0-9a-f]{1,4}){1,2}\\b|(?i)\\b([0-9a-f]{1,4}:){1,4}(:[0-9a-f]{1,4}){1,3}\\b|(?i)\\b([0-9a-f]{1,4}:){1,3}(:[0-9a-f]{1,4}){1,4}\\b|(?i)\\b([0-9a-f]{1,4}:){1,2}(:[0-9a-f]{1,4}){1,5}\\b|(?i)\\b[0-9a-f]{1,4}:(:[0-9a-f]{1,4}){1,6}\\b|(?i)\\b:(:[0-9a-f]{1,4}){1,7}\\b|(?i)\\b::([0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4}\\b|(?i)\\b::\\b";
    private static final String USER_HOME_PATH_PATTERN = "(/home/)[^/\\s]+|(/Users/)[^/\\s]+|((?i)[A-Z]:\\\\Users\\\\)[^\\\\\\s]+";

    SimpleErrorTracker() {
    }

    @Override
    public void trackError(String message) {
        this.trackError(new RuntimeException(message));
    }

    @Override
    public void trackError(Throwable error) {
        JsonObject compile = this.compile(error, null);
        String hashed = this.hash(compile);
        if (this.collected.compute(hashed, (k, v) -> v == null ? 1 : v + 1) > 1) {
            return;
        }
        this.reports.put(hashed, compile);
    }

    private String hash(JsonObject report) {
        long[] hash = MurmurHash3.hash(report.toString());
        return Long.toHexString(hash[0]) + Long.toHexString(hash[1]);
    }

    private JsonObject compile(Throwable error, @Nullable List<StackTraceElement> suppress) {
        int i;
        List<StackTraceElement> stack = Arrays.asList(error.getStackTrace());
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>(stack);
        if (suppress != null) {
            list.removeAll(suppress);
        }
        int traces = Math.min(list.size(), this.stackTraceLimit);
        JsonObject report = new JsonObject();
        JsonArray stacktrace = new JsonArray(traces);
        for (i = 0; i < traces; ++i) {
            stacktrace.add(list.get(i).toString());
        }
        if (traces > 0 && traces < list.size()) {
            stacktrace.add("and " + (list.size() - traces) + " more...");
        } else {
            i = stack.size() - list.size();
            if (i > 0) {
                stacktrace.add("Omitted " + i + " duplicate stack frame" + (i == 1 ? "" : "s"));
            }
        }
        report.addProperty("error", error.getClass().getName());
        if (error.getMessage() != null) {
            report.addProperty("message", this.anonymize(error.getMessage()));
        }
        if (!stacktrace.isEmpty()) {
            report.add("stack", (JsonElement)stacktrace);
        }
        if (error.getCause() != null) {
            ArrayList<StackTraceElement> toSuppress = new ArrayList<StackTraceElement>(stack);
            if (suppress != null) {
                toSuppress.addAll(suppress);
            }
            report.add("cause", (JsonElement)this.compile(error.getCause(), toSuppress));
        }
        return report;
    }

    private String anonymize(String message) {
        message = message.replaceAll(IPV4_PATTERN, "[IP hidden]");
        message = message.replaceAll(IPV6_PATTERN, "[IP hidden]");
        message = message.replaceAll(USER_HOME_PATH_PATTERN, "$1$2$3[username hidden]");
        String username = System.getProperty("user.name");
        if (username != null) {
            message = message.replace(username, "[username hidden]");
        }
        return message;
    }

    public JsonArray getData() {
        JsonArray report = new JsonArray(this.reports.size());
        this.reports.forEach((hash, object) -> {
            JsonObject copy = object.deepCopy();
            copy.addProperty("hash", hash);
            Integer count = this.collected.getOrDefault(hash, 1);
            if (count > 1) {
                copy.addProperty("count", (Number)count);
            }
            report.add((JsonElement)copy);
        });
        this.collected.forEach((hash, count) -> {
            if (count <= 0 || this.reports.containsKey(hash)) {
                return;
            }
            JsonObject entry = new JsonObject();
            entry.addProperty("hash", hash);
            if (count > 1) {
                entry.addProperty("count", (Number)count);
            }
            report.add((JsonElement)entry);
        });
        return report;
    }

    public void clear() {
        this.collected.replaceAll((k, v) -> 0);
        this.reports.clear();
    }

    @Override
    public void attachErrorContext(@Nullable ClassLoader loader) {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((thread, error) -> {
            if (handler != null) {
                handler.uncaughtException(thread, error);
            }
            if (loader != null && !this.isSameLoader(loader, error)) {
                return;
            }
            if (this.errorEvent != null) {
                this.errorEvent.accept(loader, error);
            }
            this.trackError(error);
        });
    }

    @Override
    public void setContextErrorHandler(@Nullable BiConsumer<@Nullable ClassLoader, Throwable> errorEvent) {
        this.errorEvent = errorEvent;
    }

    @Override
    public Optional<BiConsumer<@Nullable ClassLoader, Throwable>> getContextErrorHandler() {
        return Optional.ofNullable(this.errorEvent);
    }

    @Override
    public TrackingBase base() {
        return this.base;
    }

    @Override
    public TrackingExecutors executors() {
        return this.executors;
    }

    @Override
    public TrackingThreadFactory threadFactory() {
        return this.threadFactory;
    }

    @Override
    public TrackingThreadPoolExecutor threadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    private boolean isSameLoader(ClassLoader loader, Throwable error) {
        StackTraceElement[] stackTrace = error.getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            return false;
        }
        int firstNonLibraryIndex = this.findFirstNonLibraryFrameIndex(stackTrace);
        if (firstNonLibraryIndex == -1) {
            return false;
        }
        int framesToCheck = Math.min(5, stackTrace.length - firstNonLibraryIndex);
        for (int i = 0; i < framesToCheck; ++i) {
            StackTraceElement frame = stackTrace[firstNonLibraryIndex + i];
            if (this.isLibraryClass(frame.getClassName()) || this.isFromLoader(frame, loader)) continue;
            return false;
        }
        return true;
    }

    private int findFirstNonLibraryFrameIndex(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (this.isLibraryClass(stackTrace[i].getClassName())) continue;
            return i;
        }
        return -1;
    }

    private boolean isLibraryClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("jdk.");
    }

    private boolean isFromLoader(StackTraceElement frame, ClassLoader loader) {
        try {
            Class<?> clazz = Class.forName(frame.getClassName(), false, loader);
            return this.isSameClassLoader(clazz.getClassLoader(), loader);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isSameClassLoader(ClassLoader classLoader, ClassLoader loader) {
        ClassLoader current;
        if (classLoader == loader) {
            return true;
        }
        for (current = classLoader; current != null && current != loader; current = current.getParent()) {
        }
        return loader == current;
    }
}

