/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.command.spawn;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Rotation;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.command.WorldCommand;
import net.thenextlvl.perworlds.command.brigadier.SimpleCommand;
import net.thenextlvl.perworlds.command.suggestion.GroupMemberSuggestionProvider;
import org.bukkit.Location;
import org.bukkit.World;

final class GroupSpawnSetCommand
extends SimpleCommand {
    private GroupSpawnSetCommand(PerWorldsPlugin plugin) {
        super(plugin, "set", "perworlds.command.group.spawn.set");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(PerWorldsPlugin plugin) {
        GroupSpawnSetCommand command = new GroupSpawnSetCommand(plugin);
        return ((LiteralArgumentBuilder)command.create().then(command.targetArgument())).executes((Command)command);
    }

    private ArgumentBuilder<CommandSourceStack, ?> targetArgument() {
        return WorldCommand.groupArgument(this.plugin, true).then(this.worldArgument().then(this.positionArgument().then(this.rotationArgument().executes((Command)this)).executes((Command)this)));
    }

    private ArgumentBuilder<CommandSourceStack, ?> positionArgument() {
        return Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition());
    }

    private ArgumentBuilder<CommandSourceStack, ?> rotationArgument() {
        return Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation());
    }

    private ArgumentBuilder<CommandSourceStack, ?> worldArgument() {
        return Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).suggests(new GroupMemberSuggestionProvider());
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        FinePositionResolver positionResolver = this.tryGetArgument(context, "position", FinePositionResolver.class).orElse(null);
        RotationResolver rotationResolver = this.tryGetArgument(context, "rotation", RotationResolver.class).orElse(null);
        World world = this.tryGetArgument(context, "world", World.class).orElseGet(() -> ((CommandSourceStack)context.getSource()).getLocation().getWorld());
        WorldGroup group = this.tryGetArgument(context, "group", WorldGroup.class).orElseGet(() -> this.plugin.groupProvider().getGroup(world).orElse(this.plugin.groupProvider().getUnownedWorldGroup()));
        Location position = positionResolver != null ? (FinePosition)positionResolver.resolve((CommandSourceStack)context.getSource()) : ((CommandSourceStack)context.getSource()).getLocation();
        Rotation rotation = rotationResolver != null ? (Rotation)rotationResolver.resolve((CommandSourceStack)context.getSource()) : Rotation.rotation((float)0.0f, (float)0.0f);
        Location location = position.toLocation(world).setRotation(rotation);
        group.getGroupData().setSpawnLocation(location);
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "group.spawn.set", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName()), Placeholder.parsed((String)"world", (String)location.getWorld().getName()), Formatter.number((String)"x", (Number)location.x()), Formatter.number((String)"y", (Number)location.y()), Formatter.number((String)"z", (Number)location.z()), Formatter.number((String)"yaw", (Number)Float.valueOf(location.getYaw())), Formatter.number((String)"pitch", (Number)Float.valueOf(location.getPitch()))});
        return 1;
    }
}

