/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.thenextlvl.perworlds.model.PaperBlockTypeStat;
import net.thenextlvl.perworlds.model.PaperCustomStat;
import net.thenextlvl.perworlds.model.PaperEntityTypeStat;
import net.thenextlvl.perworlds.model.PaperItemTypeStat;
import net.thenextlvl.perworlds.statistics.BlockTypeStat;
import net.thenextlvl.perworlds.statistics.CustomStat;
import net.thenextlvl.perworlds.statistics.EntityTypeStat;
import net.thenextlvl.perworlds.statistics.ItemTypeStat;
import net.thenextlvl.perworlds.statistics.Stat;
import net.thenextlvl.perworlds.statistics.Statistics;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.block.BlockType;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperStatistics
implements Statistics {
    private final Map<Statistic, Stat> statistics;

    public PaperStatistics(HashMap<Statistic, Stat> values) {
        this.statistics = values;
    }

    public PaperStatistics() {
        this(new HashMap<Statistic, Stat>());
    }

    @Override
    public @Unmodifiable Map<Statistic, Stat> getStatistics() {
        return Map.copyOf(this.statistics);
    }

    @Override
    public int getStatistic(Statistic statistic) {
        int n;
        Preconditions.checkState((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Statistic type must be UNTYPED");
        Stat stat = this.statistics.get(statistic);
        if (stat instanceof CustomStat) {
            CustomStat stat2 = (CustomStat)stat;
            n = stat2.getValue();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getStatistic(Statistic statistic, BlockType type) {
        int n;
        Preconditions.checkState((statistic.getType() == Statistic.Type.BLOCK ? 1 : 0) != 0, (Object)"Statistic type must be BLOCK");
        Stat stat = this.statistics.get(statistic);
        if (stat instanceof BlockTypeStat) {
            BlockTypeStat stat2 = (BlockTypeStat)stat;
            n = stat2.getValue(type);
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType type) {
        int n;
        Preconditions.checkState((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"Statistic type must be ENTITY");
        Stat stat = this.statistics.get(statistic);
        if (stat instanceof EntityTypeStat) {
            EntityTypeStat stat2 = (EntityTypeStat)stat;
            n = stat2.getValue(type);
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getStatistic(Statistic statistic, ItemType type) {
        int n;
        Preconditions.checkState((statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"Statistic type must be ITEM");
        Stat stat = this.statistics.get(statistic);
        if (stat instanceof ItemTypeStat) {
            ItemTypeStat stat2 = (ItemTypeStat)stat;
            n = stat2.getValue(type);
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void setStatistic(Statistic statistic, BlockType type, int value) {
        Preconditions.checkState((statistic.getType() == Statistic.Type.BLOCK ? 1 : 0) != 0, (Object)"Statistic type must be BLOCK");
        ((BlockTypeStat)this.statistics.computeIfAbsent(statistic, ignored -> new PaperBlockTypeStat())).setValue(type, value);
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType type, int value) {
        Preconditions.checkState((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"Statistic type must be ENTITY");
        ((EntityTypeStat)this.statistics.computeIfAbsent(statistic, ignored -> new PaperEntityTypeStat())).setValue(type, value);
    }

    @Override
    public void setStatistic(Statistic statistic, ItemType type, int value) {
        Preconditions.checkState((statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"Statistic type must be ITEM");
        ((ItemTypeStat)this.statistics.computeIfAbsent(statistic, ignored -> new PaperItemTypeStat())).setValue(type, value);
    }

    @Override
    public void setStatistic(Statistic statistic, int value) {
        Preconditions.checkState((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Statistic type must be UNTYPED");
        ((CustomStat)this.statistics.computeIfAbsent(statistic, ignored -> new PaperCustomStat())).setValue(value);
    }

    @Override
    public boolean hasData(Statistic statistic) {
        Stat stat = this.statistics.get(statistic);
        return stat != null && stat.hasData();
    }

    @Override
    public void forEachStatistic(BiConsumer<Statistic, Stat> action) {
        this.statistics.forEach(action);
    }

    public static PaperStatistics of(Player player) {
        PaperStatistics stats = new PaperStatistics();
        Registry.STATISTIC.forEach(statistic -> {
            switch (statistic.getType()) {
                case UNTYPED: {
                    stats.setStatistic((Statistic)statistic, player.getStatistic(statistic));
                    break;
                }
                case ITEM: {
                    Registry.ITEM.forEach(type -> {
                        Material material = (Material)Registry.MATERIAL.get(type.key());
                        if (material == null) {
                            return;
                        }
                        stats.setStatistic((Statistic)statistic, (ItemType)type, player.getStatistic(statistic, material));
                    });
                    break;
                }
                case BLOCK: {
                    Registry.BLOCK.forEach(type -> {
                        Material material = (Material)Registry.MATERIAL.get(type.key());
                        if (material == null) {
                            return;
                        }
                        stats.setStatistic((Statistic)statistic, (BlockType)type, player.getStatistic(statistic, material));
                    });
                    break;
                }
                case ENTITY: {
                    Registry.ENTITY_TYPE.forEach(type -> stats.setStatistic((Statistic)statistic, (EntityType)type, player.getStatistic(statistic, type)));
                }
            }
        });
        return stats;
    }
}

