/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import net.thenextlvl.perworlds.data.AttributeDataImpl;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface AttributeData {
    @Contract(pure=true)
    public Attribute attribute();

    @Contract(pure=true)
    public double baseValue();

    @Contract(value="_ -> new", pure=true)
    public AttributeData baseValue(double var1);

    @Contract(value="_, _ -> new", pure=true)
    public static AttributeData of(Attribute attribute, double baseValue) {
        return new AttributeDataImpl(attribute, baseValue);
    }

    @Contract(value="_ -> new", pure=true)
    public static AttributeData of(AttributeInstance instance) {
        return AttributeData.of(instance.getAttribute(), instance.getBaseValue());
    }
}

