/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.adapter.statistic;

import java.util.HashMap;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.model.PaperStatistics;
import net.thenextlvl.perworlds.statistics.BlockTypeStat;
import net.thenextlvl.perworlds.statistics.CustomStat;
import net.thenextlvl.perworlds.statistics.EntityTypeStat;
import net.thenextlvl.perworlds.statistics.ItemTypeStat;
import net.thenextlvl.perworlds.statistics.Stat;
import net.thenextlvl.perworlds.statistics.Statistics;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class StatisticsAdapter
implements TagAdapter<Statistics> {
    private final PerWorldsPlugin plugin;

    public StatisticsAdapter(PerWorldsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Statistics deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        HashMap<Statistic, Stat> values = new HashMap<Statistic, Stat>();
        tag.getAsCompound().forEach((key, value) -> {
            Statistic statistic = (Statistic)Registry.STATISTIC.get(Key.key((String)key));
            if (statistic == null) {
                this.plugin.getLogger().warning("Unknown statistic: " + key);
            } else {
                values.put(statistic, context.deserialize((Tag)value, StatisticsAdapter.getType(statistic)));
            }
        });
        return new PaperStatistics(values);
    }

    @Override
    public Tag serialize(Statistics statistics, TagSerializationContext context) throws ParserException {
        CompoundTag.Builder tag = CompoundTag.builder();
        statistics.forEachStatistic((statistic, value) -> {
            if (value.hasData()) {
                tag.put(statistic.key().asString(), context.serialize(value));
            }
        });
        return tag.build();
    }

    private static Class<? extends Stat> getType(Statistic statistic) {
        return switch (statistic.getType()) {
            default -> throw new MatchException(null, null);
            case Statistic.Type.UNTYPED -> CustomStat.class;
            case Statistic.Type.ITEM -> ItemTypeStat.class;
            case Statistic.Type.BLOCK -> BlockTypeStat.class;
            case Statistic.Type.ENTITY -> EntityTypeStat.class;
        };
    }
}

