/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.model;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.data.AdvancementData;
import net.thenextlvl.perworlds.data.AttributeData;
import net.thenextlvl.perworlds.data.PlayerData;
import net.thenextlvl.perworlds.data.WardenSpawnTracker;
import net.thenextlvl.perworlds.group.PaperWorldGroup;
import net.thenextlvl.perworlds.model.PaperStatistics;
import net.thenextlvl.perworlds.statistics.BlockTypeStat;
import net.thenextlvl.perworlds.statistics.CustomStat;
import net.thenextlvl.perworlds.statistics.EntityTypeStat;
import net.thenextlvl.perworlds.statistics.ItemTypeStat;
import net.thenextlvl.perworlds.statistics.Stat;
import net.thenextlvl.perworlds.statistics.Statistics;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftRecipe;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotConfig;

@NullMarked
public final class PaperPlayerData
implements PlayerData {
    private static final @Nullable ItemStack[] DEFAULT_ENDERCHEST = new ItemStack[27];
    private static final @Nullable ItemStack[] DEFAULT_INVENTORY = new ItemStack[40];
    private static final @Nullable Location DEFAULT_LAST_DEATH_LOCATION = null;
    private static final @Nullable Location DEFAULT_LAST_LOCATION = null;
    private static final @Nullable Location DEFAULT_RESPAWN_LOCATION = null;
    private static final Set<AttributeData> DEFAULT_ATTRIBUTES = PaperPlayerData.defaultAttributes();
    private static final TriState DEFAULT_FLYING = TriState.NOT_SET;
    private static final TriState DEFAULT_MAY_FLY = TriState.NOT_SET;
    private static final TriState DEFAULT_VISUAL_FIRE = TriState.NOT_SET;
    private static final Vector DEFAULT_VELOCITY = new Vector(0, 0, 0);
    private static final WardenSpawnTracker DEFAULT_WARDEN_SPAWN_TRACKER = WardenSpawnTracker.create();
    private static final boolean DEFAULT_GLIDING = false;
    private static final boolean DEFAULT_INVULNERABLE = false;
    private static final boolean DEFAULT_LOCK_FREEZE_TICKS = false;
    private static final boolean DEFAULT_SEEN_CREDITS = false;
    private static final double DEFAULT_ABSORPTION = 0.0;
    private static final double DEFAULT_HEALTH = 20.0;
    private static final float DEFAULT_EXHAUSTION = 0.0f;
    private static final float DEFAULT_EXPERIENCE = 0.0f;
    private static final float DEFAULT_FALL_DISTANCE = 0.0f;
    private static final float DEFAULT_FLY_SPEED = 0.1f;
    private static final float DEFAULT_SATURATION = 10.0f;
    private static final float DEFAULT_WALK_SPEED = 0.2f;
    private static final int DEFAULT_ARROWS_IN_BODY = 0;
    private static final int DEFAULT_BEE_STINGERS_IN_BODY = 0;
    private static final int DEFAULT_FIRE_TICKS = 0;
    private static final int DEFAULT_FOOD_LEVEL = 20;
    private static final int DEFAULT_FREEZE_TICKS = 0;
    private static final int DEFAULT_HELD_ITEM_SLOT = 0;
    private static final int DEFAULT_LEVEL = 0;
    private static final int DEFAULT_PORTAL_COOLDOWN = 0;
    private static final int DEFAULT_REMAINING_AIR = 300;
    private static final int DEFAULT_SCORE = 0;
    private @Nullable GameMode gameMode = null;
    private @Nullable GameMode previousGameMode = null;
    private @Nullable ItemStack[] enderChest = DEFAULT_ENDERCHEST;
    private @Nullable ItemStack[] inventory = DEFAULT_INVENTORY;
    private @Nullable Key lastAdvancementTab = null;
    private @Nullable Location lastDeathLocation = DEFAULT_LAST_DEATH_LOCATION;
    private @Nullable Location lastLocation = DEFAULT_LAST_LOCATION;
    private @Nullable Location respawnLocation = DEFAULT_RESPAWN_LOCATION;
    private List<PotionEffect> potionEffects = List.of();
    private Set<AdvancementData> advancements = Set.of();
    private Set<AttributeData> attributes = DEFAULT_ATTRIBUTES;
    private Set<NamespacedKey> recipes = Set.of();
    private Statistics statistics = new PaperStatistics();
    private TriState flying = DEFAULT_FLYING;
    private TriState mayFly = DEFAULT_MAY_FLY;
    private TriState visualFire = DEFAULT_VISUAL_FIRE;
    private Vector velocity = DEFAULT_VELOCITY;
    private WardenSpawnTracker wardenSpawnTracker = DEFAULT_WARDEN_SPAWN_TRACKER;
    private boolean gliding = false;
    private boolean invulnerable = false;
    private boolean lockFreezeTicks = false;
    private boolean seenCredits = false;
    private double absorption = 0.0;
    private double health = 20.0;
    private float exhaustion = 0.0f;
    private float experience = 0.0f;
    private float fallDistance = 0.0f;
    private float flySpeed = 0.1f;
    private float saturation = 10.0f;
    private float walkSpeed = 0.2f;
    private int arrowsInBody = 0;
    private int beeStingersInBody = 0;
    private int fireTicks = 0;
    private int foodLevel = 20;
    private int freezeTicks = 0;
    private int heldItemSlot = 0;
    private int level = 0;
    private int portalCooldown = 0;
    private int remainingAir = 300;
    private int score = 0;
    private @Nullable UUID uuid;
    private @Nullable PaperWorldGroup group;

    public PaperPlayerData(@Nullable UUID uuid, @Nullable PaperWorldGroup group) {
        this.group = group;
        this.uuid = uuid;
    }

    public static PaperPlayerData of(Player player, PaperWorldGroup group) {
        PaperPlayerData data = new PaperPlayerData(player.getUniqueId(), group);
        return ((PaperPlayerData)((PaperPlayerData)((PaperPlayerData)((PaperPlayerData)data.attributes(PaperPlayerData.collectAttributes(player))).advancements(data.collectAdvancements(player))).lastAdvancementTab(data.getLastAdvancementTab(player)).invulnerable(((CraftPlayer)player).getHandle().isInvulnerable()).portalCooldown(player.getPortalCooldown()).gliding(player.isGliding()).wardenSpawnTracker(WardenSpawnTracker.of(player)).lastDeathLocation(player.getLastDeathLocation()).lastLocation(player.getLocation()).velocity(player.getVelocity()).lockFreezeTicks(player.isFreezeTickingLocked()).visualFire(player.getVisualFire()).previousGameMode(player.getPreviousGameMode()).flying(TriState.byBoolean((boolean)player.isFlying())).mayFly(TriState.byBoolean((boolean)player.getAllowFlight())).enderChest(player.getEnderChest().getContents()).inventory(player.getInventory().getContents()).respawnLocation(player.getRespawnLocation(false)).potionEffects(player.getActivePotionEffects())).gameMode(player.getGameMode()).stats(PaperStatistics.of(player)).discoveredRecipes((Collection)player.getDiscoveredRecipes())).seenCredits(player.hasSeenWinScreen()).absorption(player.getAbsorptionAmount()).health(player.getHealth()).exhaustion(player.getExhaustion()).fallDistance(player.getFallDistance()).experience(player.getExp()).saturation(player.getSaturation()).arrowsInBody(player.getArrowsInBody()).walkSpeed(player.getWalkSpeed()).flySpeed(player.getFlySpeed()).beeStingersInBody(player.getBeeStingersInBody()).fireTicks(player.getFireTicks()).foodLevel(player.getFoodLevel()).freezeTicks(player.getFreezeTicks()).heldItemSlot(player.getInventory().getHeldItemSlot()).level(player.getLevel()).remainingAir(player.getRemainingAir()).score(player.getDeathScreenScore());
    }

    private static Set<AttributeData> collectAttributes(Player player) {
        return Registry.ATTRIBUTE.stream().map(arg_0 -> ((Player)player).getAttribute(arg_0)).filter(Objects::nonNull).map(AttributeData::of).collect(Collectors.toSet());
    }

    private Set<AdvancementData> collectAdvancements(Player player) {
        if (SpigotConfig.disableAdvancementSaving) {
            return Set.of();
        }
        ServerPlayer handle = ((CraftPlayer)player).getHandle();
        Map<AdvancementHolder, AdvancementProgress> progress = this.getProgress(handle, handle.getAdvancements());
        HashSet<AdvancementData> data = new HashSet<AdvancementData>();
        progress.forEach((key, value) -> {
            if (!value.hasProgress() || !this.isEnabled(key.id())) {
                return;
            }
            HashMap<String, Instant> awardedCriteria = new HashMap<String, Instant>();
            HashSet<String> remainingCriteria = new HashSet<String>();
            value.getCompletedCriteria().forEach(criteria -> {
                Instant obtained;
                CriterionProgress criterion = value.getCriterion(criteria);
                Instant instant = obtained = criterion != null ? criterion.getObtained() : null;
                if (obtained != null) {
                    awardedCriteria.put((String)criteria, obtained);
                }
            });
            value.getRemainingCriteria().forEach(remainingCriteria::add);
            data.add(AdvancementData.of(key.toBukkit(), awardedCriteria, remainingCriteria));
        });
        return data;
    }

    private boolean isEnabled(Identifier location) {
        List disabled = SpigotConfig.disabledAdvancements;
        if (disabled == null || disabled.isEmpty()) {
            return true;
        }
        if (disabled.contains("*")) {
            return false;
        }
        if (disabled.contains(location.toString())) {
            return false;
        }
        return !disabled.contains(location.getNamespace());
    }

    private @Nullable Key getLastAdvancementTab(Player player) {
        try {
            ServerPlayer handle = ((CraftPlayer)player).getHandle();
            Field progress = handle.getAdvancements().getClass().getDeclaredField("lastSelectedTab");
            boolean access = progress.canAccess(handle.getAdvancements());
            if (!access) {
                progress.setAccessible(true);
            }
            AdvancementHolder tab = (AdvancementHolder)progress.get(handle.getAdvancements());
            progress.setAccessible(access);
            return tab != null ? Key.key((String)tab.id().getNamespace(), (String)tab.id().getPath()) : null;
        }
        catch (Exception e) {
            this.group().getGroupProvider().getLogger().error("Failed to get last selected advancement tab from player {}", (Object)player.getName(), (Object)e);
            this.group().getGroupProvider().getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
            return null;
        }
    }

    @Override
    public CompletableFuture<Boolean> load(Player player, boolean position) {
        if (this.group == null || this.uuid == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Player data has not been finalized yet"));
        }
        if (!player.getUniqueId().equals(this.uuid)) {
            return CompletableFuture.failedFuture(new IllegalStateException("Player UUID mismatch: Expected '" + String.valueOf(this.uuid) + "' but got '" + String.valueOf(player.getUniqueId()) + "'"));
        }
        GroupSettings settings = this.group.getSettings();
        if (!settings.enabled()) {
            return CompletableFuture.completedFuture(false);
        }
        if (!position && this.group.containsWorld(player.getWorld())) {
            this.load(player, this.group);
            return CompletableFuture.completedFuture(true);
        }
        if (!position) {
            return CompletableFuture.failedFuture(new IllegalStateException("Failed to load player data: World mismatch between group '%s' and player '%s'. Expected any of %s but got %s".formatted(this.group.getName(), player.getName(), this.group.getPersistedWorlds(), player.getWorld().key())));
        }
        Location location = this.group.getSpawnLocation(this).orElse(null);
        if (location == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (player.isDead()) {
            ServerPlayer handle = ((CraftPlayer)player).getHandle();
            handle.setPose(Pose.STANDING);
            handle.reset();
            handle.unsetRemoved();
        }
        return player.teleportAsync(location).thenApply(success -> {
            if (!success.booleanValue()) {
                return false;
            }
            player.setFallDistance(settings.fallDistance() ? this.fallDistance : 0.0f);
            player.setVelocity(settings.velocity() ? this.velocity : DEFAULT_VELOCITY);
            this.load(player, this.group);
            return true;
        });
    }

    private void load(Player player, WorldGroup group) {
        GroupSettings settings = group.getSettings();
        GameMode defaultGameMode = group.getGroupData().getDefaultGameMode().orElseGet(() -> player.getServer().getDefaultGameMode());
        player.setGameMode(settings.gameMode() && this.previousGameMode != null ? this.previousGameMode : defaultGameMode);
        player.setGameMode(settings.gameMode() && this.gameMode != null ? this.gameMode : defaultGameMode);
        this.applyAttributes(player, settings);
        player.setGliding(settings.gliding() ? this.gliding : false);
        player.setPortalCooldown(settings.portalCooldown() ? this.portalCooldown : 0);
        player.getInventory().setHeldItemSlot(settings.hotbarSlot() ? this.heldItemSlot : 0);
        player.getInventory().setContents(settings.inventory() ? this.inventory : DEFAULT_INVENTORY);
        player.getEnderChest().setContents(settings.enderChest() ? this.enderChest : DEFAULT_ENDERCHEST);
        player.setHasSeenWinScreen(settings.endCredits() ? this.seenCredits : false);
        player.setArrowsInBody(settings.arrowsInBody() ? this.arrowsInBody : 0);
        player.setBeeStingersInBody(settings.beeStingersInBody() ? this.beeStingersInBody : 0);
        player.setDeathScreenScore(settings.score() ? this.score : 0);
        player.setExp(settings.experience() ? this.experience : 0.0f);
        player.setLevel(settings.experience() ? this.level : 0);
        player.setInvulnerable(settings.invulnerable() ? this.invulnerable : false);
        AttributeInstance attribute = player.getAttribute(Attribute.MAX_HEALTH);
        double maxHealth = attribute != null ? attribute.getValue() : 20.0;
        ServerPlayer handle = ((CraftPlayer)player).getHandle();
        handle.setHealth((float)Math.clamp(settings.health() ? this.health : 20.0, 0.0, maxHealth));
        player.setAbsorptionAmount(settings.absorption() ? this.absorption : 0.0);
        player.setExhaustion(settings.exhaustion() ? this.exhaustion : 0.0f);
        player.setFoodLevel(settings.foodLevel() ? this.foodLevel : 20);
        player.setSaturation(settings.saturation() ? this.saturation : 10.0f);
        player.setFireTicks(settings.fireTicks() ? this.fireTicks : 0);
        player.setFreezeTicks(settings.freezeTicks() ? this.freezeTicks : 0);
        player.lockFreezeTicks(settings.lockFreezeTicks() ? this.lockFreezeTicks : false);
        player.setRemainingAir(settings.remainingAir() ? this.remainingAir : 300);
        player.setVisualFire(settings.visualFire() ? this.visualFire : DEFAULT_VISUAL_FIRE);
        player.setLastDeathLocation(settings.lastDeathLocation() ? this.lastDeathLocation : DEFAULT_LAST_DEATH_LOCATION);
        player.setRespawnLocation(settings.respawnLocation() ? this.respawnLocation : DEFAULT_RESPAWN_LOCATION, false);
        player.setFlySpeed(Math.clamp(settings.flySpeed() ? this.flySpeed : 0.1f, -1.0f, 1.0f));
        player.setWalkSpeed(Math.clamp(settings.walkSpeed() ? this.walkSpeed : 0.2f, -1.0f, 1.0f));
        player.setAllowFlight((settings.flyState() ? this.mayFly : DEFAULT_MAY_FLY).toBooleanOrElseGet(() -> player.getGameMode().isInvulnerable()));
        player.setFlying((settings.flyState() ? this.flying : DEFAULT_FLYING).toBooleanOrElseGet(() -> player.getGameMode().equals((Object)GameMode.SPECTATOR)));
        player.clearActivePotionEffects();
        if (settings.potionEffects()) {
            player.addPotionEffects(this.potionEffects);
        }
        WardenSpawnTracker tracker = settings.wardenSpawnTracker() ? this.wardenSpawnTracker : DEFAULT_WARDEN_SPAWN_TRACKER;
        player.setWardenTimeSinceLastWarning(tracker.ticksSinceLastWarning());
        player.setWardenWarningCooldown(tracker.cooldownTicks());
        player.setWardenWarningLevel(tracker.warningLevel());
        this.applyStatistics(player, settings);
        this.updateTablistVisibility(player, group);
        this.applyAdvancements(player, settings);
        this.applyRecipes(player, settings);
    }

    private void applyStatistics(Player player, GroupSettings settings) {
        this.clearStatistics(player, settings.statistics());
        if (settings.statistics()) {
            this.statistics.forEachStatistic((statistic, stat) -> {
                Stat stat2 = stat;
                Objects.requireNonNull(stat2);
                Stat selector0$temp = stat2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomStat.class, ItemTypeStat.class, BlockTypeStat.class, EntityTypeStat.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        CustomStat customStat = (CustomStat)selector0$temp;
                        player.setStatistic(statistic, customStat.getValue());
                        break;
                    }
                    case 1: {
                        ItemTypeStat itemStat = (ItemTypeStat)selector0$temp;
                        itemStat.forEachValue((type, value) -> player.setStatistic(statistic, type.asMaterial(), value.intValue()));
                        break;
                    }
                    case 2: {
                        BlockTypeStat blockStat = (BlockTypeStat)selector0$temp;
                        blockStat.forEachValue((type, value) -> player.setStatistic(statistic, type.asMaterial(), value.intValue()));
                        break;
                    }
                    case 3: {
                        EntityTypeStat entityStat = (EntityTypeStat)selector0$temp;
                        entityStat.forEachValue((type, value) -> player.setStatistic(statistic, type, value.intValue()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected stat type: " + stat.getClass().getName());
                    }
                }
            });
        }
    }

    private void clearStatistics(Player player, boolean filter) {
        Registry.STATISTIC.forEach(statistic -> {
            if (filter && this.statistics.hasData((Statistic)statistic)) {
                return;
            }
            switch (statistic.getType()) {
                case UNTYPED: {
                    player.setStatistic(statistic, 0);
                    break;
                }
                case ITEM: {
                    Registry.ITEM.forEach(type -> player.setStatistic(statistic, type.asMaterial(), 0));
                    break;
                }
                case BLOCK: {
                    Registry.BLOCK.forEach(type -> player.setStatistic(statistic, type.asMaterial(), 0));
                    break;
                }
                case ENTITY: {
                    Registry.ENTITY_TYPE.forEach(type -> player.setStatistic(statistic, type, 0));
                }
            }
        });
    }

    private void applyAttributes(Player player, GroupSettings settings) {
        if (settings.attributes()) {
            this.attributes.forEach(data -> this.applyAttribute(player, (AttributeData)data));
        } else {
            DEFAULT_ATTRIBUTES.forEach(data -> this.applyAttribute(player, (AttributeData)data));
        }
    }

    private void applyAttribute(Player player, AttributeData data) {
        AttributeInstance instance = player.getAttribute(data.attribute());
        if (instance != null) {
            instance.setBaseValue(data.baseValue());
        }
    }

    private void updateTablistVisibility(Player player, WorldGroup group) {
        player.getServer().getOnlinePlayers().forEach(other -> {
            WorldGroup otherGroup;
            if (player.equals(other)) {
                return;
            }
            WorldGroup worldGroup = otherGroup = player.getWorld().equals((Object)other.getWorld()) ? group : group.getGroupProvider().getGroup(other.getWorld()).orElse(group.getGroupProvider().getUnownedWorldGroup());
            if (otherGroup.equals(group)) {
                if (other.canSee(player)) {
                    other.listPlayer(player);
                }
                if (player.canSee(other)) {
                    player.listPlayer(other);
                }
            } else {
                if (otherGroup.getSettings().tabList()) {
                    other.unlistPlayer(player);
                }
                if (group.getSettings().tabList()) {
                    player.unlistPlayer(other);
                }
            }
        });
    }

    private void applyRecipes(Player player, GroupSettings settings) {
        if (settings.recipes()) {
            HashSet<NamespacedKey> toAdd = new HashSet<NamespacedKey>(this.recipes);
            toAdd.removeAll(player.getDiscoveredRecipes());
            this.discoverRecipes(player, toAdd);
            HashSet toRemove = new HashSet(player.getDiscoveredRecipes());
            toRemove.removeAll(this.recipes);
            player.undiscoverRecipes(toRemove);
        } else {
            player.undiscoverRecipes((Collection)player.getDiscoveredRecipes());
        }
    }

    private void discoverRecipes(Player player, Set<NamespacedKey> recipes) {
        ServerPlayer handle = ((CraftPlayer)player).getHandle();
        ArrayList list = new ArrayList();
        RecipeManager manager = ((CraftServer)player.getServer()).getServer().getRecipeManager();
        ServerRecipeBook recipeBook = handle.getRecipeBook();
        Stream<RecipeHolder> recipeHolders = recipes.stream().map(CraftRecipe::toMinecraft).map(arg_0 -> ((RecipeManager)manager).byKey(arg_0)).map(recipeHolder -> recipeHolder.orElse(null)).filter(Objects::nonNull);
        recipeHolders.forEach(recipeHolder -> {
            if (recipeBook.known.contains(recipeHolder.id()) || recipeHolder.value().isSpecial()) {
                return;
            }
            recipeBook.add(recipeHolder.id());
            manager.listDisplaysForRecipe(recipeHolder.id(), entry -> list.add(new ClientboundRecipeBookAddPacket.Entry(entry, false, true)));
            this.addHighlight(player, (RecipeHolder<?>)recipeHolder, recipeBook);
        });
        if (!list.isEmpty()) {
            handle.connection.send((Packet)new ClientboundRecipeBookAddPacket(list, false));
        }
    }

    private void addHighlight(Player player, RecipeHolder<?> recipeHolder, ServerRecipeBook recipeBook) {
        try {
            Method addHighlight = recipeBook.getClass().getDeclaredMethod("addHighlight", ResourceKey.class);
            boolean access = addHighlight.canAccess(recipeBook);
            if (!access) {
                addHighlight.setAccessible(true);
            }
            addHighlight.invoke((Object)recipeBook, recipeHolder.id());
            addHighlight.setAccessible(access);
        }
        catch (Exception e) {
            this.group().getGroupProvider().getLogger().error("Failed to add recipe highlight for player {}", (Object)player.getName(), (Object)e);
            this.group().getGroupProvider().getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
        }
    }

    private void applyAdvancements(Player player, GroupSettings settings) {
        try {
            Method progressUpdate;
            boolean access;
            ServerPlayer handle = ((CraftPlayer)player).getHandle();
            DedicatedServer server = ((CraftServer)player.getServer()).getServer();
            PlayerAdvancements advancements = handle.getAdvancements();
            HashSet toRemove = new HashSet(server.getAdvancements().getAllAdvancements());
            Set<AdvancementHolder> progressChanged = this.getProgressChanged(advancements);
            if (settings.advancements()) {
                this.advancements.stream().map(AdvancementData::getAdvancement).map(CraftAdvancement.class::cast).map(CraftAdvancement::getHandle).forEach(toRemove::remove);
            }
            if (!(access = (progressUpdate = advancements.getClass().getDeclaredMethod("markForVisibilityUpdate", AdvancementHolder.class)).canAccess(advancements))) {
                progressUpdate.setAccessible(true);
            }
            for (AdvancementHolder holder : toRemove) {
                AdvancementProgress progress = advancements.getOrStartProgress(holder);
                progress.getCompletedCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).revokeProgress(arg_0));
                progressUpdate.invoke((Object)advancements, holder);
                progressChanged.add(holder);
            }
            if (settings.advancements()) {
                for (AdvancementData data : this.advancements) {
                    AdvancementHolder holder = ((CraftAdvancement)data.getAdvancement()).getHandle();
                    AdvancementProgress progress = advancements.getOrStartProgress(holder);
                    data.getAwardedCriteria().forEach(name -> this.updateProgress(progress, (String)name, data));
                    data.getRemainingCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).revokeProgress(arg_0));
                    progressUpdate.invoke((Object)advancements, holder);
                    progressChanged.add(holder);
                }
            }
            progressUpdate.setAccessible(access);
            advancements.flushDirty(handle, false);
            if (settings.advancements()) {
                Identifier tab = this.lastAdvancementTab != null ? Identifier.fromNamespaceAndPath((String)this.lastAdvancementTab.namespace(), (String)this.lastAdvancementTab.value()) : null;
                advancements.setSelectedTab(tab != null ? server.getAdvancements().get(tab) : null);
            }
        }
        catch (Exception e) {
            this.group().getGroupProvider().getLogger().error("Failed to update advancements for player {}", (Object)player.getName(), (Object)e);
            this.group().getGroupProvider().getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
        }
    }

    private Set<AdvancementHolder> getProgressChanged(PlayerAdvancements advancements) throws NoSuchFieldException, IllegalAccessException {
        Field progress = advancements.getClass().getDeclaredField("progressChanged");
        boolean access = progress.canAccess(advancements);
        if (!access) {
            progress.setAccessible(true);
        }
        Set progressChanged = (Set)progress.get(advancements);
        progress.setAccessible(access);
        return progressChanged;
    }

    private Map<AdvancementHolder, AdvancementProgress> getProgress(ServerPlayer player, PlayerAdvancements advancements) {
        try {
            Field progress = advancements.getClass().getDeclaredField("progress");
            boolean access = progress.canAccess(advancements);
            if (!access) {
                progress.setAccessible(true);
            }
            Map progressChanged = (Map)progress.get(advancements);
            progress.setAccessible(access);
            return progressChanged;
        }
        catch (Exception e) {
            this.group().getGroupProvider().getLogger().error("Failed to get advancement progress for player {}", (Object)player.getName(), (Object)e);
            this.group().getGroupProvider().getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
            return new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
        }
    }

    private void updateProgress(AdvancementProgress progress, String criteria, AdvancementData data) {
        try {
            CriterionProgress criterion = progress.getCriterion(criteria);
            if (criterion == null) {
                return;
            }
            Field obtained = criterion.getClass().getDeclaredField("obtained");
            boolean access = obtained.canAccess(criterion);
            if (!access) {
                obtained.setAccessible(true);
            }
            obtained.set(criterion, data.getTimeAwarded(criteria));
            obtained.setAccessible(access);
        }
        catch (Exception e) {
            this.group().getGroupProvider().getLogger().error("Failed to update advancement progress {}", (Object)criteria, (Object)e);
            this.group().getGroupProvider().getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
        }
    }

    public PaperPlayerData finalize(OfflinePlayer player, PaperWorldGroup group) {
        Preconditions.checkState((this.group == null || this.uuid == null ? 1 : 0) != 0, (Object)"Player data has already been finalized");
        if (this.respawnLocation != null && !group.containsWorld(this.respawnLocation.getWorld())) {
            this.respawnLocation = null;
        }
        if (this.lastDeathLocation != null && !group.containsWorld(this.lastDeathLocation.getWorld())) {
            this.lastDeathLocation = null;
        }
        if (this.lastLocation != null && !group.containsWorld(this.lastLocation.getWorld())) {
            this.lastLocation = null;
        }
        this.uuid = player.getUniqueId();
        this.group = group;
        return this;
    }

    @Override
    public PaperWorldGroup group() {
        Preconditions.checkState((this.group != null ? 1 : 0) != 0, (Object)"Player data has not been finalized yet");
        return this.group;
    }

    @Override
    public UUID uuid() {
        Preconditions.checkState((this.uuid != null ? 1 : 0) != 0, (Object)"Player data has not been finalized yet");
        return this.uuid;
    }

    @Override
    public @Nullable ItemStack[] enderChest() {
        return (ItemStack[])this.enderChest.clone();
    }

    @Override
    public @Nullable ItemStack[] inventory() {
        return (ItemStack[])this.inventory.clone();
    }

    @Override
    public @Unmodifiable List<PotionEffect> potionEffects() {
        return this.potionEffects;
    }

    @Override
    public @Nullable GameMode gameMode() {
        return this.gameMode;
    }

    @Override
    public @Nullable GameMode previousGameMode() {
        return this.previousGameMode;
    }

    @Override
    public @Nullable Location lastDeathLocation() {
        return this.lastDeathLocation != null ? this.lastDeathLocation.clone() : null;
    }

    @Override
    public @Nullable Location lastLocation() {
        return this.lastLocation != null ? this.lastLocation.clone() : null;
    }

    @Override
    public @Nullable Location respawnLocation() {
        return this.respawnLocation != null ? this.respawnLocation.clone() : null;
    }

    @Override
    public @Nullable Key lastAdvancementTab() {
        return this.lastAdvancementTab;
    }

    @Override
    public PaperPlayerData lastAdvancementTab(@Nullable Key key) {
        this.lastAdvancementTab = key;
        return this;
    }

    @Override
    public PaperPlayerData absorption(double absorption) {
        this.absorption = absorption;
        return this;
    }

    @Override
    public PaperPlayerData advancements(Collection<AdvancementData> advancements) {
        this.advancements = Set.copyOf(advancements);
        return this;
    }

    @Override
    public PaperPlayerData arrowsInBody(int arrowsInBody) {
        this.arrowsInBody = arrowsInBody;
        return this;
    }

    @Override
    public PaperPlayerData attributes(Collection<AttributeData> attributes) {
        this.attributes = Set.copyOf(attributes);
        return this;
    }

    @Override
    public PaperPlayerData beeStingersInBody(int beeStingersInBody) {
        this.beeStingersInBody = beeStingersInBody;
        return this;
    }

    @Override
    public PaperPlayerData discoveredRecipes(Collection<NamespacedKey> recipes) {
        this.recipes = Set.copyOf(recipes);
        return this;
    }

    @Override
    public PaperPlayerData enderChest(@Nullable ItemStack[] contents) {
        this.enderChest = contents;
        return this;
    }

    @Override
    public PaperPlayerData exhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
        return this;
    }

    @Override
    public PaperPlayerData experience(float experience) {
        this.experience = experience;
        return this;
    }

    @Override
    public PaperPlayerData fallDistance(float fallDistance) {
        this.fallDistance = fallDistance;
        return this;
    }

    @Override
    public PaperPlayerData fireTicks(int fireTicks) {
        this.fireTicks = fireTicks;
        return this;
    }

    @Override
    public PaperPlayerData flySpeed(@Range(from=-1L, to=1L) float speed) {
        Preconditions.checkArgument((speed >= -1.0f && speed <= 1.0f ? 1 : 0) != 0, (Object)"Speed must be between -1 and 1");
        this.flySpeed = speed;
        return this;
    }

    @Override
    public PaperPlayerData flying(TriState flying) {
        this.flying = flying;
        return this;
    }

    @Override
    public PaperPlayerData foodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
        return this;
    }

    @Override
    public PaperPlayerData freezeTicks(int freezeTicks) {
        this.freezeTicks = freezeTicks;
        return this;
    }

    @Override
    public PaperPlayerData gameMode(@Nullable GameMode gameMode) {
        this.gameMode = gameMode;
        return this;
    }

    @Override
    public PaperPlayerData gliding(boolean gliding) {
        this.gliding = gliding;
        return this;
    }

    @Override
    public PaperPlayerData health(double health) {
        Preconditions.checkArgument((health >= 0.0 ? 1 : 0) != 0, (Object)"Health must be greater than or equal to 0");
        this.health = health;
        return this;
    }

    @Override
    public PaperPlayerData heldItemSlot(int heldItemSlot) {
        this.heldItemSlot = heldItemSlot;
        return this;
    }

    @Override
    public PaperPlayerData inventory(@Nullable ItemStack[] contents) {
        this.inventory = contents;
        return this;
    }

    @Override
    public PaperPlayerData invulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
        return this;
    }

    @Override
    public PaperPlayerData lastDeathLocation(@Nullable Location location) {
        this.lastDeathLocation = location != null && (this.group == null || this.group.containsWorld(location.getWorld())) ? location.clone() : null;
        return this;
    }

    @Override
    public PaperPlayerData lastLocation(@Nullable Location location) {
        this.lastLocation = location != null && (this.group == null || this.group.containsWorld(location.getWorld())) ? location.clone() : null;
        return this;
    }

    @Override
    public PaperPlayerData seenCredits(boolean seenCredits) {
        this.seenCredits = seenCredits;
        return this;
    }

    @Override
    public PaperPlayerData stats(Statistics statistics) {
        this.statistics = statistics;
        return this;
    }

    @Override
    public PaperPlayerData velocity(Vector velocity) {
        this.velocity = velocity.clone();
        return this;
    }

    @Override
    public PaperPlayerData visualFire(TriState visualFire) {
        this.visualFire = visualFire;
        return this;
    }

    @Override
    public PaperPlayerData walkSpeed(@Range(from=-1L, to=1L) float speed) {
        Preconditions.checkArgument((speed >= -1.0f && speed <= 1.0f ? 1 : 0) != 0, (Object)"Speed must be between -1 and 1");
        this.walkSpeed = speed;
        return this;
    }

    @Override
    public PaperPlayerData wardenSpawnTracker(WardenSpawnTracker tracker) {
        this.wardenSpawnTracker = tracker;
        return this;
    }

    @Override
    public @Unmodifiable Set<AdvancementData> advancements() {
        return Set.copyOf(this.advancements);
    }

    @Override
    public PaperPlayerData level(int level) {
        this.level = level;
        return this;
    }

    @Override
    public PaperPlayerData lockFreezeTicks(boolean lockFreezeTicks) {
        this.lockFreezeTicks = lockFreezeTicks;
        return this;
    }

    @Override
    public PaperPlayerData mayFly(TriState mayFly) {
        this.mayFly = mayFly;
        return this;
    }

    @Override
    public PaperPlayerData portalCooldown(int cooldown) {
        this.portalCooldown = cooldown;
        return this;
    }

    @Override
    public PaperPlayerData potionEffects(Collection<PotionEffect> effects) {
        this.potionEffects = List.copyOf(effects);
        return this;
    }

    @Override
    public PaperPlayerData previousGameMode(@Nullable GameMode gameMode) {
        this.previousGameMode = gameMode;
        return this;
    }

    @Override
    public PaperPlayerData remainingAir(int remainingAir) {
        this.remainingAir = remainingAir;
        return this;
    }

    @Override
    public PaperPlayerData respawnLocation(@Nullable Location location) {
        this.respawnLocation = location != null && (this.group == null || this.group.containsWorld(location.getWorld())) ? location.clone() : null;
        return this;
    }

    @Override
    public PaperPlayerData saturation(float saturation) {
        this.saturation = saturation;
        return this;
    }

    @Override
    public PaperPlayerData score(int score) {
        this.score = score;
        return this;
    }

    @Override
    public @Unmodifiable Set<AttributeData> attributes() {
        return this.attributes;
    }

    @Override
    public @Unmodifiable Set<NamespacedKey> discoveredRecipes() {
        return this.recipes;
    }

    @Override
    public Statistics stats() {
        return this.statistics;
    }

    @Override
    public TriState flying() {
        return this.flying;
    }

    @Override
    public TriState mayFly() {
        return this.mayFly;
    }

    @Override
    public TriState visualFire() {
        return this.visualFire;
    }

    @Override
    public Vector velocity() {
        return this.velocity.clone();
    }

    @Override
    public WardenSpawnTracker wardenSpawnTracker() {
        return this.wardenSpawnTracker;
    }

    @Override
    public boolean gliding() {
        return this.gliding;
    }

    @Override
    public boolean invulnerable() {
        return this.invulnerable;
    }

    @Override
    public boolean lockFreezeTicks() {
        return this.lockFreezeTicks;
    }

    @Override
    public boolean seenCredits() {
        return this.seenCredits;
    }

    @Override
    public double absorption() {
        return this.absorption;
    }

    @Override
    public double health() {
        return this.health;
    }

    @Override
    public float exhaustion() {
        return this.exhaustion;
    }

    @Override
    public float experience() {
        return this.experience;
    }

    @Override
    public float fallDistance() {
        return this.fallDistance;
    }

    @Override
    public float flySpeed() {
        return this.flySpeed;
    }

    @Override
    public float saturation() {
        return this.saturation;
    }

    @Override
    public float walkSpeed() {
        return this.flySpeed;
    }

    @Override
    public int arrowsInBody() {
        return this.arrowsInBody;
    }

    @Override
    public int beeStingersInBody() {
        return this.beeStingersInBody;
    }

    @Override
    public int fireTicks() {
        return this.fireTicks;
    }

    @Override
    public int foodLevel() {
        return this.foodLevel;
    }

    @Override
    public int freezeTicks() {
        return this.freezeTicks;
    }

    @Override
    public int heldItemSlot() {
        return this.heldItemSlot;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public int portalCooldown() {
        return this.portalCooldown;
    }

    @Override
    public int remainingAir() {
        return this.remainingAir;
    }

    @Override
    public int score() {
        return this.score;
    }

    private static Set<AttributeData> defaultAttributes() {
        Attributable defaults = EntityType.PLAYER.getDefaultAttributes();
        return Registry.ATTRIBUTE.stream().map(arg_0 -> ((Attributable)defaults).getAttribute(arg_0)).filter(Objects::nonNull).map(AttributeData::of).collect(Collectors.toSet());
    }
}

