/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import io.papermc.paper.math.Position;
import java.time.Duration;
import net.thenextlvl.perworlds.data.WorldBorderDataImpl;
import org.bukkit.WorldBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface WorldBorderData {
    public static final WorldBorderData DEFAULT = new WorldBorderDataImpl();

    @Contract(pure=true)
    public double centerX();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData centerX(double var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public double centerZ();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData centerZ(double var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public Position center();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData center(Position var1) throws IllegalArgumentException;

    @Contract(value="_, _ -> new", pure=true)
    public WorldBorderData center(double var1, double var3) throws IllegalArgumentException;

    @Contract(pure=true)
    public double size();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData size(double var1) throws IllegalArgumentException;

    @Deprecated(forRemoval=true, since="1.3.0")
    @Contract(pure=true)
    default public long duration() {
        return this.getTransitionDuration().toMillis();
    }

    @Contract(pure=true)
    public Duration getTransitionDuration();

    @Deprecated(forRemoval=true, since="1.3.0")
    @Contract(value="_ -> new", pure=true)
    default public WorldBorderData duration(long duration) throws IllegalArgumentException {
        return this.setTransitionDuration(Duration.ofMillis(duration));
    }

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData setTransitionDuration(Duration var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public double damageAmount();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData damageAmount(double var1);

    @Contract(pure=true)
    public double damageBuffer();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData damageBuffer(double var1);

    @Contract(pure=true)
    public int warningDistance();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData warningDistance(int var1);

    @Deprecated(forRemoval=true, since="1.3.0")
    @Contract(pure=true)
    default public int warningTime() {
        return (int)this.getWarningTime().toSeconds();
    }

    @Contract(pure=true)
    public Duration getWarningTime();

    @Contract(value="_ -> new", pure=true)
    default public WorldBorderData warningTime(int seconds) throws IllegalArgumentException {
        return this.setWarningTime(Duration.ofSeconds(seconds));
    }

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData setWarningTime(Duration var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public static double getMaxSize() {
        return 5.9999968E7;
    }

    @Contract(pure=true)
    public static double getMinSize() {
        return 1.0;
    }

    @Contract(pure=true)
    public static double getMaxCenterCoordinate() {
        return 5.9999968E7;
    }

    @Deprecated(forRemoval=true, since="1.3.0")
    @Contract(value="_, _, _, _, _, _, _, _ -> new", pure=true)
    public static WorldBorderData create(double centerX, double centerZ, double size, double damageAmount, double damageBuffer, long duration, int warningDistance, int warningTime) {
        return WorldBorderData.create(centerX, centerZ, size, damageAmount, damageBuffer, Duration.ofMillis(duration), warningDistance, Duration.ofSeconds(warningTime));
    }

    @Contract(value="_, _, _, _, _, _, _, _ -> new", pure=true)
    public static WorldBorderData create(double centerX, double centerZ, double size, double damageAmount, double damageBuffer, Duration transitionDuration, int warningDistance, Duration warningTime) {
        return new WorldBorderDataImpl(centerX, centerZ, size, damageAmount, damageBuffer, transitionDuration, warningDistance, warningTime);
    }

    public static WorldBorderData of(WorldBorder border) {
        return new WorldBorderDataImpl(border);
    }
}

