/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.model.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GsonFile<R> {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().serializeNulls().create();
    private final Path file;
    private final R defaultRoot;
    private R root;
    private boolean loaded;

    public GsonFile(Path file, R root) {
        this.defaultRoot = root;
        this.file = file;
        this.root = root;
    }

    public R getRoot() {
        if (this.loaded) {
            return this.root;
        }
        this.loaded = true;
        this.root = this.load();
        return this.root;
    }

    public GsonFile<R> saveIfAbsent(FileAttribute<?> ... attributes) {
        return Files.isRegularFile(this.file, new LinkOption[0]) ? this : this.save(attributes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R load() {
        if (!Files.isRegularFile(this.file, new LinkOption[0])) {
            return this.getRoot();
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(this.file, StandardOpenOption.READ), StandardCharsets.UTF_8));){
            Object root = GSON.fromJson(reader, this.root.getClass());
            Object object = root != null ? root : this.defaultRoot;
            return (R)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GsonFile<R> save(FileAttribute<?> ... attributes) {
        GsonFile gsonFile;
        R root = this.getRoot();
        Files.createDirectories(this.file.getParent(), attributes);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8));
        try {
            GSON.toJson(root, root.getClass(), (Appendable)writer);
            gsonFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return gsonFile;
    }
}

