/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.listener;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import java.util.List;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class RespawnListener
implements Listener {
    private final PaperGroupProvider provider;

    public RespawnListener(PaperGroupProvider provider) {
        this.provider = provider;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        WorldGroup group = this.provider.getGroup(event.getPlayer().getWorld()).orElse(this.provider.getUnownedWorldGroup());
        group.persistPlayerData(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        WorldGroup group = this.provider.getGroup(event.getPlayer().getWorld()).orElse(this.provider.getUnownedWorldGroup());
        group.persistPlayerData(event.getPlayer(), playerData -> {
            if (event.getRespawnReason().equals((Object)PlayerRespawnEvent.RespawnReason.END_PORTAL)) {
                return;
            }
            if (Boolean.FALSE.equals(event.getPlayer().getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY))) {
                playerData.experience(0.0f);
                playerData.level(0);
                playerData.score(0);
            }
            playerData.absorption(0.0);
            playerData.arrowsInBody(0);
            playerData.beeStingersInBody(0);
            playerData.exhaustion(0.0f);
            playerData.fallDistance(0.0f);
            playerData.fireTicks(0);
            playerData.foodLevel(20);
            playerData.potionEffects(List.of());
            playerData.remainingAir(event.getPlayer().getMaximumAir());
            playerData.saturation(20.0f);
            playerData.velocity(new Vector());
            AttributeInstance attribute = event.getPlayer().getAttribute(Attribute.MAX_HEALTH);
            playerData.health(attribute != null ? attribute.getValue() : 20.0);
        });
        if (event.isBedSpawn() || event.isAnchorSpawn()) {
            return;
        }
        group.getSpawnLocation().ifPresent(arg_0 -> ((PlayerRespawnEvent)event).setRespawnLocation(arg_0));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPostRespawn(PlayerPostRespawnEvent event) {
        Location location = event.getRespawnedLocation();
        World world = location.getWorld() != null ? location.getWorld() : event.getPlayer().getWorld();
        this.provider.getGroup(world).orElse(this.provider.getUnownedWorldGroup()).loadPlayerData(event.getPlayer(), false);
    }
}

