/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.group;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.data.PlayerData;
import net.thenextlvl.perworlds.data.WorldBorderData;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import net.thenextlvl.perworlds.model.PaperPlayerData;
import net.thenextlvl.perworlds.model.config.GroupConfig;
import org.bukkit.GameRule;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperWorldGroup
implements WorldGroup {
    protected final PaperGroupProvider provider;
    private final Path dataFolder;
    private final Path configFile;
    private final Path configFileBackup;
    private final GroupConfig config;
    private final String name;

    public PaperWorldGroup(PaperGroupProvider provider, String name, GroupData data, GroupSettings settings, Collection<World> worlds) {
        this.name = name;
        this.provider = provider;
        this.dataFolder = provider.getDataFolder().resolve(name);
        this.configFile = provider.getDataFolder().resolve(name + ".dat");
        this.configFileBackup = provider.getDataFolder().resolve(name + ".dat_old");
        this.config = this.readConfig().orElseGet(() -> new GroupConfig(worlds.stream().map(Keyed::key).collect(Collectors.toSet()), data, settings));
    }

    private Optional<GroupConfig> readConfig() {
        try {
            return this.readFile(this.configFile, this.configFileBackup, GroupConfig.class);
        }
        catch (EOFException e) {
            this.provider.getLogger().error("The world group config file {} is irrecoverably broken", (Object)this.configFile);
            return Optional.empty();
        }
        catch (Exception e) {
            this.provider.getLogger().error("Failed to load world group data from {}", (Object)this.configFile, (Object)e);
            this.provider.getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
            return Optional.empty();
        }
    }

    @Override
    public Path getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public Path getConfigFile() {
        return this.configFile;
    }

    @Override
    public Path getConfigFileBackup() {
        return this.configFileBackup;
    }

    @Override
    public GroupData getGroupData() {
        return this.config.data();
    }

    @Override
    public PaperGroupProvider getGroupProvider() {
        return this.provider;
    }

    @Override
    public GroupSettings getSettings() {
        return this.config.settings();
    }

    @Override
    public @Unmodifiable List<Player> getPlayers() {
        return this.getWorlds().flatMap(this::getPlayers).toList();
    }

    @Override
    public Optional<Location> getSpawnLocation(OfflinePlayer player) {
        return this.readPlayerData(player).flatMap(this::getSpawnLocation);
    }

    @Override
    public Optional<Location> getSpawnLocation(PlayerData data) {
        return Optional.ofNullable(data.lastLocation()).filter(location -> this.getSettings().lastLocation()).or(this::getSpawnLocation);
    }

    @Override
    public Optional<Location> getSpawnLocation() {
        return this.getGroupData().getSpawnLocation().or(() -> this.getSpawnWorld().map(World::getSpawnLocation)).map(Location::clone);
    }

    @Override
    public Optional<World> getSpawnWorld() {
        return this.getGroupData().getSpawnLocation().map(Location::getWorld).or(() -> this.getWorlds().min(this::compare));
    }

    private int compare(World world, World other) {
        int x = this.getPriority(world.getEnvironment());
        int y = this.getPriority(other.getEnvironment());
        return Integer.compare(x, y);
    }

    private int getPriority(World.Environment environment) {
        return switch (environment) {
            case World.Environment.NORMAL -> 0;
            case World.Environment.NETHER -> 1;
            case World.Environment.THE_END -> 2;
            default -> 3;
        };
    }

    @Override
    public @Unmodifiable Set<Key> getPersistedWorlds() {
        return Set.copyOf(this.config.worlds());
    }

    @Override
    public @Unmodifiable Stream<World> getWorlds() {
        return this.config.worlds().stream().map(arg_0 -> ((Server)this.provider.getServer()).getWorld(arg_0)).filter(Objects::nonNull);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addWorld(World world) {
        if (this.provider.hasGroup(world)) {
            return false;
        }
        WorldGroup previous = this.provider.getGroup(world).orElse(this.provider.getUnownedWorldGroup());
        this.getPlayers(world).forEach(previous::persistPlayerData);
        if (!this.config.worlds().add(world.key())) {
            return false;
        }
        this.getPlayers(world).forEach(this::loadPlayerData);
        if (this.config.worlds().size() == 1) {
            this.loadWorldData(world);
        } else {
            this.updateWorldData(world);
        }
        return true;
    }

    @Override
    public boolean containsWorld(World world) {
        return this.config.worlds().contains(world.key());
    }

    @Override
    public boolean delete() {
        return this.provider.removeGroup(this) | this.delete(this.configFile) | this.delete(this.configFileBackup) | this.delete(this.dataFolder);
    }

    @Override
    public boolean hasPlayerData(OfflinePlayer player) {
        return Files.exists(this.getDataFolder().resolve(String.valueOf(player.getUniqueId()) + ".dat"), new LinkOption[0]);
    }

    protected boolean delete(Path path) {
        boolean bl;
        block9: {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return Files.deleteIfExists(path);
            }
            Stream<Path> files = Files.list(path);
            try {
                files.forEach(this::delete);
                bl = Files.deleteIfExists(path);
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.getGroupProvider().getLogger().warn("Failed to delete {}", (Object)path, (Object)e);
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    @Override
    public boolean persist() {
        boolean bl;
        block13: {
            Path file = this.configFile;
            if (Files.exists(file, new LinkOption[0])) {
                Files.move(file, this.configFileBackup, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.createDirectories(file.toAbsolutePath().getParent(), new FileAttribute[0]);
            }
            NBTOutputStream outputStream = NBTOutputStream.create(file);
            try {
                outputStream.writeTag(null, this.provider.nbt().serialize(this.config));
                bl = true;
                if (outputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (Files.exists(this.configFileBackup, new LinkOption[0])) {
                        try {
                            Files.copy(this.configFileBackup, this.configFile, StandardCopyOption.REPLACE_EXISTING);
                            this.provider.getLogger().warn("Recovered {} from potential data loss", (Object)this.configFile);
                        }
                        catch (IOException e) {
                            this.provider.getLogger().error("Failed to recover world group config {}", (Object)this.configFile, (Object)e);
                        }
                    }
                    this.provider.getLogger().error("Failed to save world group config {}", (Object)this.configFile, (Object)t);
                    this.provider.getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    @Override
    public boolean removeWorld(World world) {
        if (!this.config.worlds().remove(world.key())) {
            return false;
        }
        this.getPlayers(world).forEach(this.provider.getUnownedWorldGroup()::loadPlayerData);
        this.provider.getUnownedWorldGroup().updateWorldData(world);
        return true;
    }

    private Stream<Player> getPlayers(World world) {
        return world.getPlayers().stream().filter(player -> !player.hasMetadata("NPC"));
    }

    @Override
    public boolean removeWorld(Key key) {
        World world = this.provider.getServer().getWorld(key);
        return world != null ? this.removeWorld(world) : this.config.worlds().remove(key);
    }

    @Override
    public Optional<PlayerData> readPlayerData(OfflinePlayer player) {
        Path file = this.getDataFolder().resolve(String.valueOf(player.getUniqueId()) + ".dat");
        try {
            return this.readPlayerData(player, file);
        }
        catch (EOFException e) {
            this.provider.getLogger().error("The player data file {} is irrecoverably broken", (Object)file);
            return Optional.empty();
        }
        catch (Exception e) {
            this.provider.getLogger().error("Failed to load player data from {}", (Object)file, (Object)e);
            this.provider.getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
            return Optional.empty();
        }
    }

    @Override
    public boolean editPlayerData(OfflinePlayer player, Consumer<PlayerData> data) {
        return this.readPlayerData(player).map(paperPlayerData -> {
            data.accept((PlayerData)paperPlayerData);
            return this.writePlayerData(player, (PlayerData)paperPlayerData);
        }).orElse(false);
    }

    @Override
    public boolean writePlayerData(OfflinePlayer player, PlayerData data) {
        if (player instanceof Player) {
            Player online = (Player)player;
            Preconditions.checkState((boolean)this.containsWorld(online.getWorld()), (String)"Failed to persist player data: World mismatch between group '%s' and player '%s'. Expected any of %s but got %s", (Object)this.getName(), (Object)player.getName(), this.getPersistedWorlds(), (Object)online.getWorld().key());
        }
        if (!this.hasPlayerData(player) && this.getMigratingTo() == null) {
            this.provider.getLogger().warn("Failed to persist player data for {}: No group to migrate to", (Object)player.getName());
            this.provider.getLogger().warn("Use '/world group migrate <group>' to define a group to migrate to");
            return false;
        }
        return this.writePlayerDataUnsafe(player, data);
    }

    public boolean writePlayerDataUnsafe(OfflinePlayer player, PlayerData data) {
        boolean bl;
        block13: {
            Path file = this.getDataFolder().resolve(String.valueOf(player.getUniqueId()) + ".dat");
            Path backup = this.getDataFolder().resolve(String.valueOf(player.getUniqueId()) + ".dat_old");
            if (Files.isRegularFile(file, new LinkOption[0])) {
                Files.move(file, backup, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.createDirectories(file.toAbsolutePath().getParent(), new FileAttribute[0]);
            }
            NBTOutputStream outputStream = NBTOutputStream.create(file);
            try {
                outputStream.writeTag(null, this.provider.nbt().serialize((Object)data, PaperPlayerData.class));
                bl = true;
                if (outputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (Files.isRegularFile(backup, new LinkOption[0])) {
                        try {
                            Files.copy(backup, file, StandardCopyOption.REPLACE_EXISTING);
                            this.provider.getLogger().warn("Recovered {} from potential data loss", (Object)player.getUniqueId());
                        }
                        catch (IOException e) {
                            this.provider.getLogger().error("Failed to recover player data {}", (Object)player.getUniqueId(), (Object)e);
                        }
                    }
                    this.provider.getLogger().error("Failed to save player data {}", (Object)player.getUniqueId(), (Object)t);
                    this.provider.getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    @Override
    public CompletableFuture<Boolean> loadPlayerData(Player player) {
        return this.loadPlayerData(player, false);
    }

    @Override
    public CompletableFuture<Boolean> loadPlayerData(Player player, boolean position) {
        PaperWorldGroup group;
        if (!this.getSettings().enabled()) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.provider.isLoadingData(player)) {
            return CompletableFuture.completedFuture(false);
        }
        this.provider.loadingPlayers.add(player.getUniqueId());
        Optional<PlayerData> playerData = this.readPlayerData((OfflinePlayer)player);
        PaperWorldGroup paperWorldGroup = group = playerData.isEmpty() ? this.getMigratingTo() : null;
        if (group == null && playerData.isEmpty()) {
            this.provider.loadingPlayers.remove(player.getUniqueId());
            this.provider.getLogger().warn("Failed to load player data for {}: No group to migrate to", (Object)player.getName());
            this.provider.getLogger().warn("Use '/world group migrate <group>' to define a group to migrate to");
            if (player.hasPermission("perworlds.command.group.migrate")) {
                this.provider.bundle().sendMessage((Audience)player, "group.migrate.prompt");
            }
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)playerData.orElseGet(() -> this.migratePlayerData(group, player)).load(player, position).whenComplete((success, throwable) -> this.provider.loadingPlayers.remove(player.getUniqueId()))).exceptionally(throwable -> {
            this.provider.getLogger().error("Failed to load group data for player {}", (Object)player.getName(), throwable);
            this.provider.getLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/per-worlds/issues/new?template=bug_report.yml");
            player.kick(this.provider.bundle().component("group.load.failed", (Audience)player));
            return false;
        });
    }

    private @Nullable PaperWorldGroup getMigratingTo() {
        return this.provider.getPlugin().config().getMigrateToGroup(this.provider).map(PaperWorldGroup.class::cast).orElse(null);
    }

    private PaperPlayerData migratePlayerData(PaperWorldGroup group, Player player) {
        if (!group.hasPlayerData((OfflinePlayer)player)) {
            PaperPlayerData data = PaperPlayerData.of(player, group);
            if (this.equals(group)) {
                return data;
            }
            group.writePlayerDataUnsafe((OfflinePlayer)player, data);
        }
        return new PaperPlayerData(player.getUniqueId(), this);
    }

    @Override
    public void updateWorldData(World world) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.containsWorld(world), (String)"World '%s' is not part of group '%s'", (Object)world.getName(), (Object)this.getName());
        if (!this.getSettings().enabled()) {
            return;
        }
        for (GroupData.Type type : GroupData.Type.values()) {
            this.updateWorldData(world, type);
        }
    }

    @Override
    public void updateWorldData(World world, GroupData.Type type) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.containsWorld(world), (String)"World '%s' is not part of group '%s'", (Object)world.getName(), (Object)this.getName());
        if (this.isEnabled(type)) {
            switch (type) {
                case DIFFICULTY: {
                    world.setDifficulty(this.getGroupData().getDifficulty());
                    break;
                }
                case TIME: {
                    world.setFullTime(this.getGroupData().getTime());
                    break;
                }
                case GAME_RULE: {
                    this.applyGameRules(world);
                    break;
                }
                case WORLD_BORDER: {
                    this.applyWorldBorder(world);
                    break;
                }
                case HARDCORE: {
                    boolean hardcore = this.getGroupData().getHardcore().toBooleanOrElse(this.provider.getServer().isHardcore());
                    world.setHardcore(hardcore);
                    break;
                }
                case WEATHER: {
                    this.applyWeather(world);
                }
            }
        }
    }

    @Override
    public void loadWorldData(World world) {
        this.getGroupData().setDifficulty(world.getDifficulty());
        this.getGroupData().setTime(world.getFullTime());
        Arrays.stream(GameRule.values()).filter(gameRule -> world.getFeatureFlags().containsAll(gameRule.requiredFeatures())).map(gameRule -> gameRule).forEach(rule -> this.getGroupData().setGameRule(rule, world.getGameRuleValue(rule)));
        this.getGroupData().setWorldBorder(WorldBorderData.of(world.getWorldBorder()));
        this.getGroupData().setHardcore(TriState.byBoolean((boolean)world.isHardcore()));
        this.getGroupData().setRaining(world.hasStorm());
        this.getGroupData().setThundering(world.isThundering());
        this.getGroupData().clearWeatherDuration(world.getClearWeatherDuration());
        this.getGroupData().setThunderDuration(world.getThunderDuration());
        this.getGroupData().setRainDuration(world.getWeatherDuration());
        this.getWorlds().filter(other -> other != world).forEach(this::updateWorldData);
    }

    private boolean isEnabled(GroupData.Type type) {
        boolean bl;
        block15: {
            block14: {
                if (!this.getSettings().enabled()) break block14;
                switch (type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DEFAULT_GAME_MODE: {
                        if (this.getSettings().gameMode()) {
                            break;
                        }
                        break block14;
                    }
                    case DIFFICULTY: 
                    case HARDCORE: {
                        if (this.getSettings().difficulty()) {
                            break;
                        }
                        break block14;
                    }
                    case GAME_RULE: {
                        if (this.getSettings().gameRules()) {
                            break;
                        }
                        break block14;
                    }
                    case SPAWN_LOCATION: {
                        break;
                    }
                    case TIME: {
                        if (this.getSettings().time()) {
                            break;
                        }
                        break block14;
                    }
                    case WEATHER: {
                        if (this.getSettings().weather()) {
                            break;
                        }
                        break block14;
                    }
                    case WORLD_BORDER: {
                        if (!this.getSettings().worldBorder()) break block14;
                    }
                }
                bl = true;
                break block15;
            }
            bl = false;
        }
        return bl;
    }

    private void applyWeather(World world) {
        world.setStorm(this.getGroupData().isRaining());
        world.setThundering(this.getGroupData().isThundering());
        world.setClearWeatherDuration(this.getGroupData().clearWeatherDuration());
        world.setThunderDuration(this.getGroupData().getThunderDuration());
        world.setWeatherDuration(this.getGroupData().getRainDuration());
    }

    private void applyGameRules(World world) {
        Arrays.stream(world.getGameRules()).map(GameRule::getByName).map(gameRule -> gameRule).filter(Objects::nonNull).forEach(rule -> this.getGroupData().getGameRule(rule).or(() -> Optional.ofNullable(world.getGameRuleDefault(rule))).ifPresent(value -> world.setGameRule(rule, value)));
    }

    private void applyWorldBorder(World world) {
        WorldBorderData border = this.getGroupData().getWorldBorder();
        WorldBorder worldBorder = world.getWorldBorder();
        worldBorder.setSize(border.size(), TimeUnit.MILLISECONDS, border.duration());
        worldBorder.setCenter(border.centerX(), border.centerZ());
        worldBorder.setDamageAmount(border.damageAmount());
        worldBorder.setDamageBuffer(border.damageBuffer());
        worldBorder.setWarningDistance(border.warningDistance());
        worldBorder.setWarningTime(border.warningTime());
    }

    @Override
    public void persistPlayerData() {
        this.getPlayers().forEach(this::persistPlayerData);
    }

    @Override
    public void persistPlayerData(Player player) {
        this.writePlayerData((OfflinePlayer)player, PaperPlayerData.of(player, this));
    }

    @Override
    public void persistPlayerData(Player player, Consumer<PlayerData> data) {
        PaperPlayerData playerData = PaperPlayerData.of(player, this);
        data.accept(playerData);
        this.writePlayerData((OfflinePlayer)player, playerData);
    }

    private Optional<PlayerData> readPlayerData(OfflinePlayer player, Path file) throws IOException {
        return this.readFile(file, file.resolveSibling(String.valueOf(file.getFileName()) + "_old"), PaperPlayerData.class).map(paperPlayerData -> paperPlayerData.finalize(player, this));
    }

    private <T> Optional<T> readFile(Path file, Path backup, Class<T> type) throws IOException {
        Optional<Object> optional;
        block16: {
            if (!Files.exists(file, new LinkOption[0])) {
                return Optional.empty();
            }
            NBTInputStream inputStream = NBTInputStream.create(file);
            try {
                optional = Optional.of(inputStream.readTag()).map(tag -> this.provider.nbt().deserialize((Tag)tag, type));
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (!Files.exists(backup, new LinkOption[0])) {
                        throw e;
                    }
                    this.provider.getLogger().warn("Failed to load data from {}", (Object)file, (Object)e);
                    this.provider.getLogger().warn("Falling back to {}", (Object)backup);
                    try (NBTInputStream inputStream2 = NBTInputStream.create(backup);){
                        Optional<Object> optional2 = Optional.of(inputStream2.readTag()).map(tag -> this.provider.nbt().deserialize((Tag)tag, type));
                        return optional2;
                    }
                }
            }
            inputStream.close();
        }
        return optional;
    }
}

