/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.thenextlvl.perworlds.data.AdvancementData;
import org.bukkit.advancement.Advancement;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class AdvancementDataImpl
implements AdvancementData {
    private final Advancement advancement;
    private final Set<String> remainingCriteria = new HashSet<String>();
    private final Map<String, Instant> awardedCriteria = new HashMap<String, Instant>();

    AdvancementDataImpl(Advancement advancement, Map<String, Instant> awardedCriteria, Collection<String> remainingCriteria) {
        this.advancement = advancement;
        this.awardedCriteria.putAll(awardedCriteria);
        this.remainingCriteria.addAll(remainingCriteria);
    }

    @Override
    public Advancement getAdvancement() {
        return this.advancement;
    }

    @Override
    public boolean isDone() {
        return this.remainingCriteria.isEmpty();
    }

    @Override
    public boolean hasProgress() {
        return !this.awardedCriteria.isEmpty();
    }

    @Override
    public boolean awardCriteria(String criteria) {
        return this.remainingCriteria.remove(criteria) && this.awardedCriteria.putIfAbsent(criteria, Instant.now()) == null;
    }

    @Override
    public boolean revokeCriteria(String criteria) {
        return this.remainingCriteria.add(criteria) && this.awardedCriteria.remove(criteria) != null;
    }

    @Override
    public @Nullable Instant getTimeAwarded(String criteria) {
        return this.awardedCriteria.get(criteria);
    }

    @Override
    public boolean setTimeAwarded(String criteria, Instant instant) {
        return this.awardedCriteria.containsKey(criteria) && this.awardedCriteria.put(criteria, instant) != null;
    }

    @Override
    public @Unmodifiable Set<String> getRemainingCriteria() {
        return Set.copyOf(this.remainingCriteria);
    }

    @Override
    public @Unmodifiable Set<String> getAwardedCriteria() {
        return Set.copyOf(this.awardedCriteria.keySet());
    }

    @Override
    public void forEachAwardedCriteria(BiConsumer<String, Instant> action) {
        this.awardedCriteria.forEach(action);
    }
}

