/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.adapter;

import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PotionEffectAdapter
implements TagAdapter<PotionEffect> {
    @Override
    public PotionEffect deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        PotionEffectType type = context.deserialize((Tag)root.get("type"), PotionEffectType.class);
        int duration = root.get("duration").getAsInt();
        int amplifier = root.get("amplifier").getAsInt();
        boolean ambient = root.get("ambient").getAsBoolean();
        boolean particles = root.get("particles").getAsBoolean();
        boolean icon = root.get("icon").getAsBoolean();
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }

    @Override
    public Tag serialize(PotionEffect effect, TagSerializationContext context) throws ParserException {
        return CompoundTag.builder().put("type", context.serialize(effect.getType())).put("duration", (Number)effect.getDuration()).put("amplifier", (Number)effect.getAmplifier()).put("ambient", effect.isAmbient()).put("particles", effect.hasParticles()).put("icon", effect.hasIcon()).build();
    }
}

