/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.adapter;

import java.time.Instant;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.StringTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.perworlds.data.AdvancementData;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.advancement.Advancement;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AdvancementDataAdapter
implements TagAdapter<AdvancementData> {
    private final Server server;

    public AdvancementDataAdapter(Server server) {
        this.server = server;
    }

    @Override
    public AdvancementData deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        NamespacedKey key = context.deserialize((Tag)root.get("advancement"), NamespacedKey.class);
        Advancement advancement = this.server.getAdvancement(key);
        if (advancement == null) {
            throw new ParserException("Encountered unknown advancement: " + String.valueOf(key));
        }
        HashMap<String, Instant> awarded = new HashMap<String, Instant>();
        root.getAsCompound("awarded").forEach((criteria, instant) -> awarded.put((String)criteria, context.deserialize((Tag)instant, Instant.class)));
        Set<String> remaining = root.getAsList("remaining").stream().map(Tag::getAsString).collect(Collectors.toSet());
        return AdvancementData.of(advancement, awarded, remaining);
    }

    @Override
    public Tag serialize(AdvancementData data, TagSerializationContext context) throws ParserException {
        CompoundTag.Builder tag = CompoundTag.builder();
        CompoundTag.Builder awarded = CompoundTag.builder();
        data.forEachAwardedCriteria((criteria, date) -> awarded.put((String)criteria, context.serialize(date)));
        tag.put("advancement", context.serialize(data.getAdvancement().key()));
        tag.put("awarded", awarded.build());
        tag.put("remaining", ListTag.of((byte)8, data.getRemainingCriteria().stream().map(StringTag::of).toList()));
        return tag.build();
    }
}

