/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.group;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.perworlds.group.PaperGroupData;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import net.thenextlvl.perworlds.group.PaperGroupSettings;
import net.thenextlvl.perworlds.group.PaperWorldGroup;
import org.bukkit.Keyed;
import org.bukkit.World;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperUnownedWorldGroup
extends PaperWorldGroup {
    public PaperUnownedWorldGroup(PaperGroupProvider provider) {
        super(provider, "unowned", new PaperGroupData(), new PaperGroupSettings(), Set.of());
    }

    @Override
    public boolean delete() {
        boolean deleted = this.delete(this.getConfigFile()) | this.delete(this.getConfigFileBackup()) | this.delete(this.getDataFolder());
        if (deleted) {
            this.getPlayers().forEach(this::loadPlayerData);
        }
        return deleted;
    }

    @Override
    public Stream<World> getWorlds() {
        return this.provider.getServer().getWorlds().stream().filter(this::containsWorld);
    }

    @Override
    public @Unmodifiable Set<Key> getPersistedWorlds() {
        return this.getWorlds().map(Keyed::key).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean addWorld(World world) {
        return false;
    }

    @Override
    public boolean removeWorld(World world) {
        return false;
    }

    @Override
    public boolean containsWorld(World world) {
        return !this.provider.hasGroup(world);
    }
}

