/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Position;
import net.thenextlvl.perworlds.data.WorldBorderData;
import org.bukkit.WorldBorder;
import org.jspecify.annotations.NullMarked;

@NullMarked
record WorldBorderDataImpl(double centerX, double centerZ, double size, double damageAmount, double damageBuffer, long duration, int warningDistance, int warningTime) implements WorldBorderData
{
    static final double MAX_SIZE = 5.9999968E7;
    static final double MIN_SIZE = 1.0;
    static final double MAX_CENTER_COORDINATE = 5.9999968E7;

    WorldBorderDataImpl() {
        this(0.0, 0.0, 5.9999968E7, 0.2, 5.0, 0L, 5, 15);
    }

    WorldBorderDataImpl(WorldBorder border) {
        this(border.getCenter().getX(), border.getCenter().getZ(), border.getSize(), border.getDamageAmount(), border.getDamageBuffer(), 0L, border.getWarningDistance(), border.getWarningTime());
    }

    @Override
    public WorldBorderData centerX(double x) throws IllegalArgumentException {
        return this.center(x, this.centerZ);
    }

    @Override
    public WorldBorderData centerZ(double z) throws IllegalArgumentException {
        return this.center(this.centerX, z);
    }

    @Override
    public Position center() {
        return Position.fine((double)this.centerX, (double)0.0, (double)this.centerZ);
    }

    @Override
    public WorldBorderData center(Position position) throws IllegalArgumentException {
        return this.center(position.x(), position.z());
    }

    @Override
    public WorldBorderData center(double x, double z) throws IllegalArgumentException {
        Preconditions.checkArgument((Math.abs(x) <= 5.9999968E7 ? 1 : 0) != 0, (String)"x coordinate cannot be outside +- %s but got %s", (Object)5.9999968E7, (Object)x);
        Preconditions.checkArgument((Math.abs(z) <= 5.9999968E7 ? 1 : 0) != 0, (String)"z coordinate cannot be outside +- %s but got %s", (Object)5.9999968E7, (Object)z);
        return new WorldBorderDataImpl(x, z, this.size, this.damageAmount, this.damageBuffer, this.duration, this.warningDistance, this.warningTime);
    }

    @Override
    public WorldBorderData size(double size) throws IllegalArgumentException {
        Preconditions.checkArgument((size >= 1.0 && size <= 5.9999968E7 ? 1 : 0) != 0, (String)"size must be between %s and %s but got %s", (Object)1.0, (Object)5.9999968E7, (Object)size);
        return new WorldBorderDataImpl(this.centerX, this.centerZ, size, this.damageAmount, this.damageBuffer, this.duration, this.warningDistance, this.warningTime);
    }

    @Override
    public WorldBorderData duration(long duration) throws IllegalArgumentException {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (String)"time cannot be lower than 0 but got %s", (long)duration);
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, this.damageBuffer, duration, this.warningDistance, this.warningTime);
    }

    @Override
    public WorldBorderData damageAmount(double damage) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, damage, this.damageBuffer, this.duration, this.warningDistance, this.warningTime);
    }

    @Override
    public WorldBorderData damageBuffer(double blocks) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, blocks, this.duration, this.warningDistance, this.warningTime);
    }

    @Override
    public WorldBorderData warningDistance(int blocks) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, this.damageBuffer, this.duration, blocks, this.warningTime);
    }

    @Override
    public WorldBorderData warningTime(int seconds) {
        return new WorldBorderDataImpl(this.centerX, this.centerZ, this.size, this.damageAmount, this.damageBuffer, this.duration, this.warningDistance, seconds);
    }
}

