/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.adapter;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.ByteTag;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.data.AdvancementData;
import net.thenextlvl.perworlds.data.AttributeData;
import net.thenextlvl.perworlds.data.PlayerData;
import net.thenextlvl.perworlds.data.WardenSpawnTracker;
import net.thenextlvl.perworlds.model.PaperPlayerData;
import net.thenextlvl.perworlds.statistics.Statistics;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PlayerDataAdapter
implements TagAdapter<PlayerData> {
    private final PerWorldsPlugin plugin;

    public PlayerDataAdapter(PerWorldsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public PlayerData deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        PaperPlayerData data = new PaperPlayerData(null, null);
        CompoundTag root = tag.getAsCompound();
        root.optional("advancements").map(Tag::getAsList).map(list -> list.stream().map(advancement -> {
            try {
                return context.deserialize((Tag)advancement, AdvancementData.class);
            }
            catch (ParserException e) {
                this.plugin.getComponentLogger().warn(e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).toList()).ifPresent(data::advancements);
        root.optional("attributes").map(Tag::getAsList).map(list -> list.stream().map(attribute -> context.deserialize((Tag)attribute, AttributeData.class)).toList()).ifPresent(data::attributes);
        root.optional("enderChest").map(items -> context.deserialize((Tag)items, ItemStack[].class)).ifPresent(data::enderChest);
        root.optional("inventory").map(items -> context.deserialize((Tag)items, ItemStack[].class)).ifPresent(data::inventory);
        root.optional("respawnLocation").map(location -> {
            try {
                return context.deserialize((Tag)location, Location.class);
            }
            catch (ParserException e) {
                return null;
            }
        }).ifPresent(data::respawnLocation);
        root.optional("recipes").map(Tag::getAsList).map(list -> list.stream().map(recipe -> context.deserialize((Tag)recipe, NamespacedKey.class)).toList()).ifPresent(data::discoveredRecipes);
        root.optional("potionEffects").map(Tag::getAsList).map(list -> list.stream().map(effect -> context.deserialize((Tag)effect, PotionEffect.class)).toList()).ifPresent(data::potionEffects);
        root.optional("lastAdvancementTab").map(advancement -> context.deserialize((Tag)advancement, Key.class)).ifPresent(data::lastAdvancementTab);
        root.optional("statistics").map(stats -> context.deserialize((Tag)stats, Statistics.class)).ifPresent(data::stats);
        root.optional("gameMode").map(mode -> context.deserialize((Tag)mode, GameMode.class)).ifPresent(data::gameMode);
        root.optional("seenCredits").map(Tag::getAsBoolean).ifPresent(data::seenCredits);
        root.optional("absorption").map(Tag::getAsDouble).ifPresent(data::absorption);
        root.optional("health").map(Tag::getAsDouble).ifPresent(data::health);
        root.optional("exhaustion").map(Tag::getAsFloat).ifPresent(data::exhaustion);
        root.optional("experience").map(Tag::getAsFloat).ifPresent(data::experience);
        root.optional("fallDistance").map(Tag::getAsFloat).ifPresent(data::fallDistance);
        root.optional("saturation").map(Tag::getAsFloat).ifPresent(data::saturation);
        root.optional("arrowsInBody").map(Tag::getAsInt).ifPresent(data::arrowsInBody);
        root.optional("beeStingersInBody").map(Tag::getAsInt).ifPresent(data::beeStingersInBody);
        root.optional("fireTicks").map(Tag::getAsInt).ifPresent(data::fireTicks);
        root.optional("foodLevel").map(Tag::getAsInt).ifPresent(data::foodLevel);
        root.optional("mayFly").map(tag1 -> context.deserialize((Tag)tag1, TriState.class)).ifPresent(data::mayFly);
        root.optional("flying").map(tag1 -> context.deserialize((Tag)tag1, TriState.class)).ifPresent(data::flying);
        root.optional("freezeTicks").map(Tag::getAsInt).ifPresent(data::freezeTicks);
        root.optional("lockFreezeTicks").map(Tag::getAsBoolean).ifPresent(data::lockFreezeTicks);
        root.optional("visualFire").map(tag1 -> {
            ByteTag byteTag;
            return tag1 instanceof ByteTag ? ((byteTag = (ByteTag)tag1).getAsBoolean() ? TriState.TRUE : TriState.NOT_SET) : context.deserialize((Tag)tag1, TriState.class);
        }).ifPresent(data::visualFire);
        root.optional("heldItemSlot").map(Tag::getAsInt).ifPresent(data::heldItemSlot);
        root.optional("level").map(Tag::getAsInt).ifPresent(data::level);
        root.optional("remainingAir").map(Tag::getAsInt).ifPresent(data::remainingAir);
        root.optional("score").map(Tag::getAsInt).ifPresent(data::score);
        root.optional("previousGameMode").map(mode -> context.deserialize((Tag)mode, GameMode.class)).ifPresent(data::previousGameMode);
        root.optional("lastDeathLocation").map(location -> {
            try {
                return context.deserialize((Tag)location, Location.class);
            }
            catch (ParserException e) {
                return null;
            }
        }).ifPresent(data::lastDeathLocation);
        root.optional("lastLocation").map(location -> {
            try {
                return context.deserialize((Tag)location, Location.class);
            }
            catch (ParserException e) {
                return null;
            }
        }).ifPresent(data::lastLocation);
        root.optional("gliding").map(Tag::getAsBoolean).ifPresent(data::gliding);
        root.optional("invulnerable").map(Tag::getAsBoolean).ifPresent(data::invulnerable);
        root.optional("portalCooldown").map(Tag::getAsInt).ifPresent(data::portalCooldown);
        root.optional("velocity").map(velocity -> context.deserialize((Tag)velocity, Vector.class)).ifPresent(data::velocity);
        root.optional("wardenSpawnTracker").map(tracker -> context.deserialize((Tag)tracker, WardenSpawnTracker.class)).ifPresent(data::wardenSpawnTracker);
        return data;
    }

    public CompoundTag serialize(PlayerData data, TagSerializationContext context) throws ParserException {
        GameMode gameMode;
        Location lastLocation;
        Location lastDeathLocation;
        GameMode previousGameMode;
        Location respawnLocation;
        CompoundTag tag = CompoundTag.empty();
        tag.add("advancements", ListTag.of(10, data.advancements().stream().map(context::serialize).toList()));
        tag.add("attributes", ListTag.of(10, data.attributes().stream().map(context::serialize).toList()));
        tag.add("enderChest", context.serialize(data.enderChest()));
        tag.add("inventory", context.serialize(data.inventory()));
        Key lastAdvancementTab = data.lastAdvancementTab();
        if (lastAdvancementTab != null) {
            tag.add("lastAdvancementTab", context.serialize(lastAdvancementTab));
        }
        if ((respawnLocation = data.respawnLocation()) != null) {
            tag.add("respawnLocation", context.serialize(respawnLocation));
        }
        if ((previousGameMode = data.previousGameMode()) != null) {
            tag.add("previousGameMode", context.serialize(previousGameMode));
        }
        if ((lastDeathLocation = data.lastDeathLocation()) != null) {
            tag.add("lastDeathLocation", context.serialize(lastDeathLocation));
        }
        if ((lastLocation = data.lastLocation()) != null) {
            tag.add("lastLocation", context.serialize(lastLocation));
        }
        if ((gameMode = data.gameMode()) != null) {
            tag.add("gameMode", context.serialize(gameMode));
        }
        tag.add("recipes", ListTag.of(8, data.discoveredRecipes().stream().map(context::serialize).toList()));
        tag.add("potionEffects", ListTag.of(10, data.potionEffects().stream().map(context::serialize).toList()));
        tag.add("statistics", context.serialize(data.stats()));
        tag.add("seenCredits", data.seenCredits());
        tag.add("absorption", data.absorption());
        tag.add("mayFly", context.serialize(data.mayFly()));
        tag.add("flying", context.serialize(data.flying()));
        tag.add("health", data.health());
        tag.add("exhaustion", Float.valueOf(data.exhaustion()));
        tag.add("lockFreezeTicks", data.lockFreezeTicks());
        tag.add("visualFire", context.serialize(data.visualFire()));
        tag.add("experience", Float.valueOf(data.experience()));
        tag.add("gliding", data.gliding());
        tag.add("invulnerable", data.invulnerable());
        tag.add("portalCooldown", data.portalCooldown());
        tag.add("velocity", context.serialize(data.velocity()));
        tag.add("wardenSpawnTracker", context.serialize(data.wardenSpawnTracker()));
        tag.add("fallDistance", Float.valueOf(data.fallDistance()));
        tag.add("saturation", Float.valueOf(data.saturation()));
        tag.add("flySpeed", Float.valueOf(data.flySpeed()));
        tag.add("walkSpeed", Float.valueOf(data.walkSpeed()));
        tag.add("arrowsInBody", data.arrowsInBody());
        tag.add("beeStingersInBody", data.beeStingersInBody());
        tag.add("fireTicks", data.fireTicks());
        tag.add("foodLevel", data.foodLevel());
        tag.add("freezeTicks", data.freezeTicks());
        tag.add("heldItemSlot", data.heldItemSlot());
        tag.add("level", data.level());
        tag.add("remainingAir", data.remainingAir());
        tag.add("score", data.score());
        return tag;
    }
}

