/*
 * Decompiled with CFR 0.152.
 */
package core.paper.adapters.player;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import core.paper.adapters.api.PaperAdapter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PlayerProfileAdapter
implements PaperAdapter<PlayerProfile> {
    @Deprecated(forRemoval=true, since="2.0.1")
    public static PlayerProfileAdapter instance() {
        return new PlayerProfileAdapter();
    }

    @Override
    public @Nullable PlayerProfile deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject object = element.getAsJsonObject();
        String name = object.has("name") ? object.get("name").getAsString() : null;
        UUID uuid = object.has("uuid") ? (UUID)context.deserialize(object.get("uuid"), UUID.class) : null;
        List<ProfileProperty> properties = object.getAsJsonArray("properties").asList().stream().map(property -> (ProfileProperty)context.deserialize(property, ProfileProperty.class)).toList();
        PlayerProfile profile = Bukkit.createProfile((UUID)uuid, (String)name);
        profile.setProperties(properties);
        return profile;
    }

    @Override
    public JsonElement serialize(@Nullable PlayerProfile profile, Type type, JsonSerializationContext context) {
        if (profile == null) {
            return JsonNull.INSTANCE;
        }
        if (profile.getName() == null && profile.getId() == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (profile.getName() != null) {
            object.addProperty("name", profile.getName());
        }
        if (profile.getId() != null) {
            object.add("uuid", context.serialize((Object)profile.getId()));
        }
        object.add("properties", context.serialize((Object)profile.getProperties()));
        return object;
    }
}

