/*
 * Decompiled with CFR 0.152.
 */
package core.paper.adapters.player;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import core.paper.adapters.api.PaperAdapter;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class OfflinePlayerAdapter {
    @Deprecated(forRemoval=true, since="2.0.1")
    public static Cache cache() {
        return new Cache();
    }

    @Deprecated(forRemoval=true, since="2.0.1")
    public static Data data() {
        return new Data();
    }

    @Deprecated(forRemoval=true, since="2.0.1")
    public static UUID uuid() {
        return new UUID();
    }

    public static final class Cache
    implements PaperAdapter<OfflinePlayer> {
        @Override
        public @Nullable OfflinePlayer deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return element.isJsonPrimitive() ? Bukkit.getOfflinePlayerIfCached((String)element.getAsString()) : null;
        }

        @Override
        public JsonElement serialize(@Nullable OfflinePlayer source, Type type, JsonSerializationContext context) {
            return source != null && source.getName() != null ? new JsonPrimitive(source.getName()) : JsonNull.INSTANCE;
        }
    }

    public static final class Data
    implements PaperAdapter<OfflinePlayer> {
        @Override
        public @Nullable OfflinePlayer deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!element.isJsonPrimitive()) {
                return null;
            }
            java.util.UUID uuid = java.util.UUID.fromString(element.getAsString());
            return Arrays.stream(Bukkit.getOfflinePlayers()).filter(player -> player.getUniqueId().equals(uuid)).findAny().orElse(null);
        }

        @Override
        public JsonElement serialize(@Nullable OfflinePlayer source, Type type, JsonSerializationContext context) {
            return source != null ? new JsonPrimitive(source.getUniqueId().toString()) : JsonNull.INSTANCE;
        }
    }

    public static final class UUID
    implements PaperAdapter<OfflinePlayer> {
        @Override
        public @Nullable OfflinePlayer deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!element.isJsonPrimitive()) {
                return null;
            }
            return Bukkit.getOfflinePlayer((java.util.UUID)java.util.UUID.fromString(element.getAsString()));
        }

        @Override
        public JsonElement serialize(@Nullable OfflinePlayer source, Type type, JsonSerializationContext context) {
            return source != null ? new JsonPrimitive(source.getUniqueId().toString()) : JsonNull.INSTANCE;
        }
    }
}

