/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.i18n;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.thenextlvl.i18n.ComponentBundle;

class PropertiesFile {
    private final Charset charset;
    private final Path path;
    private final Properties defaultRoot;
    private Properties root;
    private boolean loaded;

    public PropertiesFile(Path path, Charset charset, Properties root) {
        this.charset = charset;
        this.defaultRoot = root;
        this.path = path;
        this.root = root;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Properties load() {
        if (!Files.isRegularFile(this.getFile(), new LinkOption[0])) {
            return (Properties)this.getRoot().clone();
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.getFile(), StandardOpenOption.READ), this.charset);){
            Properties properties;
            try (BufferedReader buffer = new BufferedReader(reader);){
                Properties properties2 = new Properties();
                properties2.load(buffer);
                properties = properties2;
            }
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PropertiesFile save(FileAttribute<?> ... attributes) {
        PropertiesFile propertiesFile;
        Properties root = this.getRoot();
        Files.createDirectories(this.getFile().toAbsolutePath().getParent(), attributes);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.getFile(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.charset));
        try {
            root.store(writer, null);
            propertiesFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return propertiesFile;
    }

    public PropertiesFile validate(ComponentBundle.Scope scope) {
        Properties root = this.getRoot();
        if (root == this.defaultRoot) {
            return this;
        }
        if (scope.isFiltering()) {
            root.entrySet().removeIf(entry -> !this.defaultRoot.containsKey(entry.getKey()));
        }
        if (scope.isFilling()) {
            this.merge(this.defaultRoot);
        }
        return this;
    }

    public PropertiesFile setRoot(Properties root) {
        this.loaded = true;
        this.root = root;
        return this;
    }

    public Properties getRoot() {
        if (this.loaded) {
            return this.root;
        }
        this.loaded = true;
        this.root = this.load();
        return this.root;
    }

    public Path getFile() {
        return this.path;
    }

    public PropertiesFile merge(Properties properties) {
        Properties root = this.getRoot();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (root.containsKey(key)) {
                return;
            }
            root.put(key, value);
        }));
        return this;
    }
}

