/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Optional;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.locale.ImageTagResolver;
import net.thenextlvl.hologram.locale.MiniPlaceholdersFormatter;
import net.thenextlvl.hologram.locale.PlaceholderAPIFormatter;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperTextHologramLine
extends PaperDisplayHologramLine<TextDisplay>
implements TextHologramLine {
    private volatile @Nullable Color backgroundColor;
    private volatile @Nullable String unparsedText = null;
    private volatile TextDisplay.TextAlignment alignment = TextDisplay.TextAlignment.CENTER;
    private volatile boolean defaultBackground = false;
    private volatile boolean seeThrough = false;
    private volatile boolean shadowed = false;
    private volatile int opacity = 0;
    private volatile int lineWidth = Integer.MAX_VALUE;

    public PaperTextHologramLine(PaperHologram hologram, @Nullable PagedHologramLine parentLine) {
        super(hologram, parentLine, EntityType.TEXT_DISPLAY);
    }

    @Override
    public LineType getType() {
        return LineType.TEXT;
    }

    @Override
    public Optional<Component> getText(Player player) {
        return this.getUnparsedText().map(string -> PaperTextHologramLine.parse(this.getHologram().getPlugin(), this.getHologram(), this, string, player));
    }

    public static Component parse(HologramPlugin plugin, PaperHologram hologram, HologramLine line, String text, Player player) {
        Optional<PagedHologramLine> optional;
        String translated = plugin.translations().translate(player, text, 0);
        PlaceholderAPIFormatter papiFormatter = plugin.papiFormatter;
        String formatted = papiFormatter != null ? papiFormatter.format(player, translated) : translated;
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolver(StandardTags.defaults());
        builder.resolver((TagResolver)ImageTagResolver.INSTANCE);
        MiniPlaceholdersFormatter miniFormatter = plugin.miniFormatter;
        if (miniFormatter != null) {
            builder.resolver(miniFormatter.tagResolver());
        }
        int online = hologram.getPlugin().getServer().getOnlinePlayers().size();
        builder.tag("hologram", (Tag)Tag.preProcessParsed((String)hologram.getName()));
        builder.tag("lines", Tag.inserting((Component)Component.text((int)hologram.getLineCount())));
        builder.tag("player", (Tag)Tag.preProcessParsed((String)player.getName()));
        builder.tag("players", Tag.inserting((Component)Component.text((int)online)));
        if (line instanceof StaticHologramLine) {
            StaticHologramLine staticLine = (StaticHologramLine)line;
            optional = staticLine.getParentLine();
        } else {
            optional = Optional.empty();
        }
        Optional<PagedHologramLine> parentLine = optional;
        parentLine.ifPresentOrElse(parent -> {
            builder.tag("line", Tag.inserting((Component)Component.text((int)(hologram.getLineIndex((HologramLine)parent) + 1))));
            long pageCount = parent.getPages().filter(page -> page.canSee(player)).count();
            long visiblePageIndex = parent.getPages().limit(parent.getPageIndex(line)).filter(page -> page.canSee(player)).count();
            builder.tag("page", Tag.inserting((Component)Component.text((long)(visiblePageIndex + 1L))));
            builder.tag("pages", Tag.inserting((Component)Component.text((long)pageCount)));
        }, () -> builder.tag("line", Tag.inserting((Component)Component.text((int)(hologram.getLineIndex(line) + 1)))));
        return MiniMessage.miniMessage().deserialize(formatted, (Pointered)player, builder.build());
    }

    @Override
    public Optional<String> getUnparsedText() {
        return Optional.ofNullable(this.unparsedText);
    }

    @Override
    public boolean setText(@Nullable Component text) {
        return this.setUnparsedText(text != null ? (String)MiniMessage.miniMessage().serialize(text) : null);
    }

    @Override
    public boolean setUnparsedText(@Nullable String text) {
        return this.set(this.unparsedText, text, () -> {
            this.unparsedText = text;
        }, true);
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public boolean setLineWidth(int width) {
        return this.set(this.lineWidth, width, () -> {
            this.lineWidth = width;
            this.forEachEntity(entity -> entity.setLineWidth(width));
        }, false);
    }

    @Override
    public Optional<Color> getBackgroundColor() {
        return Optional.ofNullable(this.backgroundColor);
    }

    @Override
    public boolean setBackgroundColor(@Nullable Color color) {
        return this.set(this.backgroundColor, color, () -> {
            this.backgroundColor = color;
            this.forEachEntity(entity -> entity.setBackgroundColor(color));
        }, false);
    }

    @Override
    public int getTextOpacity() {
        return this.opacity;
    }

    @Override
    public boolean setTextOpacity(@Range(from=0L, to=100L) int opacity) {
        return this.set(this.opacity, opacity, () -> {
            this.opacity = opacity;
            this.forEachEntity(this::updateOpacity);
        }, false);
    }

    @Override
    public boolean isShadowed() {
        return this.shadowed;
    }

    @Override
    public boolean setShadowed(boolean shadow) {
        return this.set(this.shadowed, shadow, () -> {
            this.shadowed = shadow;
            this.forEachEntity(entity -> entity.setShadowed(shadow));
        }, false);
    }

    @Override
    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    @Override
    public boolean setSeeThrough(boolean seeThrough) {
        return this.set(this.seeThrough, seeThrough, () -> {
            this.seeThrough = seeThrough;
            this.forEachEntity(entity -> entity.setSeeThrough(seeThrough));
        }, false);
    }

    @Override
    public boolean isDefaultBackground() {
        return this.defaultBackground;
    }

    @Override
    public boolean setDefaultBackground(boolean defaultBackground) {
        return this.set(this.defaultBackground, defaultBackground, () -> {
            this.defaultBackground = defaultBackground;
            this.forEachEntity(entity -> entity.setDefaultBackground(defaultBackground));
        }, false);
    }

    @Override
    public TextDisplay.TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public boolean setAlignment(TextDisplay.TextAlignment alignment) {
        return this.set(this.alignment, alignment, () -> {
            this.alignment = alignment;
            this.forEachEntity(entity -> entity.setAlignment(alignment));
        }, false);
    }

    @Override
    public double getHeight(Player player) {
        return 0.25 * (double)this.transformation.getScale().y() * (double)this.getText(player).map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).serialize(arg_0)).map(s -> s.replaceAll("<br>|<newline>", "\n")).map(s -> s.chars().filter(c -> c == 10).count() + 1L).orElse(1L).longValue();
    }

    @Override
    protected void preSpawn(TextDisplay entity, Player player) {
        this.updateText(player, entity);
        entity.setAlignment(this.alignment);
        entity.setSeeThrough(this.seeThrough);
        entity.setShadowed(this.shadowed);
        entity.setDefaultBackground(this.defaultBackground);
        entity.setBackgroundColor(this.backgroundColor);
        entity.setLineWidth(this.lineWidth);
        this.updateOpacity(entity);
        super.preSpawn(entity, player);
    }

    public void updateText(Player player, TextDisplay entity) {
        this.getText(player).ifPresentOrElse(component -> this.getHologram().getPlugin().supply((Entity)entity, () -> {
            entity.text((Component)Component.empty());
            entity.text(component);
        }), () -> this.getHologram().getPlugin().supply((Entity)entity, () -> entity.text(null)));
    }

    public void updateText() {
        this.entities.forEach((uuid, entity) -> {
            Player player = this.getHologram().getPlugin().getServer().getPlayer(uuid);
            if (player != null) {
                this.updateText(player, (TextDisplay)entity);
            }
        });
    }

    private void updateOpacity(TextDisplay entity) {
        entity.setTextOpacity((byte)Math.round(25.0f + (100.0f - (float)this.opacity) * 2.3f));
    }

    @Override
    public HologramLine copyFrom(HologramLine other) {
        if (other instanceof TextHologramLine) {
            TextHologramLine line = (TextHologramLine)other;
            this.backgroundColor = line.getBackgroundColor().orElse(null);
            this.unparsedText = line.getUnparsedText().orElse(null);
            this.alignment = line.getAlignment();
            this.defaultBackground = line.isDefaultBackground();
            this.seeThrough = line.isSeeThrough();
            this.shadowed = line.isShadowed();
            this.opacity = line.getTextOpacity();
            this.lineWidth = line.getLineWidth();
        }
        return super.copyFrom(other);
    }
}

