/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.google.common.base.Preconditions;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.thenextlvl.hologram.event.HologramPageAddEvent;
import net.thenextlvl.hologram.event.HologramPageChangeEvent;
import net.thenextlvl.hologram.event.HologramPageRemoveEvent;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperBlockHologramLine;
import net.thenextlvl.hologram.models.line.PaperEntityHologramLine;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import net.thenextlvl.hologram.models.line.PaperItemHologramLine;
import net.thenextlvl.hologram.models.line.PaperStaticHologramLine;
import net.thenextlvl.hologram.models.line.PaperTextHologramLine;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperPagedHologramLine
extends PaperHologramLine
implements PagedHologramLine {
    private final List<PaperStaticHologramLine<?>> pages = new CopyOnWriteArrayList();
    private final Map<UUID, Integer> currentPageIndex = new ConcurrentHashMap<UUID, Integer>();
    private final Set<UUID> trackedPlayers = ConcurrentHashMap.newKeySet();
    private final Random random = new Random();
    private final AtomicBoolean cycling = new AtomicBoolean(false);
    private volatile Duration interval = Duration.ofSeconds(2L);
    private volatile boolean paused = false;
    private volatile boolean randomOrder = false;
    private volatile @Nullable ScheduledTask task;

    @Override
    public HologramLine copyFrom(HologramLine other) {
        if (other instanceof PagedHologramLine) {
            PagedHologramLine paged = (PagedHologramLine)other;
            this.despawn();
            this.pages.clear();
            paged.forEachPage(page -> {
                TextHologramLine copy;
                StaticHologramLine staticHologramLine = page;
                Objects.requireNonNull(staticHologramLine);
                StaticHologramLine selector0$temp = staticHologramLine;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextHologramLine.class, ItemHologramLine.class, BlockHologramLine.class, EntityHologramLine.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        TextHologramLine text = (TextHologramLine)selector0$temp;
                        StaticHologramLine staticHologramLine2 = this.addTextPage();
                        break;
                    }
                    case 1: {
                        ItemHologramLine item = (ItemHologramLine)selector0$temp;
                        StaticHologramLine staticHologramLine2 = this.addItemPage();
                        break;
                    }
                    case 2: {
                        BlockHologramLine block = (BlockHologramLine)selector0$temp;
                        StaticHologramLine staticHologramLine2 = this.addBlockPage();
                        break;
                    }
                    case 3: {
                        EntityHologramLine entity = (EntityHologramLine)selector0$temp;
                        StaticHologramLine staticHologramLine2 = this.addEntityPage(page.getEntityType());
                        break;
                    }
                    default: {
                        StaticHologramLine staticHologramLine2 = copy = null;
                    }
                }
                if (copy != null) {
                    copy.copyFrom(page);
                }
            });
            this.interval = paged.getInterval();
            this.paused = paged.isPaused();
            this.randomOrder = paged.isRandomOrder();
        }
        return super.copyFrom(other);
    }

    public PaperPagedHologramLine(PaperHologram hologram) {
        super(hologram);
    }

    @Override
    public Optional<Entity> getEntity(Player player) {
        return this.getCurrentPage(player).flatMap(page -> page.getEntity(player));
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    @Override
    public LineType getType() {
        return LineType.PAGED;
    }

    @Override
    public boolean isPart(Entity entity) {
        return this.pages.stream().anyMatch(page -> page.isPart(entity));
    }

    @Override
    public Stream<StaticHologramLine> getPages() {
        return this.pages.stream().map(page -> page);
    }

    @Override
    public Optional<StaticHologramLine> getPage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return Optional.empty();
        }
        return Optional.of((StaticHologramLine)this.pages.get(index));
    }

    @Override
    public <T extends StaticHologramLine> Optional<T> getPage(int index, Class<T> type) {
        return this.getPage(index).filter(type::isInstance).map(type::cast);
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public int getPageIndex(HologramLine line) {
        int n;
        if (line instanceof PaperStaticHologramLine) {
            PaperStaticHologramLine page = (PaperStaticHologramLine)line;
            n = this.pages.indexOf(page);
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public TextHologramLine addTextPage() {
        return this.addPage(new PaperTextHologramLine(this.getHologram(), this));
    }

    @Override
    public ItemHologramLine addItemPage() {
        return this.addPage(new PaperItemHologramLine(this.getHologram(), this));
    }

    @Override
    public BlockHologramLine addBlockPage() {
        return this.addPage(new PaperBlockHologramLine(this.getHologram(), this));
    }

    @Override
    public EntityHologramLine addEntityPage(EntityType entityType) throws IllegalArgumentException {
        return this.addPage(new PaperEntityHologramLine(this.getHologram(), this, entityType));
    }

    private <T extends PaperStaticHologramLine<?>> T addPage(T page) {
        this.pages.add(page);
        new HologramPageAddEvent(this.getHologram(), this, page).callEvent();
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public boolean removePage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return false;
        }
        PaperStaticHologramLine<?> removed = this.pages.remove(index);
        new HologramPageRemoveEvent(this.getHologram(), this, removed).callEvent();
        removed.despawn();
        return true;
    }

    @Override
    public boolean removePage(HologramLine page) {
        if (!(page instanceof PaperStaticHologramLine)) {
            return false;
        }
        PaperStaticHologramLine paperPage = (PaperStaticHologramLine)page;
        boolean removed = this.pages.remove(paperPage);
        if (removed) {
            new HologramPageRemoveEvent(this.getHologram(), this, paperPage).callEvent();
            paperPage.despawn();
        }
        return removed;
    }

    @Override
    public boolean clearPages() {
        if (this.pages.isEmpty()) {
            return false;
        }
        this.pages.forEach(page -> new HologramPageRemoveEvent(this.getHologram(), this, (StaticHologramLine)page).callEvent());
        this.despawn().thenRun(this.pages::clear);
        return true;
    }

    @Override
    public boolean swapPages(int first, int second) {
        if (first < 0 || first >= this.pages.size() || second < 0 || second >= this.pages.size()) {
            return false;
        }
        Collections.swap(this.pages, first, second);
        this.getHologram().updateHologram();
        return true;
    }

    @Override
    public boolean movePage(int from, int to) {
        if (from < 0 || from >= this.pages.size() || to < 0 || to >= this.pages.size()) {
            return false;
        }
        PaperStaticHologramLine<?> page = this.pages.remove(from);
        this.pages.add(to, page);
        this.getHologram().updateHologram();
        return true;
    }

    @Override
    public TextHologramLine setTextPage(int index) throws IndexOutOfBoundsException {
        return this.setPage(index, () -> new PaperTextHologramLine(this.getHologram(), this));
    }

    @Override
    public ItemHologramLine setItemPage(int index) throws IndexOutOfBoundsException {
        return this.setPage(index, () -> new PaperItemHologramLine(this.getHologram(), this));
    }

    @Override
    public BlockHologramLine setBlockPage(int index) throws IndexOutOfBoundsException {
        return this.setPage(index, () -> new PaperBlockHologramLine(this.getHologram(), this));
    }

    @Override
    public EntityHologramLine setEntityPage(int index, EntityType entityType) throws IllegalArgumentException, IndexOutOfBoundsException {
        return this.setPage(index, () -> new PaperEntityHologramLine(this.getHologram(), this, entityType));
    }

    private <T extends PaperStaticHologramLine<?>> T setPage(int index, Supplier<T> supplier) {
        if (index < 0 || index >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperStaticHologramLine page = (PaperStaticHologramLine)supplier.get();
        this.pages.set(index, page);
        this.getHologram().updateHologram();
        return (T)page;
    }

    @Override
    public TextHologramLine insertTextPage(int index) {
        return this.insertPage(index, () -> new PaperTextHologramLine(this.getHologram(), this));
    }

    @Override
    public ItemHologramLine insertItemPage(int index) {
        return this.insertPage(index, () -> new PaperItemHologramLine(this.getHologram(), this));
    }

    @Override
    public BlockHologramLine insertBlockPage(int index) {
        return this.insertPage(index, () -> new PaperBlockHologramLine(this.getHologram(), this));
    }

    @Override
    public EntityHologramLine insertEntityPage(int index, EntityType entityType) throws IllegalArgumentException {
        return this.insertPage(index, () -> new PaperEntityHologramLine(this.getHologram(), this, entityType));
    }

    private <T extends PaperStaticHologramLine<?>> T insertPage(int index, Supplier<T> supplier) {
        if (index < 0 || index > this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperStaticHologramLine page = (PaperStaticHologramLine)supplier.get();
        this.pages.add(index, page);
        new HologramPageAddEvent(this.getHologram(), this, page).callEvent();
        this.getHologram().updateHologram();
        return (T)page;
    }

    @Override
    public Duration getInterval() {
        return this.interval;
    }

    @Override
    public PagedHologramLine setInterval(Duration interval) {
        Preconditions.checkArgument((boolean)interval.isPositive(), (Object)"Interval must be bigger than zero");
        this.interval = interval;
        return this;
    }

    @Override
    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    @Override
    public PagedHologramLine setRandomOrder(boolean random) {
        this.randomOrder = random;
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public PagedHologramLine setPaused(boolean paused) {
        this.paused = paused;
        if (paused) {
            this.stopCycleTask();
        } else {
            this.startCycleTask();
        }
        return this;
    }

    @Override
    public CompletableFuture<Boolean> cyclePage(Player player) {
        return this.cyclePage(player, 1);
    }

    @Override
    public CompletableFuture<Boolean> cyclePage(Player player, int amount) {
        return this.cyclePage(player, this.calculateOffset(player), amount);
    }

    @Override
    public CompletableFuture<Boolean> setPage(Player player, int page) throws IndexOutOfBoundsException {
        if (page < 0 || page >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + page + ", Size: " + this.pages.size());
        }
        return this.setPage(player, this.calculateOffset(player), this.currentPageIndex.getOrDefault(player.getUniqueId(), 0), page);
    }

    @Override
    public OptionalInt getCurrentPageIndex(Player player) {
        Integer value = this.currentPageIndex.get(player.getUniqueId());
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    @Override
    public Optional<StaticHologramLine> getCurrentPage(Player player) {
        return this.getPage(this.getCurrentPageIndex(player).orElse(0));
    }

    @Override
    public void forEachPage(Consumer<StaticHologramLine> action) {
        this.pages.forEach(action);
    }

    @Override
    public double getHeight(Player player) {
        return this.getCurrentPage(player).map(PaperStaticHologramLine.class::cast).map(page -> page.getHeight(player)).orElse(0.0);
    }

    @Override
    public double getOffsetBefore(Player player) {
        return this.getCurrentPage(player).map(PaperStaticHologramLine.class::cast).map(page -> page.getOffsetBefore(player)).orElse(0.0);
    }

    @Override
    public double getOffsetAfter(Player player) {
        return this.getCurrentPage(player).map(PaperStaticHologramLine.class::cast).map(page -> page.getOffsetAfter(player)).orElse(0.0);
    }

    @Override
    public CompletableFuture<@Nullable Entity> spawn(Player player, double offset) {
        if (this.pages.isEmpty() || !player.isConnected()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((PaperStaticHologramLine)this.getCurrentPage(player).orElseGet(this.pages::getFirst)).spawn(player, offset);
    }

    @Override
    public CompletableFuture<Void> despawn() {
        this.stopCycleTask();
        this.currentPageIndex.clear();
        this.trackedPlayers.clear();
        CompletableFuture[] futures = (CompletableFuture[])this.pages.stream().map(PaperStaticHologramLine::despawn).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<Void> despawn(UUID player) {
        this.untrack(player);
        CompletableFuture[] futures = (CompletableFuture[])this.pages.stream().map(page -> page.despawn(player)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        return CompletableFuture.allOf((CompletableFuture[])this.pages.stream().map(page -> page.teleportRelative(previous, location)).toArray(CompletableFuture[]::new));
    }

    public void untrack(UUID player) {
        if (this.trackedPlayers.remove(player) && this.trackedPlayers.isEmpty()) {
            this.stopCycleTask();
        }
    }

    public void track(UUID player) {
        if (this.trackedPlayers.add(player)) {
            this.startCycleTask();
        }
    }

    @Override
    public void invalidate(Entity entity) {
        this.pages.forEach(page -> page.invalidate(entity));
    }

    private CompletableFuture<Boolean> cyclePage(Player player, double offset, @Nullable Integer amount) {
        if (this.pages.isEmpty() || !player.isConnected()) {
            return CompletableFuture.completedFuture(false);
        }
        int oldIndex = this.currentPageIndex.getOrDefault(player.getUniqueId(), 0);
        int newIndex = this.findVisiblePage(player, oldIndex, amount);
        if (newIndex == -1) {
            return this.despawn(player.getUniqueId()).thenApply(v -> false);
        }
        return this.setPage(player, offset, oldIndex, newIndex);
    }

    private CompletableFuture<Boolean> setPage(Player player, double offset, int oldIndex, int newIndex) {
        HologramPageChangeEvent event;
        if (this.pages.isEmpty() || !player.isConnected()) {
            return CompletableFuture.completedFuture(false);
        }
        PaperStaticHologramLine<?> oldPage = this.pages.size() > oldIndex ? this.pages.get(oldIndex) : null;
        PaperStaticHologramLine<?> newPage = this.pages.get(newIndex);
        if (oldPage != null && !(event = new HologramPageChangeEvent(this.getHologram(), this, player, oldPage, newPage)).callEvent()) {
            return CompletableFuture.completedFuture(false);
        }
        this.currentPageIndex.put(player.getUniqueId(), newIndex);
        if (!this.trackedPlayers.contains(player.getUniqueId())) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Object> adopt = oldPage != null ? newPage.adoptEntities(oldPage, player) : CompletableFuture.completedFuture(null);
        return adopt.thenCompose(v -> this.getHologram().updateHologram(player));
    }

    private void startCycleTask() {
        if (this.task != null || this.paused || this.pages.isEmpty() || this.trackedPlayers.isEmpty()) {
            return;
        }
        long delayTicks = Math.max(1L, this.interval.toMillis() / 50L);
        this.task = this.getHologram().getPlugin().getServer().getRegionScheduler().runDelayed((Plugin)this.getHologram().getPlugin(), this.getHologram().getLocation(), task -> this.tickCycle(), delayTicks);
    }

    private void stopCycleTask() {
        ScheduledTask scheduledTask = this.task;
        if (scheduledTask != null) {
            scheduledTask.cancel();
            this.task = null;
        }
        this.cycling.set(false);
    }

    private void tickCycle() {
        if (!this.cycling.compareAndSet(false, true)) {
            return;
        }
        this.cycleAllPlayers().whenComplete((v, t) -> {
            this.cycling.set(false);
            this.task = null;
            this.startCycleTask();
        });
    }

    private CompletableFuture<Void> cycleAllPlayers() {
        CompletableFuture[] futures = (CompletableFuture[])this.trackedPlayers.stream().map(arg_0 -> ((Server)this.getHologram().getPlugin().getServer()).getPlayer(arg_0)).filter(Objects::nonNull).map(player -> this.cyclePage((Player)player, this.calculateOffset((Player)player), null)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private int findVisiblePage(Player player, int currentIndex, @Nullable Integer amount) {
        int size = this.pages.size();
        if (this.randomOrder && amount == null) {
            ArrayList<Integer> visible = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                if (i == currentIndex || !this.pages.get(i).canSee(player)) continue;
                visible.add(i);
            }
            if (visible.isEmpty()) {
                return -1;
            }
            return (Integer)visible.get(this.random.nextInt(visible.size()));
        }
        int step = amount != null ? amount : 1;
        int direction = step < 0 ? -1 : 1;
        int index = Math.floorMod(currentIndex + step, size);
        for (int i = 0; i < size; ++i) {
            if (this.pages.get(index).canSee(player)) {
                return index;
            }
            index = Math.floorMod(index + direction, size);
        }
        return -1;
    }

    private double calculateOffset(Player player) {
        double offset = 0.0;
        for (HologramLine l : this.getHologram()) {
            if (l == this) {
                return offset;
            }
            PaperHologramLine line = (PaperHologramLine)l;
            offset += 0.05 + line.getHeight(player) + line.getOffsetAfter(player);
        }
        return offset;
    }

    public void addPageInternal(PaperStaticHologramLine<?> hologramLine) {
        hologramLine.parentLine = this;
        this.pages.add(hologramLine);
    }
}

