/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import net.thenextlvl.hologram.models.line.PaperPagedHologramLine;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperItemHologramLine
extends PaperDisplayHologramLine<ItemDisplay>
implements ItemHologramLine {
    private volatile ItemDisplay.ItemDisplayTransform displayTransform = ItemDisplay.ItemDisplayTransform.NONE;
    private volatile @Nullable ItemStack item = null;
    private volatile boolean playerHead = false;

    public PaperItemHologramLine(PaperHologram hologram, @Nullable PaperPagedHologramLine parent) {
        super(hologram, parent, EntityType.ITEM_DISPLAY);
    }

    @Override
    public LineType getType() {
        return LineType.ITEM;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack itemStack = this.item;
        return itemStack != null ? itemStack.clone() : ItemType.AIR.createItemStack();
    }

    @Override
    public boolean setItemStack(@Nullable ItemStack item) {
        return this.set(this.item, item, () -> {
            ItemStack itemStack = this.item = item != null ? item.clone() : null;
            if (!this.playerHead) {
                this.updateItems();
            }
        }, false);
    }

    @Override
    public boolean isPlayerHead() {
        return this.playerHead;
    }

    @Override
    public boolean setPlayerHead(boolean playerHead) {
        return this.set(this.playerHead, playerHead, () -> {
            this.playerHead = playerHead;
            this.updateItems();
        }, false);
    }

    private void updateItems() {
        if (this.playerHead) {
            this.entities.forEach((uuid, entity) -> {
                ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD);
                head.setData(DataComponentTypes.PROFILE, (DataComponentBuilder)ResolvableProfile.resolvableProfile().uuid(uuid));
                entity.setItemStack(head);
            });
        } else {
            this.forEachEntity(entity -> entity.setItemStack(this.item));
        }
    }

    @Override
    public ItemDisplay.ItemDisplayTransform getItemDisplayTransform() {
        return this.displayTransform;
    }

    @Override
    public boolean setItemDisplayTransform(ItemDisplay.ItemDisplayTransform display) {
        return this.set(this.displayTransform, display, () -> {
            this.displayTransform = display;
        }, true);
    }

    @Override
    public double getHeight(Player player) {
        return this.transformation.getScale().y();
    }

    @Override
    public double getOffsetBefore(Player player) {
        return this.getHeight(player) / 2.0;
    }

    @Override
    public double getOffsetAfter(Player player) {
        return -this.getOffsetBefore(player);
    }

    @Override
    protected void preSpawn(ItemDisplay entity, Player player) {
        ItemStack item;
        ItemStack itemStack = item = this.playerHead ? ItemStack.of((Material)Material.PLAYER_HEAD) : this.item;
        if (this.playerHead && item != null) {
            item.setData(DataComponentTypes.PROFILE, (Object)ResolvableProfile.resolvableProfile((PlayerProfile)player.getPlayerProfile()));
        }
        entity.setItemStack(item);
        entity.setItemDisplayTransform(this.displayTransform);
        super.preSpawn(entity, player);
    }

    @Override
    public HologramLine copyFrom(HologramLine other) {
        if (other instanceof ItemHologramLine) {
            ItemHologramLine line = (ItemHologramLine)other;
            this.item = line.getItemStack();
            this.playerHead = line.isPlayerHead();
            this.displayTransform = line.getItemDisplayTransform();
        }
        return super.copyFrom(other);
    }
}

