/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperHologramLine
implements HologramLine {
    protected final Map<String, ClickAction<?>> clickActions = new ConcurrentHashMap();
    private volatile @Nullable String viewPermission;
    private final PaperHologram hologram;

    public PaperHologramLine(PaperHologram hologram) {
        this.hologram = hologram;
    }

    @Override
    public Optional<ClickAction<?>> getAction(String name) {
        return Optional.ofNullable(this.clickActions.get(name));
    }

    @Override
    public boolean addAction(String name, ClickAction<?> action) {
        if (action.equals(this.clickActions.put(name, action))) {
            return false;
        }
        this.hologram.updateHologram();
        return true;
    }

    @Override
    public @Unmodifiable Map<String, ClickAction<?>> getActions() {
        return Map.copyOf(this.clickActions);
    }

    @Override
    public boolean hasAction(ClickAction<?> action) {
        return this.clickActions.containsValue(action);
    }

    @Override
    public boolean hasAction(String name) {
        return this.clickActions.containsKey(name);
    }

    @Override
    public boolean hasActions() {
        return !this.clickActions.isEmpty();
    }

    @Override
    public boolean removeAction(String name) {
        if (this.clickActions.remove(name) == null) {
            return false;
        }
        this.hologram.updateHologram();
        return true;
    }

    @Override
    public void forEachAction(BiConsumer<String, ? super ClickAction<?>> action) {
        this.clickActions.forEach(action);
    }

    @Override
    public Optional<String> getViewPermission() {
        return Optional.ofNullable(this.viewPermission);
    }

    @Override
    public boolean setViewPermission(@Nullable String permission) {
        if (Objects.equals(this.viewPermission, permission)) {
            return false;
        }
        this.viewPermission = permission;
        this.getHologram().updateHologram();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canSee(Player player) {
        if (!this.getWorld().equals((Object)player.getWorld())) return false;
        if (this.getViewPermission().map(arg_0 -> ((Player)player).hasPermission(arg_0)).orElse(true) == false) return false;
        return true;
    }

    @Override
    public PaperHologram getHologram() {
        return this.hologram;
    }

    @Override
    public World getWorld() {
        return this.hologram.getWorld();
    }

    protected <V> boolean set(@Nullable V currentValue, @Nullable V newValue, Runnable setter, boolean update) {
        if (Objects.equals(currentValue, newValue)) {
            return false;
        }
        setter.run();
        if (update) {
            this.hologram.updateHologram();
        }
        return true;
    }

    public abstract double getHeight(Player var1);

    public double getOffsetBefore(Player player) {
        return 0.0;
    }

    public double getOffsetAfter(Player player) {
        return 0.0;
    }

    public abstract CompletableFuture<@Nullable Entity> spawn(Player var1, double var2);

    public abstract CompletableFuture<Void> despawn();

    public abstract CompletableFuture<@Nullable Void> despawn(UUID var1);

    public abstract void invalidate(Entity var1);

    public abstract CompletableFuture<Void> teleportRelative(Location var1, Location var2);

    @Override
    public HologramLine copyFrom(HologramLine other) {
        this.clickActions.clear();
        other.forEachAction((name, action) -> {
            ClickAction a = action;
            this.clickActions.put((String)name, ClickAction.factory().create(a.getActionType(), a.getClickTypes(), a.getInput(), copy -> copy.copyFrom(a)));
        });
        this.viewPermission = other.getViewPermission().orElse(null);
        return this;
    }
}

