/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Optional;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperStaticHologramLine;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperDisplayHologramLine<E extends Display>
extends PaperStaticHologramLine<E>
implements DisplayHologramLine {
    protected volatile // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Display.Brightness brightness = null;
    protected volatile Transformation transformation = new Transformation(new Vector3f(), new AxisAngle4f(), new Vector3f(1.0f), new AxisAngle4f());
    protected volatile float displayHeight = 0.0f;
    protected volatile float displayWidth = 0.0f;
    protected volatile float shadowRadius = 0.0f;
    protected volatile float shadowStrength = 1.0f;
    protected volatile float viewRange = 1.0f;
    protected volatile int interpolationDelay = 0;
    protected volatile int interpolationDuration = 0;
    protected volatile int teleportDuration = 0;

    public PaperDisplayHologramLine(PaperHologram hologram, @Nullable PagedHologramLine parentLine, EntityType entityType) {
        super(hologram, parentLine, entityType);
    }

    @Override
    public Vector3f getOffset() {
        return new Vector3f((Vector3fc)this.transformation.getTranslation());
    }

    @Override
    public boolean setOffset(Vector3f offset) {
        return this.setTransformation(new Transformation(offset, this.transformation.getLeftRotation(), this.transformation.getScale(), this.transformation.getRightRotation()));
    }

    @Override
    public Transformation getTransformation() {
        return new Transformation(this.transformation.getTranslation(), this.transformation.getLeftRotation(), this.transformation.getScale(), this.transformation.getRightRotation());
    }

    @Override
    public boolean setTransformation(Transformation transformation) {
        return this.set(this.transformation, transformation, () -> {
            this.transformation = new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation());
        }, true);
    }

    @Override
    public boolean setTransformationMatrix(Matrix4f transformationMatrix) {
        return this.setTransformation(new Transformation(transformationMatrix.getTranslation(new Vector3f()), transformationMatrix.getRotation(new AxisAngle4f()), transformationMatrix.getScale(new Vector3f()), transformationMatrix.getRotation(new AxisAngle4f())));
    }

    @Override
    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    @Override
    public boolean setInterpolationDuration(int duration) {
        return this.set(this.interpolationDuration, duration, () -> {
            this.interpolationDuration = duration;
            this.forEachEntity(entity -> entity.setInterpolationDuration(duration));
        }, false);
    }

    @Override
    public int getTeleportDuration() {
        return this.teleportDuration;
    }

    @Override
    public boolean setTeleportDuration(int duration) {
        return this.set(this.teleportDuration, duration, () -> {
            this.teleportDuration = duration;
            this.forEachEntity(entity -> entity.setTeleportDuration(duration));
        }, false);
    }

    @Override
    public float getViewRange() {
        return this.viewRange;
    }

    @Override
    public boolean setViewRange(float range) {
        return this.set(Float.valueOf(this.viewRange), Float.valueOf(range), () -> {
            this.viewRange = range;
            this.forEachEntity(entity -> entity.setViewRange(range));
        }, false);
    }

    @Override
    public float getShadowRadius() {
        return this.shadowRadius;
    }

    @Override
    public boolean setShadowRadius(float radius) {
        return this.set(Float.valueOf(this.shadowRadius), Float.valueOf(radius), () -> {
            this.shadowRadius = radius;
            this.forEachEntity(entity -> entity.setShadowRadius(radius));
        }, false);
    }

    @Override
    public float getShadowStrength() {
        return this.shadowStrength;
    }

    @Override
    public boolean setShadowStrength(float strength) {
        return this.set(Float.valueOf(this.shadowStrength), Float.valueOf(strength), () -> {
            this.shadowStrength = strength;
            this.forEachEntity(entity -> entity.setShadowStrength(strength));
        }, false);
    }

    @Override
    public float getDisplayWidth() {
        return this.displayWidth;
    }

    @Override
    public boolean setDisplayWidth(float width) {
        return this.set(Float.valueOf(this.displayWidth), Float.valueOf(width), () -> {
            this.displayWidth = width;
            this.forEachEntity(entity -> entity.setDisplayWidth(width));
        }, false);
    }

    @Override
    public float getDisplayHeight() {
        return this.displayHeight;
    }

    @Override
    public boolean setDisplayHeight(float height) {
        return this.set(Float.valueOf(this.displayHeight), Float.valueOf(height), () -> {
            this.displayHeight = height;
            this.forEachEntity(entity -> entity.setDisplayHeight(height));
        }, true);
    }

    @Override
    public int getInterpolationDelay() {
        return this.interpolationDelay;
    }

    @Override
    public boolean setInterpolationDelay(int ticks) {
        return this.set(this.interpolationDelay, ticks, () -> {
            this.interpolationDelay = ticks;
            this.forEachEntity(entity -> entity.setInterpolationDelay(ticks));
        }, false);
    }

    @Override
    public boolean setBillboard(Display.Billboard billboard) {
        return this.set(this.billboard, billboard, () -> {
            this.billboard = billboard;
            this.forEachEntity(entity -> entity.setBillboard(billboard));
        }, false);
    }

    @Override
    protected void updateGlowColor(@Nullable TextColor color) {
        Color override = color != null ? Color.fromRGB((int)color.value()) : null;
        this.forEachEntity(entity -> entity.setGlowColorOverride(override));
    }

    @Override
    public Optional<Display.Brightness> getBrightness() {
        return Optional.ofNullable(this.brightness);
    }

    @Override
    public boolean setBrightness(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Display.Brightness brightness) {
        return this.set(this.brightness, brightness, () -> {
            this.brightness = brightness;
            this.forEachEntity(entity -> entity.setBrightness(brightness));
        }, false);
    }

    @Override
    protected void preSpawn(E entity, Player player) {
        Color glowColor = this.getGlowColor().map(TextColor::value).map(Color::fromRGB).orElse(null);
        entity.setBillboard(this.billboard);
        entity.setBrightness(this.brightness);
        entity.setDisplayHeight(this.displayHeight);
        entity.setDisplayWidth(this.displayWidth);
        entity.setGlowColorOverride(glowColor);
        entity.setInterpolationDelay(this.interpolationDelay);
        entity.setInterpolationDuration(this.interpolationDuration);
        entity.setShadowRadius(this.shadowRadius);
        entity.setShadowStrength(this.shadowStrength);
        entity.setTeleportDuration(this.teleportDuration);
        entity.setTransformation(this.transformation);
        entity.setViewRange(this.viewRange);
        super.preSpawn(entity, player);
    }

    @Override
    public HologramLine copyFrom(HologramLine other) {
        if (other instanceof DisplayHologramLine) {
            DisplayHologramLine line = (DisplayHologramLine)other;
            this.brightness = line.getBrightness().orElse(null);
            this.displayHeight = line.getDisplayHeight();
            this.displayWidth = line.getDisplayWidth();
            this.interpolationDelay = line.getInterpolationDelay();
            this.interpolationDuration = line.getInterpolationDuration();
            this.shadowRadius = line.getShadowRadius();
            this.shadowStrength = line.getShadowStrength();
            this.teleportDuration = line.getTeleportDuration();
            this.transformation = line.getTransformation();
            this.viewRange = line.getViewRange();
        }
        return super.copyFrom(other);
    }
}

