/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperBlockHologramLine
extends PaperDisplayHologramLine<BlockDisplay>
implements BlockHologramLine {
    private volatile BlockData block = BlockType.AIR.createBlockData();

    public PaperBlockHologramLine(PaperHologram hologram, @Nullable PagedHologramLine parentLine) {
        super(hologram, parentLine, EntityType.BLOCK_DISPLAY);
    }

    @Override
    public LineType getType() {
        return LineType.BLOCK;
    }

    @Override
    public BlockData getBlock() {
        return this.block.clone();
    }

    @Override
    public boolean setBlock(BlockData block) {
        return this.set(this.block, block, () -> {
            this.block = block.clone();
            this.forEachEntity(entity -> entity.setBlock(block));
        }, false);
    }

    @Override
    public double getHeight(Player player) {
        return this.transformation.getScale().y();
    }

    @Override
    protected void preSpawn(BlockDisplay entity, Player player) {
        entity.setBlock(this.block);
        super.preSpawn(entity, player);
    }

    @Override
    public HologramLine copyFrom(HologramLine other) {
        if (other instanceof BlockHologramLine) {
            BlockHologramLine line = (BlockHologramLine)other;
            this.block = line.getBlock().clone();
        }
        return super.copyFrom(other);
    }
}

