/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Position;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.event.HologramLineAddEvent;
import net.thenextlvl.hologram.event.HologramLineRemoveEvent;
import net.thenextlvl.hologram.event.HologramTeleportEvent;
import net.thenextlvl.hologram.event.HologramViewerAddEvent;
import net.thenextlvl.hologram.event.HologramViewerRemoveEvent;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.line.PaperBlockHologramLine;
import net.thenextlvl.hologram.models.line.PaperEntityHologramLine;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import net.thenextlvl.hologram.models.line.PaperItemHologramLine;
import net.thenextlvl.hologram.models.line.PaperPagedHologramLine;
import net.thenextlvl.hologram.models.line.PaperTextHologramLine;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializable;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperHologram
implements Hologram,
TagSerializable<CompoundTag> {
    private final List<HologramLine> lines = new CopyOnWriteArrayList<HologramLine>();
    private final Set<UUID> viewers = new ConcurrentSkipListSet<UUID>();
    private final Set<UUID> spawned = ConcurrentHashMap.newKeySet();
    private final HologramPlugin plugin;
    private volatile String name;
    private volatile Path dataFile;
    private volatile Path backupFile;
    private volatile Location location;
    private volatile @Nullable String viewPermission;
    private volatile boolean persistent = true;
    private volatile boolean visibleByDefault = true;

    public PaperHologram(HologramPlugin plugin, String name, Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World cannot be null");
        this.plugin = plugin;
        this.location = location;
        this.name = name;
        Path dataFolder = plugin.hologramProvider().getDataFolder(location.getWorld());
        this.dataFile = dataFolder.resolve(name + ".dat");
        this.backupFile = dataFolder.resolve(name + ".dat_old");
    }

    public PaperHologram(HologramPlugin plugin, String name, World world) {
        this(plugin, name, new Location(world, 0.0, 0.0, 0.0));
    }

    public HologramPlugin getPlugin() {
        return this.plugin;
    }

    public Stream<? extends Entity> getEntities(Player player) {
        return this.lines.stream().map(hologramLine -> hologramLine.getEntity(player).orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<Hologram> getHologram() {
        return Optional.of(this);
    }

    @Override
    public boolean setName(String name) {
        if (Objects.equals(this.name, name)) {
            return false;
        }
        if (this.plugin.hologramProvider().hasHologram(name)) {
            return false;
        }
        if (!this.updatePaths(this.getWorld(), name)) {
            return false;
        }
        this.name = name;
        this.updateText();
        return true;
    }

    private boolean updatePaths(World world, String name) {
        Path dataFolder = this.plugin.hologramProvider().getDataFolder(world);
        Path dataFile = dataFolder.resolve(name + ".dat");
        Path backupFile = dataFolder.resolve(name + ".dat_old");
        try {
            Files.createDirectories(dataFolder, new FileAttribute[0]);
            if (Files.isRegularFile(this.getDataFile(), new LinkOption[0])) {
                Files.move(this.getDataFile(), dataFile, StandardCopyOption.REPLACE_EXISTING);
            }
            if (Files.isRegularFile(this.getBackupFile(), new LinkOption[0])) {
                Files.move(this.getBackupFile(), backupFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to move hologram data files for: {}", (Object)this.getName(), (Object)e);
            this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/holograms/issues/new?template=bug_report.yml");
            HologramPlugin.ERROR_TRACKER.trackError(e);
            return false;
        }
        this.dataFile = dataFile;
        this.backupFile = backupFile;
        return true;
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    public float getYaw() {
        return this.location.getYaw();
    }

    public float getPitch() {
        return this.location.getPitch();
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    public boolean isInChunk(Chunk chunk) {
        int chunkX = this.location.getBlockX() >> 4;
        int chunkZ = this.location.getBlockZ() >> 4;
        return chunkX == chunk.getX() && chunkZ == chunk.getZ();
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Location previous = this.location;
        HologramTeleportEvent event = new HologramTeleportEvent(this, previous, location);
        if (!event.callEvent()) {
            return CompletableFuture.completedFuture(false);
        }
        Location destination = event.getTo();
        boolean success = this.setLocation(destination);
        if (!success) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.allOf((CompletableFuture[])this.lines.stream().map(PaperHologramLine.class::cast).map(line -> line.teleportRelative(previous, destination)).toArray(CompletableFuture[]::new)).thenApply(v -> true);
    }

    private boolean setLocation(Location location) {
        if (this.location.equals((Object)location)) {
            return false;
        }
        if (this.location.getWorld().equals((Object)location.getWorld())) {
            this.location = location;
            return true;
        }
        if (!this.updatePaths(location.getWorld(), this.name)) {
            return false;
        }
        this.location = location;
        return true;
    }

    @Override
    public Stream<HologramLine> getLines() {
        return this.lines.stream();
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    @Override
    public Optional<HologramLine> getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return Optional.empty();
        }
        return Optional.of(this.lines.get(index));
    }

    @Override
    public <T extends HologramLine> Optional<T> getLine(int index, Class<T> type) {
        return this.getLine(index).filter(type::isInstance).map(type::cast);
    }

    @Override
    public int getLineIndex(HologramLine line) {
        return this.lines.indexOf(line);
    }

    @Override
    public boolean removeLine(HologramLine line) {
        boolean removed = this.lines.remove(line);
        if (removed) {
            new HologramLineRemoveEvent(this, line).callEvent();
            this.despawnLine(line);
        }
        this.updateHologram();
        return removed;
    }

    @Override
    public boolean removeLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return false;
        }
        HologramLine removed = this.lines.remove(index);
        new HologramLineRemoveEvent(this, removed).callEvent();
        this.despawnLine(removed);
        this.updateHologram();
        return true;
    }

    @Override
    public boolean removeLines(Collection<HologramLine> lines) {
        Boolean removed = lines.stream().map(this::removeLine).reduce(false, Boolean::logicalOr);
        if (removed.booleanValue()) {
            this.updateHologram();
        }
        return removed;
    }

    @Override
    public boolean clearLines() {
        if (this.lines.isEmpty()) {
            return false;
        }
        this.lines.forEach(line -> new HologramLineRemoveEvent(this, (HologramLine)line).callEvent());
        this.despawn().thenRun(this.lines::clear);
        return true;
    }

    private CompletableFuture<Void> despawnLine(HologramLine line) {
        return ((PaperHologramLine)line).despawn();
    }

    @Override
    public boolean hasLine(HologramLine line) {
        return this.lines.contains(line);
    }

    @Override
    public boolean moveLine(int line, int index) {
        if (line == index) {
            return false;
        }
        if (line < 0 || line >= this.lines.size()) {
            return false;
        }
        if (index < 0 || index >= this.lines.size()) {
            return false;
        }
        this.lines.add(index, this.lines.remove(line));
        this.updateHologram();
        return true;
    }

    @Override
    public boolean swapLines(int line1, int line2) {
        if (line1 == line2) {
            return false;
        }
        if (line1 < 0 || line1 >= this.lines.size()) {
            return false;
        }
        if (line2 < 0 || line2 >= this.lines.size()) {
            return false;
        }
        HologramLine hologramLine1 = this.lines.get(line1);
        HologramLine hologramLine2 = this.lines.get(line2);
        this.lines.set(line1, hologramLine2);
        this.lines.set(line2, hologramLine1);
        this.updateHologram();
        return true;
    }

    @Override
    public EntityHologramLine addEntityLine(EntityType entityType) throws IllegalArgumentException {
        return this.addEntityLine(this.lines.size(), entityType);
    }

    @Override
    public EntityHologramLine addEntityLine(Class<? extends Entity> entityType) throws IllegalArgumentException {
        return this.addEntityLine(this.lines.size(), entityType);
    }

    @Override
    public EntityHologramLine addEntityLine(int index, EntityType entityType) throws IllegalArgumentException, IndexOutOfBoundsException {
        return this.addLine(index, new PaperEntityHologramLine(this, null, entityType));
    }

    @Override
    public EntityHologramLine addEntityLine(int index, Class<? extends Entity> entityType) throws IllegalArgumentException, IndexOutOfBoundsException {
        return this.addEntityLine(index, HologramPlugin.getEntityType(entityType));
    }

    @Override
    public BlockHologramLine addBlockLine() {
        return this.addBlockLine(this.lines.size());
    }

    @Override
    public BlockHologramLine addBlockLine(int index) throws IndexOutOfBoundsException {
        return this.addLine(index, new PaperBlockHologramLine(this, null));
    }

    @Override
    public ItemHologramLine addItemLine() {
        return this.addItemLine(this.lines.size());
    }

    @Override
    public ItemHologramLine addItemLine(int index) throws IndexOutOfBoundsException {
        return this.addLine(index, new PaperItemHologramLine(this, null));
    }

    @Override
    public TextHologramLine addTextLine() {
        return this.addTextLine(this.lines.size());
    }

    @Override
    public TextHologramLine addTextLine(int index) throws IndexOutOfBoundsException {
        return this.addLine(index, new PaperTextHologramLine(this, null));
    }

    @Override
    public PagedHologramLine addPagedLine() {
        return this.addPagedLine(this.lines.size());
    }

    @Override
    public PagedHologramLine addPagedLine(int index) throws IndexOutOfBoundsException {
        return this.addLine(index, new PaperPagedHologramLine(this));
    }

    private <T extends HologramLine> T addLine(int index, T hologramLine) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.lines.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.lines.size());
        }
        this.lines.add(index, hologramLine);
        new HologramLineAddEvent(this, hologramLine).callEvent();
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public EntityHologramLine setEntityLine(int index, EntityType entityType) throws IllegalArgumentException, IndexOutOfBoundsException {
        return this.setLine(index, () -> new PaperEntityHologramLine(this, null, entityType));
    }

    @Override
    public EntityHologramLine setEntityLine(int index, Class<? extends Entity> entityType) throws IllegalArgumentException, IndexOutOfBoundsException {
        return this.setEntityLine(index, HologramPlugin.getEntityType(entityType));
    }

    @Override
    public BlockHologramLine setBlockLine(int index) throws IndexOutOfBoundsException {
        return this.setLine(index, () -> new PaperBlockHologramLine(this, null));
    }

    @Override
    public ItemHologramLine setItemLine(int index) throws IndexOutOfBoundsException {
        return this.setLine(index, () -> new PaperItemHologramLine(this, null));
    }

    @Override
    public TextHologramLine setTextLine(int index) throws IndexOutOfBoundsException {
        return this.setLine(index, () -> new PaperTextHologramLine(this, null));
    }

    @Override
    public PagedHologramLine setPagedLine(int index) throws IndexOutOfBoundsException {
        return this.setLine(index, () -> new PaperPagedHologramLine(this));
    }

    private <T extends HologramLine> T setLine(int index, Supplier<T> supplier) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.lines.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.lines.size());
        }
        HologramLine line = (HologramLine)supplier.get();
        this.despawnLine(this.lines.set(index, line));
        this.updateHologram();
        return (T)line;
    }

    @Override
    public Optional<String> getViewPermission() {
        return Optional.ofNullable(this.viewPermission);
    }

    @Override
    public boolean setViewPermission(@Nullable String permission) {
        if (Objects.equals(this.viewPermission, permission)) {
            return false;
        }
        this.viewPermission = permission;
        this.updateVisibility();
        return true;
    }

    @Override
    public Stream<Player> getTrackedBy() {
        return this.spawned.stream().map(arg_0 -> ((Server)this.plugin.getServer()).getPlayer(arg_0)).filter(Objects::nonNull);
    }

    @Override
    public @Unmodifiable Set<UUID> getViewers() {
        return Set.copyOf(this.viewers);
    }

    @Override
    public boolean addViewer(UUID player) {
        HologramViewerAddEvent event = new HologramViewerAddEvent(this, player);
        if (!event.callEvent()) {
            return false;
        }
        if (!this.viewers.add(player)) {
            return false;
        }
        if (this.lines.isEmpty() || this.isVisibleByDefault()) {
            return true;
        }
        Player online = this.plugin.getServer().getPlayer(player);
        if (online != null) {
            this.spawn(online);
        }
        return true;
    }

    @Override
    public boolean addViewers(Collection<UUID> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean removeViewer(UUID player) {
        HologramViewerRemoveEvent event = new HologramViewerRemoveEvent(this, player);
        if (!event.callEvent()) {
            return false;
        }
        if (!this.viewers.remove(player)) {
            return false;
        }
        if (this.lines.isEmpty() || this.isVisibleByDefault()) {
            return true;
        }
        Player online = this.plugin.getServer().getPlayer(player);
        if (online != null) {
            this.despawn(online);
        }
        return true;
    }

    @Override
    public boolean removeViewers(Collection<UUID> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean isViewer(UUID player) {
        return this.viewers.contains(player);
    }

    @Override
    public boolean canSee(Player player) {
        if (this.lines.isEmpty()) {
            return false;
        }
        if (!player.getWorld().equals((Object)this.location.getWorld())) {
            return false;
        }
        if (!this.isVisibleByDefault() && !this.isViewer(player.getUniqueId())) {
            return false;
        }
        return this.getViewPermission().map(arg_0 -> ((Player)player).hasPermission(arg_0)).orElse(true);
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    @Override
    public boolean setVisibleByDefault(boolean visible) {
        if (this.visibleByDefault == visible) {
            return false;
        }
        this.visibleByDefault = visible;
        return true;
    }

    @Override
    public boolean setPersistent(boolean persistent) {
        if (this.persistent == persistent) {
            return false;
        }
        this.persistent = persistent;
        return true;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public boolean persist() {
        boolean bl;
        block14: {
            if (!this.isPersistent()) {
                return false;
            }
            Path file = this.getDataFile();
            Path backup = this.getBackupFile();
            if (Files.isRegularFile(file, new LinkOption[0])) {
                Files.move(file, backup, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            NBTOutputStream outputStream = NBTOutputStream.create(file);
            try {
                outputStream.writeTag(this.getName(), this.serialize());
                bl = true;
                if (outputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (Files.isRegularFile(backup, new LinkOption[0])) {
                        try {
                            Files.copy(backup, file, StandardCopyOption.REPLACE_EXISTING);
                            this.plugin.getComponentLogger().warn("Recovered hologram {} from potential data loss", (Object)this.getName());
                        }
                        catch (IOException e) {
                            this.plugin.getComponentLogger().error("Failed to restore hologram {}", (Object)this.getName(), (Object)e);
                        }
                    }
                    this.plugin.getComponentLogger().error("Failed to save hologram {}", (Object)this.getName(), (Object)t);
                    this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/holograms/issues/new?template=bug_report.yml");
                    HologramPlugin.ERROR_TRACKER.trackError(t);
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    @Override
    public Path getDataFile() {
        return this.dataFile;
    }

    @Override
    public Path getBackupFile() {
        return this.backupFile;
    }

    @Override
    public CompletableFuture<Void> spawn() {
        CompletableFuture[] futures = (CompletableFuture[])this.plugin.getServer().getOnlinePlayers().stream().map(this::spawn).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<Boolean> spawn(Player player) {
        return this.spawn(player, false);
    }

    public CompletableFuture<Boolean> spawn(Player player, boolean update) {
        if (!this.location.isChunkLoaded() || !player.isConnected()) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.canSee(player) || this.getLines().noneMatch(line -> line.canSee(player))) {
            return this.despawn(player);
        }
        if (!this.spawned.add(player.getUniqueId()) && !update) {
            return CompletableFuture.completedFuture(false);
        }
        return this.getPlugin().supply(this.location, () -> this.spawnLine(player, this.lines.size() - 1, 0.0)).thenCompose(Function.identity());
    }

    private CompletableFuture<Boolean> spawnLine(Player player, int index, double offset) {
        if (index < 0 || !player.isConnected()) {
            return CompletableFuture.completedFuture(false);
        }
        PaperHologramLine line = (PaperHologramLine)this.lines.get(index);
        double currentOffset = offset + line.getOffsetBefore(player);
        return line.spawn(player, currentOffset).thenCompose(entity -> {
            if (index == 0) {
                return CompletableFuture.completedFuture(entity != null);
            }
            double nextOffset = entity != null ? currentOffset + 0.05 + line.getHeight(player) + line.getOffsetAfter(player) : offset;
            return this.spawnLine(player, index - 1, nextOffset);
        });
    }

    @Override
    public CompletableFuture<Void> despawn() {
        CompletableFuture[] futures = (CompletableFuture[])this.getTrackedBy().map(this::despawn).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<Boolean> despawn(Player player) {
        if (!this.spawned.remove(player.getUniqueId())) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture[] futures = (CompletableFuture[])this.lines.stream().map(PaperHologramLine.class::cast).map(line -> line.despawn(player.getUniqueId())).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(v -> true);
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.spawned.contains(player.getUniqueId());
    }

    @Override
    public boolean isPart(Entity entity) {
        return this.lines.stream().anyMatch(line -> line.isPart(entity));
    }

    @Override
    public Iterator<HologramLine> iterator() {
        return this.lines.iterator();
    }

    public void updateVisibility() {
        this.plugin.getServer().getOnlinePlayers().forEach(this::updateHologram);
    }

    public void updateHologram() {
        this.getTrackedBy().forEach(this::updateHologram);
    }

    public CompletableFuture<Boolean> updateHologram(Player player) {
        return this.spawn(player, true);
    }

    public void updateText() {
        this.lines.forEach(hologramLine -> {
            if (hologramLine instanceof PaperTextHologramLine) {
                PaperTextHologramLine line = (PaperTextHologramLine)hologramLine;
                line.updateText();
            }
        });
    }

    public void updateText(Player player) {
        this.lines.forEach(hologramLine -> {
            if (!(hologramLine instanceof PaperTextHologramLine)) {
                return;
            }
            PaperTextHologramLine line = (PaperTextHologramLine)hologramLine;
            line.getEntity(player, TextDisplay.class).ifPresent(textDisplay -> line.updateText(player, (TextDisplay)textDisplay));
        });
    }

    @Override
    public CompoundTag serialize() throws ParserException {
        NBT nbt = this.plugin.serializer(this.getWorld());
        CompoundTag.Builder builder = CompoundTag.builder();
        builder.put("position", nbt.serialize(this.location));
        builder.put("rotation", CompoundTag.builder().put("yaw", Float.valueOf(this.location.getYaw())).put("pitch", Float.valueOf(this.location.getPitch())).build());
        builder.put("visibleByDefault", this.visibleByDefault);
        this.getViewPermission().ifPresent(permission -> builder.put("viewPermission", (String)permission));
        List<Tag> lines = this.lines.stream().map(nbt::serialize).toList();
        if (!lines.isEmpty()) {
            builder.put("lines", ListTag.of(lines));
        }
        return builder.build();
    }

    @Override
    public void deserialize(CompoundTag tag) throws ParserException {
        NBT nbt = this.plugin.deserializer(this);
        tag.optional("position").map(tag1 -> nbt.deserialize((Tag)tag1, Position.class)).ifPresent(position -> {
            this.location.setX(position.x());
            this.location.setY(position.y());
            this.location.setZ(position.z());
        });
        tag.optional("rotation").map(Tag::getAsCompound).ifPresent(rotation -> {
            rotation.optional("yaw").map(Tag::getAsFloat).ifPresent(arg_0 -> ((Location)this.location).setYaw(arg_0));
            rotation.optional("pitch").map(Tag::getAsFloat).ifPresent(arg_0 -> ((Location)this.location).setPitch(arg_0));
        });
        tag.optional("viewPermission").map(Tag::getAsString).ifPresent(this::setViewPermission);
        tag.optional("visibleByDefault").map(Tag::getAsBoolean).ifPresent(this::setVisibleByDefault);
        tag.optional("lines").map(Tag::getAsList).ifPresent(lines -> lines.stream().map(line -> PaperHologram.deserializeLine(nbt, line)).forEach(this.lines::add));
    }

    public static HologramLine deserializeLine(TagDeserializationContext context, CompoundTag line) {
        LineType type = context.deserialize((Tag)line.get("lineType"), LineType.class);
        return (HologramLine)context.deserialize((Tag)line, (Type)((Object)(switch (type) {
            default -> throw new MatchException(null, null);
            case LineType.ENTITY -> EntityHologramLine.class;
            case LineType.BLOCK -> BlockHologramLine.class;
            case LineType.ITEM -> ItemHologramLine.class;
            case LineType.TEXT -> TextHologramLine.class;
            case LineType.PAGED -> PaperPagedHologramLine.class;
        })));
    }

    @Override
    public Hologram copyFrom(Hologram other) {
        this.despawn();
        this.lines.clear();
        other.forEach(line -> {
            BlockHologramLine hologramLine;
            HologramLine hologramLine2 = line;
            Objects.requireNonNull(hologramLine2);
            HologramLine selector0$temp = hologramLine2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHologramLine.class, BlockHologramLine.class, ItemHologramLine.class, TextHologramLine.class, PagedHologramLine.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    EntityHologramLine entityLine = (EntityHologramLine)selector0$temp;
                    HologramLine hologramLine3 = this.addEntityLine(entityLine.getEntityType());
                    break;
                }
                case 1: {
                    BlockHologramLine blockLine = (BlockHologramLine)selector0$temp;
                    HologramLine hologramLine3 = this.addBlockLine();
                    break;
                }
                case 2: {
                    ItemHologramLine itemLine = (ItemHologramLine)selector0$temp;
                    HologramLine hologramLine3 = this.addItemLine();
                    break;
                }
                case 3: {
                    TextHologramLine textLine = (TextHologramLine)selector0$temp;
                    HologramLine hologramLine3 = this.addTextLine();
                    break;
                }
                case 4: {
                    PagedHologramLine pagedLine = (PagedHologramLine)selector0$temp;
                    HologramLine hologramLine3 = this.addPagedLine();
                    break;
                }
                default: {
                    HologramLine hologramLine3 = hologramLine = null;
                }
            }
            if (hologramLine != null) {
                hologramLine.copyFrom(line);
            }
        });
        this.viewers.clear();
        this.viewers.addAll(other.getViewers());
        this.viewPermission = other.getViewPermission().orElse(null);
        this.persistent = other.isPersistent();
        this.visibleByDefault = other.isVisibleByDefault();
        return this;
    }
}

