/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.locale.store;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.kyori.adventure.internal.Internals;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.TranslationStore;
import net.kyori.adventure.util.TriState;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.thenextlvl.hologram.locale.store.TranslationLocales;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class MutableTranslationStore<T>
implements Examinable,
TranslationStore<T> {
    private final Key name;
    private final Map<String, Translation> translations = new ConcurrentHashMap<String, Translation>();
    private volatile Locale defaultLocale = Locale.US;

    protected MutableTranslationStore(Key name) {
        this.name = name;
    }

    @Nullable
    protected T translationValue(String key, Locale locale) {
        Translation translation = this.translations.get(key);
        if (translation == null) {
            return null;
        }
        return translation.translate(locale);
    }

    public final boolean contains(String key) {
        return this.translations.containsKey(key);
    }

    public final boolean contains(String key, Locale locale) {
        Translation translation = this.translations.get(key);
        if (translation == null) {
            return false;
        }
        return translation.translations.get(locale) != null;
    }

    public final boolean canTranslate(String key, Locale locale) {
        Translation translation = this.translations.get(key);
        if (translation == null) {
            return false;
        }
        return translation.translate(locale) != null;
    }

    public final void defaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public void unregisterAll() {
        this.translations.clear();
    }

    public void unregister(String key, Locale locale) {
        this.translations.computeIfPresent(key, (k, translation) -> {
            translation.translations.remove(locale);
            return translation.translations.isEmpty() ? null : translation;
        });
    }

    public int size() {
        return this.translations.size();
    }

    public final boolean override(String key, Locale locale, T translation) {
        return this.translations.computeIfAbsent(key, x$0 -> new Translation((String)x$0)).override(locale, translation);
    }

    public final void register(String key, Locale locale, T translation) {
        this.translations.computeIfAbsent(key, x$0 -> new Translation((String)x$0)).register(locale, translation);
    }

    public final void registerAll(Locale locale, Map<String, T> translations) {
        this.registerAll(locale, translations.keySet(), translations::get);
    }

    public final void registerAll(Locale locale, Set<String> keys, Function<String, T> function) {
        IllegalArgumentException firstError = null;
        int errorCount = 0;
        for (String key : keys) {
            try {
                this.register(key, locale, function.apply(key));
            }
            catch (IllegalArgumentException e) {
                if (firstError == null) {
                    firstError = e;
                }
                ++errorCount;
            }
        }
        if (firstError != null) {
            if (errorCount == 1) {
                throw firstError;
            }
            if (errorCount > 1) {
                throw new IllegalArgumentException(String.format("Invalid key (and %d more)", errorCount - 1), firstError);
            }
        }
    }

    public final void unregister(String key) {
        this.translations.remove(key);
    }

    public final Key name() {
        return this.name;
    }

    public final TriState hasAnyTranslations() {
        return TriState.byBoolean((!this.translations.isEmpty() ? 1 : 0) != 0);
    }

    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"translations", this.translations));
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MutableTranslationStore)) {
            return false;
        }
        MutableTranslationStore that = (MutableTranslationStore)other;
        return this.name.equals((Object)that.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final String toString() {
        return Internals.toString((Examinable)this);
    }

    public Stream<String> getTranslationKeys() {
        return this.translations.keySet().stream();
    }

    public Map<Locale, T> getTranslations(String key) {
        Translation translation = this.translations.get(key);
        return translation == null ? Map.of() : translation.translations;
    }

    public Map<String, T> getAllTranslations(Locale locale) {
        HashMap map = new HashMap();
        this.translations.values().forEach(translation -> {
            Object t = translation.translations.get(locale);
            if (t != null) {
                map.put(translation.key, t);
            }
        });
        return map;
    }

    public final class Translation
    implements Examinable {
        private final String key;
        private final Map<Locale, T> translations;

        private Translation(String key) {
            this.key = key;
            this.translations = new ConcurrentHashMap();
        }

        @Nullable
        private T translate(Locale locale) {
            Object format = this.translations.get(locale);
            if (format == null && (format = this.translations.get(new Locale.Builder().setLanguage(locale.getLanguage()).build())) == null && (format = this.translations.get(MutableTranslationStore.this.defaultLocale)) == null) {
                format = this.translations.get(TranslationLocales.global());
            }
            return format;
        }

        private void register(Locale locale, T translation) {
            if (this.translations.putIfAbsent(locale, translation) != null) {
                throw new IllegalArgumentException(String.format("Translation already exists: %s for %s", this.key, locale));
            }
        }

        private boolean override(Locale locale, T translation) {
            Object put = this.translations.put(locale, translation);
            return !translation.equals(put);
        }

        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"key", (String)this.key), ExaminableProperty.of((String)"translations", this.translations));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Translation)) {
                return false;
            }
            Translation that = (Translation)other;
            return this.key.equals(that.key) && this.translations.equals(that.translations);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.translations);
        }

        public String toString() {
            return Internals.toString((Examinable)this);
        }
    }

    public static abstract class StringBased<T>
    extends MutableTranslationStore<T>
    implements TranslationStore.StringBased<T> {
        private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("'");

        protected StringBased(Key name) {
            super(name);
        }

        protected abstract T parse(String var1, Locale var2);

        public final void registerAll(Locale locale, Path path, boolean escapeSingleQuotes) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                this.registerAll(locale, new PropertyResourceBundle(reader), escapeSingleQuotes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public final void registerAll(Locale locale, ResourceBundle bundle, boolean escapeSingleQuotes) {
            this.registerAll(locale, bundle.keySet(), key -> {
                String format = bundle.getString((String)key);
                return this.parse(escapeSingleQuotes ? SINGLE_QUOTE_PATTERN.matcher(format).replaceAll("''") : format, locale);
            });
        }
    }
}

